/*
 * Decompiled with CFR 0.152.
 */
package jwrapper.jwutils.eventlog;

public class JWWindowsEventLogRecord {
    public static final int EVENTLOG_SEEK_READ = 2;
    public static final int EVENTLOG_SEQUENTIAL_READ = 1;
    public static final int EVENTLOG_FORWARDS_READ = 4;
    public static final int EVENTLOG_BACKWARDS_READ = 8;
    public static final int EVENTLOG_ERROR_TYPE = 1;
    public static final int EVENTLOG_AUDIT_FAILURE = 16;
    public static final int EVENTLOG_AUDIT_SUCCESS = 8;
    public static final int EVENTLOG_INFORMATION_TYPE = 4;
    public static final int EVENTLOG_WARNING_TYPE = 2;
    public static final int CUSTOMER_BIT_SYSTEM = 0;
    public static final int CUSTOMER_BIT_CUSTOMER = 1;
    public static final int EVENT_ID_SEVERITY_SUCCESS = 0;
    public static final int EVENT_ID_SEVERITY_INFORMATION = 1;
    public static final int EVENT_ID_SEVERITY_WARNING = 16;
    public static final int EVENT_ID_SEVERITY_ERROR = 17;
    long recordNumber;
    long timeGenerated;
    long timeWritten;
    long eventID;
    int eventType;
    int numStrings;
    int eventCategory;
    String[] strings;
    String message;
    String userName;
    String domainName;
    String computerName;
    String source;

    public int getEventIDStatusCode() {
        return (int)(this.eventID & 0xFFFFL);
    }

    public int getEventIDFacilityCode() {
        return (int)(this.eventID >> 16 & 0xFFFL);
    }

    public int getEventIDCustomerBitString() {
        return (int)(this.eventID >> 29 & 1L);
    }

    public int getEventIDSeverity() {
        return (int)(this.eventID >> 30 & 3L);
    }

    public String getEventTypeName() {
        switch (this.eventType) {
            case 1: {
                return "Error";
            }
            case 16: {
                return "Audit Failure";
            }
            case 8: {
                return "Audit Success";
            }
            case 4: {
                return "Information";
            }
            case 2: {
                return "Warning";
            }
        }
        return Integer.toString(this.eventType);
    }

    public String getQualifiedUsername() {
        if (this.domainName == null || this.domainName.length() == 0) {
            return this.userName;
        }
        return this.domainName + "\\" + this.userName;
    }

    public String getMessage() {
        if (this.message != null && this.message.length() > 0) {
            return this.message;
        }
        StringBuffer buffer = new StringBuffer();
        if (this.strings != null) {
            for (int i = 0; i < this.strings.length; ++i) {
                buffer.append("\t").append(i).append(") ").append(this.strings[i]).append("\n");
            }
        }
        return buffer.toString();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Windows Event #").append(this.recordNumber).append(" User:").append(this.getQualifiedUsername()).append(" Generated:").append(this.timeGenerated).append(" Written:").append(this.timeWritten).append("\n");
        buffer.append("\t Computer: ").append(this.computerName).append("\tSource: ").append(this.source).append("\n");
        buffer.append("\t EventID:").append(this.eventID).append(" (EventType:").append(this.getEventTypeName()).append(", EventCategory:").append(this.eventCategory).append(")").append("\n");
        buffer.append("\t EventIDCode:").append(this.getEventIDStatusCode()).append(" EventIDFacility:").append(this.getEventIDFacilityCode()).append(" CustomerBit:").append(this.getEventIDCustomerBitString()).append(" Severity:").append(this.getEventIDSeverity()).append("\n");
        if (this.message != null && this.message.length() > 0) {
            buffer.append("\tMessage: " + this.message);
        } else if (this.strings != null) {
            for (int i = 0; i < this.strings.length; ++i) {
                buffer.append("\t").append(i).append(") ").append(this.strings[i]).append("\n");
            }
        }
        return buffer.toString();
    }

    public String getComputerName() {
        return this.computerName;
    }

    public String getSource() {
        return this.source;
    }

    public int getEventType() {
        return this.eventType;
    }
}

