/*
 * Decompiled with CFR 0.152.
 */
package jwrapper.jwutils;

import java.awt.Frame;
import java.awt.Window;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import jwrapper.hidden.JWNativeAPI;
import jwrapper.jwutils.JWGenericOS;
import jwrapper.jwutils.JWSystem;
import jwrapper.jwutils.JWWindowsRegistry;
import jwrapper.jwutils.eventlog.JWWindowsEventLogRecord;
import jwrapper.updater.GenericUpdater;
import jwrapper.updater.JWLaunchProperties;
import utils.ostools.OS;
import utils.ostools.RunCommandGetOutput;
import utils.string.StringUtil;
import utils.switches.Switches;

public class JWWindowsOS
extends JWGenericOS {
    private HashMap<Long, String> eventLogIDToNameMap = new HashMap();
    public static final int CSIDL_DESKTOP = 0;
    public static final int CSIDL_INTERNET = 1;
    public static final int CSIDL_PROGRAMS = 2;
    public static final int CSIDL_CONTROLS = 3;
    public static final int CSIDL_PRINTERS = 4;
    public static final int CSIDL_PERSONAL = 5;
    public static final int CSIDL_FAVORITES = 6;
    public static final int CSIDL_STARTUP = 7;
    public static final int CSIDL_RECENT = 8;
    public static final int CSIDL_SENDTO = 9;
    public static final int CSIDL_BITBUCKET = 10;
    public static final int CSIDL_STARTMENU = 11;
    public static final int CSIDL_MYDOCUMENTS = 5;
    public static final int CSIDL_MYMUSIC = 13;
    public static final int CSIDL_MYVIDEO = 14;
    public static final int CSIDL_DESKTOPDIRECTORY = 16;
    public static final int CSIDL_DRIVES = 17;
    public static final int CSIDL_NETWORK = 18;
    public static final int CSIDL_NETHOOD = 19;
    public static final int CSIDL_FONTS = 20;
    public static final int CSIDL_TEMPLATES = 21;
    public static final int CSIDL_COMMON_STARTMENU = 22;
    public static final int CSIDL_COMMON_PROGRAMS = 23;
    public static final int CSIDL_COMMON_STARTUP = 24;
    public static final int CSIDL_COMMON_DESKTOPDIRECTORY = 25;
    public static final int CSIDL_APPDATA = 26;
    public static final int CSIDL_PRINTHOOD = 27;
    public static final int CSIDL_LOCAL_APPDATA = 28;
    public static final int CSIDL_ALTSTARTUP = 29;
    public static final int CSIDL_COMMON_ALTSTARTUP = 30;
    public static final int CSIDL_COMMON_FAVORITES = 31;
    public static final int CSIDL_INTERNET_CACHE = 32;
    public static final int CSIDL_COOKIES = 33;
    public static final int CSIDL_HISTORY = 34;
    public static final int CSIDL_COMMON_APPDATA = 35;
    public static final int CSIDL_WINDOWS = 36;
    public static final int CSIDL_SYSTEM = 37;
    public static final int CSIDL_PROGRAM_FILES = 38;
    public static final int CSIDL_MYPICTURES = 39;
    public static final int CSIDL_PROFILE = 40;
    public static final int CSIDL_SYSTEMX86 = 41;
    public static final int CSIDL_PROGRAM_FILESX86 = 42;
    public static final int CSIDL_PROGRAM_FILES_COMMON = 43;
    public static final int CSIDL_PROGRAM_FILES_COMMONX86 = 44;
    public static final int CSIDL_COMMON_TEMPLATES = 45;
    public static final int CSIDL_COMMON_DOCUMENTS = 46;
    public static final int CSIDL_COMMON_ADMINTOOLS = 47;
    public static final int CSIDL_ADMINTOOLS = 48;
    public static final int CSIDL_CONNECTIONS = 49;
    public static final int CSIDL_COMMON_MUSIC = 53;
    public static final int CSIDL_COMMON_PICTURES = 54;
    public static final int CSIDL_COMMON_VIDEO = 55;
    public static final int CSIDL_RESOURCES = 56;
    public static final int CSIDL_RESOURCES_LOCALIZED = 57;
    public static final int CSIDL_COMMON_OEM_LINKS = 58;
    public static final int CSIDL_CDBURN_AREA = 59;
    public static final int CSIDL_COMPUTERSNEARME = 61;

    public static JWWindowsOS getWindowsInstance() {
        return JWGenericOS.winInstance;
    }

    public static void registerURLSchemeForVirtualApp(String schemeProtocol, String virtualApp) throws IOException, InterruptedException {
        File master = JWSystem.getAllAppVersionsSharedFolder().getParentFile();
        String app = JWSystem.getAppBundleName();
        File launcher = new File(master, GenericUpdater.getLauncherNameFor(app, false, false, false, false));
        JWWindowsRegistry.deleteKey("HKEY_CURRENT_USER", "HKEY_CURRENT_USER\\Software\\Classes", schemeProtocol);
        JWWindowsRegistry.regCreateKey("HKEY_CURRENT_USER\\Software\\Classes\\" + schemeProtocol);
        JWWindowsRegistry.regCreateKey("HKEY_CURRENT_USER\\Software\\Classes\\" + schemeProtocol + "\\DefaultIcon");
        JWWindowsRegistry.regCreateKey("HKEY_CURRENT_USER\\Software\\Classes\\" + schemeProtocol + "\\shell\\open\\command");
        JWWindowsRegistry.regSet("HKEY_CURRENT_USER", "Software\\Classes\\" + schemeProtocol, "", "URL:" + schemeProtocol, "REG_SZ");
        JWWindowsRegistry.regSet("HKEY_CURRENT_USER", "Software\\Classes\\" + schemeProtocol, "URL Protocol", "", "REG_SZ");
        JWWindowsRegistry.regSet("HKEY_CURRENT_USER", "Software\\Classes\\" + schemeProtocol + "\\DefaultIcon", "", launcher.getName() + ",1", "REG_SZ");
        JWWindowsRegistry.regSet("HKEY_CURRENT_USER", "Software\\Classes\\" + schemeProtocol + "\\shell\\open\\command", "", "\"" + launcher.getAbsolutePath() + "\" JWVAPP \"" + virtualApp + "\" JW_urlhandler=%1", "REG_SZ");
    }

    @Override
    public boolean is64Bit() {
        return this.is64BitWindowsOS();
    }

    @Override
    public String getHostname() {
        String hostname = JWNativeAPI.getInstance().getHostname();
        if (hostname == null || hostname.length() == 0) {
            return super.getHostname();
        }
        return hostname.trim();
    }

    public RDPSessionInfo[] getRDPSessionInfos() {
        Object[] result = JWNativeAPI.getInstance().getRDPSessions();
        if (result == null) {
            return null;
        }
        int index = 0;
        RDPSessionInfo[] sessionInfos = new RDPSessionInfo[result.length / 2];
        for (int i = 0; i < result.length; i += 2) {
            RDPSessionInfo info = new RDPSessionInfo();
            String source = String.valueOf(result[i]);
            int firstSpace = source.indexOf(32);
            int secondSpace = source.indexOf(32, firstSpace + 1);
            String id = source.substring(0, firstSpace);
            String state = source.substring(firstSpace + 1, secondSpace);
            String name = source.substring(secondSpace + 1);
            info.sessionID = Integer.parseInt(id);
            info.state = Integer.parseInt(state);
            info.winStationName = name;
            String username = "" + result[i + 1];
            if (username != null && username.length() > 0) {
                info.username = String.valueOf(username);
            }
            sessionInfos[index++] = info;
        }
        return sessionInfos;
    }

    public NetworkAdapterInfo[] getNetworkInfo() {
        Object[][] result = JWNativeAPI.getInstance().getNetworkInfo();
        if (result == null) {
            return null;
        }
        NetworkAdapterInfo[] info = new NetworkAdapterInfo[result.length];
        for (int i = 0; i < result.length; ++i) {
            info[i] = new NetworkAdapterInfo();
            info[i].name = "" + result[i][0];
            info[i].description = "" + result[i][1];
            String mac = "" + result[i][2];
            if ((mac = mac.trim()).endsWith(":")) {
                mac = mac.substring(0, mac.length() - 1);
            }
            info[i].macAddress = mac;
            info[i].ipAddress = "" + result[i][3];
            info[i].gatewayAddress = "" + result[i][4];
        }
        return info;
    }

    @Override
    public String getOSNameWithBitness() {
        try {
            if (this.is64BitWindowsOS()) {
                return this.getOSName() + " x64";
            }
            return this.getOSName() + " x86";
        }
        catch (Throwable t) {
            return this.getOSName() + " " + System.getProperty("os.arch");
        }
    }

    @Override
    public String getOSBuild() {
        String build = JWNativeAPI.getInstance().regGet("HKLM", "SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion", "ReleaseID");
        if (build == null || build.length() == 0) {
            build = JWNativeAPI.getInstance().regGet("HKLM", "SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion", "CurrentBuild");
        }
        if (build != null) {
            if (OS.isWindowsXpOr2003() || OS.isWindowsPreXp()) {
                build = build.replace("()", "");
                build = build.replace("(Obsolete data - do not use)", "");
                build = build.trim();
            }
            build = build.trim();
        }
        return build;
    }

    @Override
    public String getOSProductName() {
        try {
            OSVersionInfo info = this.getOSVersionInfo();
            if (info.dwMajorVersion == 10 && info.dwMinorVersion == 0 && info.wProductType == 1) {
                String build = this.getOSBuild();
                if (build == null) {
                    return null;
                }
                if (build.equals("1511")) {
                    return "November Update";
                }
                if (build.equals("1607")) {
                    return "Anniversary Update";
                }
                if (build.equals("1703")) {
                    return "Creators Update";
                }
                if (build.equals("1709")) {
                    return "Fall Creators Update";
                }
                if (build.equals("1803")) {
                    return "April 2018 Update";
                }
                if (build.equals("1809")) {
                    return "October 2018 Update";
                }
                if (build.equals("1903")) {
                    return "May 2019 Update";
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    @Override
    public String getOSName() {
        try {
            OSVersionInfo info = this.getOSVersionInfo();
            if (info.dwMajorVersion == 10 && info.dwMinorVersion == 0 && info.wProductType == 1) {
                return "Windows 10";
            }
            if (info.dwMajorVersion == 10 && info.dwMinorVersion == 0 && info.wProductType != 27) {
                if (info.dwBuildNumber >= 17763) {
                    return "Windows Server 2019";
                }
                return "Windows Server 2016";
            }
            if (info.dwMajorVersion == 6 && info.dwMinorVersion == 3 && info.wProductType == 1) {
                return "Windows 8.1";
            }
            if (info.dwMajorVersion == 6 && info.dwMinorVersion == 3 && info.wProductType != 1) {
                return "Windows Server 2012 R2";
            }
            if (info.dwMajorVersion == 6 && info.dwMinorVersion == 2 && info.wProductType == 1) {
                return "Windows 8";
            }
            if (info.dwMajorVersion == 6 && info.dwMinorVersion == 2 && info.wProductType != 1) {
                return "Windows Server 2012";
            }
            if (info.dwMajorVersion == 6 && info.dwMinorVersion == 1 && info.wProductType == 1) {
                return "Windows 7";
            }
            if (info.dwMajorVersion == 6 && info.dwMinorVersion == 1 && info.wProductType != 1) {
                return "Windows Server 2008 R2";
            }
            if (info.dwMajorVersion == 6 && info.dwMinorVersion == 0 && info.wProductType != 1) {
                return "Windows Server 2008";
            }
            if (info.dwMajorVersion == 6 && info.dwMinorVersion == 0 && info.wProductType == 1) {
                return "Windows Vista";
            }
            if (info.dwMajorVersion == 5 && info.dwMinorVersion == 2 && (info.wSuiteMask & 0x8000) != 0) {
                return "Windows Home Server";
            }
            if (info.dwMajorVersion == 5 && info.dwMinorVersion == 2) {
                return "Windows Server 2003";
            }
            if (info.dwMajorVersion == 5 && info.dwMinorVersion == 1) {
                return "Windows XP";
            }
            if (info.dwMajorVersion == 5 && info.dwMinorVersion == 0) {
                return "Windows 2000";
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return System.getProperty("os.name");
    }

    public OSVersionInfo getOSVersionInfo() {
        OSVersionInfo info = new OSVersionInfo();
        JWNativeAPI.getInstance().getWindowsVersionInfo(info);
        return info;
    }

    public String getEnvShortPath(String env) {
        System.out.println("[JWWindowsOS] Requesting short path for env " + env);
        String s = JWNativeAPI.getInstance().getEnvShortPath(env);
        System.out.println("[JWWindowsOS] Got " + s);
        return s;
    }

    public boolean isProcessDPIAware() {
        return JWNativeAPI.getInstance().isProcessDPIAware();
    }

    public String getShortPathFormatFor(String fullPath) {
        return JWNativeAPI.getInstance().getShortPath(fullPath);
    }

    public boolean setWindowsAppID(String appID) {
        return JWNativeAPI.getInstance().setAppID(appID);
    }

    public String getUserStartMenuProgramsFolder() {
        return JWNativeAPI.getInstance().getWindowsUserProgramsFolder();
    }

    public String getAllUsersStartMenuProgramsFolder() {
        return JWNativeAPI.getInstance().getWindowsAllProgramsFolder();
    }

    public File getAppStartMenuFolder() {
        return this.getStartMenuFolder(JWSystem.getAppBundleName());
    }

    public File getStartMenuFolder(String group) {
        String pfolder;
        if (JWSystem.getInstallType().equalsIgnoreCase("perm_all")) {
            if (OS.isWindows()) {
                pfolder = this.getAllUsersStartMenuProgramsFolder();
                if (pfolder.endsWith(File.separator)) {
                    pfolder = pfolder.substring(0, pfolder.length() - 1);
                }
            } else {
                pfolder = "ERROR - not a windows OS";
            }
        } else {
            pfolder = this.getUserStartMenuProgramsFolder();
            if (pfolder.endsWith(File.separator)) {
                pfolder = pfolder.substring(0, pfolder.length() - 1);
            }
        }
        File startmenu = new File(pfolder);
        if (group == null) {
            return startmenu;
        }
        File appmenu = new File(startmenu, group);
        appmenu.mkdirs();
        return appmenu;
    }

    public void deleteShortcut(File linkfile) throws IOException {
        String linkPath = linkfile.getCanonicalPath();
        if (!linkPath.toLowerCase().endsWith(".lnk")) {
            linkPath = linkPath + ".lnk";
        }
        new File(linkPath).delete();
    }

    public void createShortcut(File linkfile, File target) throws IOException {
        this.createShortcut(linkfile, "", target, "", target, 0);
    }

    public void createShortcut(File linkfile, File target, String args) throws IOException {
        this.createShortcut(linkfile, "", target, args, target, 0);
    }

    public void createShortcut(File linkfile, String linkDesc, File target, String args, File icon, int iconIndex) throws IOException {
        String linkPath = linkfile.getCanonicalPath();
        String targetPath = target.getCanonicalPath();
        String iconPath = icon.getCanonicalPath();
        if (!linkPath.toLowerCase().endsWith(".lnk")) {
            linkPath = linkPath + ".lnk";
        }
        JWNativeAPI.getInstance().createShortcut(linkPath, linkDesc, targetPath, args, iconPath, iconIndex);
    }

    public void createShortcutWithAppID(File linkfile, File target, String appID) throws IOException {
        this.createShortcutWithAppID(linkfile, "", target, "", target, 0, appID);
    }

    public void createShortcutWithAppID(File linkfile, File target, String args, String appID) throws IOException {
        this.createShortcutWithAppID(linkfile, "", target, args, target, 0, appID);
    }

    public void createShortcutWithAppID(File linkfile, String linkDesc, File target, String args, File icon, int iconIndex, String appID) throws IOException {
        String linkPath = linkfile.getCanonicalPath();
        String targetPath = target.getCanonicalPath();
        String iconPath = icon.getCanonicalPath();
        if (!linkPath.toLowerCase().endsWith(".lnk")) {
            linkPath = linkPath + ".lnk";
        }
        JWNativeAPI.getInstance().createShortcutWithID(linkPath, linkDesc, targetPath, args, iconPath, iconIndex, appID);
    }

    public void deleteWebShortcut(File linkfile) throws IOException {
        new File(linkfile + ".url").delete();
    }

    public void createWebShortcut(File linkfile, String targetURL) throws IOException {
        PrintStream out = new PrintStream(new BufferedOutputStream(new FileOutputStream(linkfile + ".url")));
        out.print("[InternetShortcut]\r\n");
        out.print("URL=" + targetURL + "\r\n");
        out.close();
    }

    public void createWebShortcut(File linkfile, String targetURL, File iconFile, int iconIndex) throws IOException {
        PrintStream out = new PrintStream(new BufferedOutputStream(new FileOutputStream(linkfile + ".url")));
        out.print("[InternetShortcut]\r\n");
        out.print("URL=" + targetURL + "\r\n");
        out.print("IconIndex=" + iconIndex + "\r\n");
        out.print("IconFile=" + iconFile.getCanonicalPath() + "\r\n");
        out.close();
    }

    public String getLoggedOnUsername() {
        return JWNativeAPI.getInstance().getUsernameForSession(JWNativeAPI.getInstance().getTsMySessionId());
    }

    public String getLoggedOnUserSID() {
        return JWNativeAPI.getInstance().getSidForUsername(this.getLoggedOnUsername());
    }

    public void setFrameAlwaysOnTop(Frame window) {
        JWNativeAPI.getInstance().setFrameAlwaysOnTop(window);
    }

    public void setWindowAlwaysOnTop(Window window) {
        JWNativeAPI.getInstance().setWindowAlwaysOnTop(window);
    }

    public String getEnvironmentVariable(String name) {
        return JWNativeAPI.getInstance().getWindowsEnv(name);
    }

    public void makeCurrentProcessHighPriority() {
        JWNativeAPI.getInstance().setProcessPriorityHigh(-1);
    }

    public void makeCurrentProcessNormalPriority() {
        JWNativeAPI.getInstance().setProcessPriorityNormal(-1);
    }

    public void makeCurrentProcessLowPriority() {
        JWNativeAPI.getInstance().setProcessPriorityLow(-1);
    }

    public int[] getMouseLocation() {
        return new int[]{JWNativeAPI.getInstance().getPointerX(), JWNativeAPI.getInstance().getPointerY()};
    }

    public int[] getCaretLocation() {
        return new int[]{JWNativeAPI.getInstance().getCaretX(), JWNativeAPI.getInstance().getCaretY()};
    }

    public boolean is64BitWindowsOS() {
        return !JWNativeAPI.getInstance().is32Bit();
    }

    @Override
    public String[] getAllConsoleUsers() {
        int consoleSessionID = JWNativeAPI.getInstance().getTsConsoleSessionId();
        String consoleUser = JWNativeAPI.getInstance().getUsernameForSession(consoleSessionID);
        return new String[]{consoleUser};
    }

    public boolean killProcess(int pid) {
        if (!JWNativeAPI.getInstance().terminateProcess(pid)) {
            if (Switches.SH_1683_terminateWindowsProcUsingTaskillIfNecessary) {
                RunCommandGetOutput.runCommandIgnoreOutput("taskkill.exe /PID " + pid + " /F");
            }
            return false;
        }
        return true;
    }

    public static String getRequestedURL() {
        return JWLaunchProperties.getPropertyPossiblyNull("urlhandler");
    }

    public long openEventLog(String serverName, String sourceName) {
        long id = JWNativeAPI.getInstance().openEventLog(serverName, sourceName);
        this.eventLogIDToNameMap.put(id, sourceName);
        return id;
    }

    public boolean closeEventLog(long eventLogHandle) {
        if (JWNativeAPI.getInstance().closeEventLog(eventLogHandle)) {
            this.eventLogIDToNameMap.remove(eventLogHandle);
            return true;
        }
        return false;
    }

    public long getNumberOfEventLogRecords(long eventLogHandle) {
        return JWNativeAPI.getInstance().getNumberOfEventLogRecords(eventLogHandle);
    }

    public ArrayList<JWWindowsEventLogRecord> readEventLog(long eventLogHandle, int dwReadFlags, int dwRecordOffset, int maxRecordsToReturn) {
        String logName = this.eventLogIDToNameMap.get(eventLogHandle);
        return (ArrayList)JWNativeAPI.getInstance().readEventLog(eventLogHandle, logName, dwReadFlags, dwRecordOffset, maxRecordsToReturn);
    }

    public String[] getEventLogSources() {
        return JWNativeAPI.getInstance().getEventLogSources();
    }

    public String getSpecialFolderPath(int csidlID) {
        return JWNativeAPI.getInstance().getSpecialFolderPath(csidlID);
    }

    public class OSVersionInfo {
        public int dwMajorVersion;
        public int dwMinorVersion;
        public int dwBuildNumber;
        public int dwPlatformId;
        public short wServicePackMajor;
        public short wServicePackMinor;
        public short wSuiteMask;
        public byte wProductType;
    }

    public class NetworkAdapterInfo {
        public String name;
        public String description;
        public String ipAddress;
        public String gatewayAddress;
        public String macAddress;

        public String toString() {
            return this.name + " \\ " + this.description + " \\ " + this.ipAddress + " \\ " + this.gatewayAddress + " \\ " + this.macAddress;
        }
    }

    public static class RDPSessionInfo {
        public int sessionID;
        public int state;
        public String winStationName;
        public String username;

        public String toString() {
            if (this.username != null) {
                return "Session " + this.sessionID + ": " + this.username + " @ " + this.winStationName + " (" + this.state + ")";
            }
            return "Session " + this.sessionID + ": " + this.winStationName + " (" + this.state + ")";
        }

        public String getStateAsString() {
            switch (this.state) {
                case 1: {
                    return "Active";
                }
                case 2: {
                    return "Connected";
                }
                case 3: {
                    return "ConnectQuery";
                }
                case 4: {
                    return "Shadow";
                }
                case 5: {
                    return "Disconnected";
                }
                case 6: {
                    return "Idle";
                }
                case 7: {
                    return "Listen";
                }
                case 8: {
                    return "Reset";
                }
                case 9: {
                    return "Down";
                }
                case 10: {
                    return "Init";
                }
            }
            return null;
        }

        public boolean equals(Object o) {
            if (!(o instanceof RDPSessionInfo)) {
                return false;
            }
            if (o == null) {
                return false;
            }
            RDPSessionInfo info = (RDPSessionInfo)o;
            if (this.sessionID != info.sessionID) {
                return false;
            }
            if (this.state != info.state) {
                return false;
            }
            if (!StringUtil.equal(this.username, info.username)) {
                return false;
            }
            return StringUtil.equal(this.winStationName, info.winStationName);
        }
    }
}

