/*
 * Decompiled with CFR 0.152.
 */
package jwrapper.jwutils;

import java.awt.Image;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import jwrapper.HeadlessOsxUtil;
import jwrapper.jwutils.JWSystem;
import jwrapper.updater.GenericUpdater;
import jwrapper.updater.JWApp;

public class JWSystemUI {
    static Object LOCK = new Object();
    static Image cachedImage;
    static Image cachedBundleImage;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image getMyAppLogoImage() throws IOException {
        Object object = LOCK;
        synchronized (object) {
            if (cachedImage == null) {
                cachedImage = ImageIO.read(new ByteArrayInputStream(JWApp.getMyVirtualApp().getLogoPNG()));
            }
        }
        return cachedImage;
    }

    public static byte[] getMyAppLogoPNG() throws IOException {
        return JWApp.getMyVirtualApp().getLogoPNG();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getMyAppLogoFile() throws IOException {
        Object object = LOCK;
        synchronized (object) {
            File master = JWSystem.getAppFolder().getParentFile();
            File jwAppsFolder = JWApp.getJWAppsFolder(master);
            File icon = new File(jwAppsFolder, GenericUpdater.getIconFileNameFor(JWSystem.getAppBundleName()));
            if (!icon.exists()) {
                BufferedOutputStream fout = new BufferedOutputStream(new FileOutputStream(icon));
                try {
                    fout.write(JWSystemUI.getAppBundleLogoPNG());
                }
                finally {
                    fout.close();
                }
            }
            return icon;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image getAppBundleLogoImage() throws IOException {
        Object object = LOCK;
        synchronized (object) {
            if (cachedBundleImage == null) {
                cachedBundleImage = ImageIO.read(new ByteArrayInputStream(JWSystemUI.getAppBundleLogoPNG()));
            }
        }
        return cachedBundleImage;
    }

    public static byte[] getAppBundleLogoPNG() throws IOException {
        return (byte[])HeadlessOsxUtil.loadPngBytesFromICNS(new File(JWSystem.getAppFolder(), GenericUpdater.getIcnsFileNameFor(JWSystem.getAppBundleName())));
    }
}

