/*
 * Decompiled with CFR 0.152.
 */
package jwrapper.jwutils;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.net.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import jwrapper.IcoPng;
import jwrapper.JWConstants;
import jwrapper.JWParameteriser;
import jwrapper.jwutils.JWMacOS;
import jwrapper.jwutils.JWOsType;
import jwrapper.jwutils.JWSockIPC;
import jwrapper.jwutils.JWSockIPCListener;
import jwrapper.jwutils.prelaunch.JWPrelaunchVerifier;
import jwrapper.jwutils.test.JWTesting;
import jwrapper.logging.StdLogging;
import jwrapper.proxy.JWAsyncProxyDetector;
import jwrapper.proxy.JWDetectedProxy;
import jwrapper.proxy.JWProxyCredentials;
import jwrapper.proxy.JWProxyList;
import jwrapper.updater.GenericUpdater;
import jwrapper.updater.JWApp;
import jwrapper.updater.JWLaunchProperties;
import jwrapper.updater.LaunchFile;
import utils.files.FileUtil;
import utils.ostools.OS;
import utils.string.StringUtil;

public class JWSystem {
    static JWTesting ignore = null;
    static UnlaunchedVapp unlaunched = null;
    private static Object launcher_LOCK = new Object();

    public static void setLastUsedProxyAsDefault() {
        JWDetectedProxy.loadLastDetectedProxy();
    }

    public static boolean detectAndSetProxyFor(URL url, int timeoutMS) {
        return JWAsyncProxyDetector.detectAndSetProxyFor(JWSystem.getAppBundleName(), JWSystem.getAllAppVersionsSharedFolder(), url, timeoutMS);
    }

    public static Proxy getDefaultDetectedProxy() {
        if (JWDetectedProxy.DETECTED_PROXY_OK) {
            return JWDetectedProxy.DETECTED_PROXY;
        }
        return null;
    }

    public static File getMyJreHome() {
        return new File(System.getProperty("java.home"));
    }

    public static File getNativeJavaLauncher() {
        File launcher;
        File wrapperPath;
        String launchedFrom;
        if (OS.isWindows()) {
            File jlauncher = new File(new File(JWSystem.getMyJreHome(), "bin"), "windowslauncher.exe");
            if (jlauncher.exists()) {
                return jlauncher;
            }
        } else if (OS.isMacOS() && OS.isMacOS64bit() && OS.isMacOS1073OrLater() && (launchedFrom = JWLaunchProperties.getProperty("launched_from_dynprops")) != null && (wrapperPath = new File(launchedFrom)).exists() && wrapperPath.getParentFile() != null && (launcher = new File(wrapperPath.getParentFile(), "osxlauncher")).exists()) {
            return launcher;
        }
        return null;
    }

    public static void forkVirtualApp(String virtualAppName) throws Exception {
        JWSystem.forkVirtualApp(virtualAppName, new Properties(), new String[0]);
    }

    public static void prepareForkVirtualApp(String virtualAppName, Properties launchProperties, String[] commandLineArgs) throws Exception {
        JWSystem.prepareOrForkVirtualApp(true, virtualAppName, launchProperties, commandLineArgs, false, false, null, true);
    }

    public static void forkVirtualApp(String virtualAppName, Properties launchProperties, String[] commandLineArgs) throws Exception {
        JWSystem.prepareOrForkVirtualApp(false, virtualAppName, launchProperties, commandLineArgs, false, false, null, true);
    }

    public static void forkVirtualApp(String virtualAppName, Properties launchProperties, String[] commandLineArgs, JWPrelaunchVerifier prelaunchVerifier) throws Exception {
        JWSystem.prepareOrForkVirtualApp(false, virtualAppName, launchProperties, commandLineArgs, false, false, prelaunchVerifier, true);
    }

    public static Properties buildInheritedLaunchProperties(Properties properties, String virtualAppName) {
        return JWSystem.buildInheritedLaunchProperties(properties, virtualAppName, false, true);
    }

    private static Properties buildInheritedLaunchProperties(Properties launchProperties, String virtualAppName, boolean elevateToAdmin, boolean inheritProps) {
        Properties appArgs = JWLaunchProperties.getAsProperties();
        if (appArgs == null || !inheritProps) {
            appArgs = new Properties();
        }
        if (launchProperties != null) {
            Object[] keys = launchProperties.keySet().toArray();
            for (int i = 0; i < keys.length; ++i) {
                String key = (String)keys[i];
                appArgs.put(key, launchProperties.getProperty(key));
                if (key.toLowerCase().indexOf("passw") != -1) {
                    System.out.println("[JWSystem] Adding custom overridden launch prop " + key + " = (contents hidden)");
                    continue;
                }
                System.out.println("[JWSystem] Adding custom overridden launch prop " + key + " = " + launchProperties.getProperty(key));
            }
        }
        if (virtualAppName != null) {
            appArgs.setProperty("gu_virt_app", virtualAppName);
        } else {
            appArgs.setProperty("gu_virt_app", "");
        }
        if (elevateToAdmin) {
            appArgs.setProperty("launch_elevate", Boolean.toString(Boolean.TRUE));
        }
        System.out.println("[JWSystem] Built inherited launch properties: ");
        for (Object key : appArgs.keySet()) {
            String value = String.valueOf(appArgs.get(key));
            if (value != null && value.length() > 300) {
                value = value.substring(0, 300) + "...";
            }
            if (!String.valueOf(key).toLowerCase().contains("passw")) {
                System.out.println("[JWSystem] " + key + "=" + value);
                continue;
            }
            System.out.println("[JWSystem] " + key + "=xxxxxxxx");
        }
        return appArgs;
    }

    public static void forkVirtualApp(String virtualAppName, Properties launchProperties, String[] commandLineArgs, boolean elevateToAdmin, boolean checkForUpdateFirst, JWPrelaunchVerifier prelaunchVerifier) throws Exception {
        JWSystem.prepareOrForkVirtualApp(false, virtualAppName, launchProperties, commandLineArgs, elevateToAdmin, checkForUpdateFirst, prelaunchVerifier, true);
    }

    public static void forkVirtualApp(String virtualAppName, Properties launchProperties, String[] commandLineArgs, boolean elevateToAdmin, boolean checkForUpdateFirst) throws Exception {
        JWSystem.prepareOrForkVirtualApp(false, virtualAppName, launchProperties, commandLineArgs, elevateToAdmin, checkForUpdateFirst, null, true);
    }

    public static void forkVirtualApp(String virtualAppName, Properties launchProperties, String[] commandLineArgs, boolean elevateToAdmin, boolean checkForUpdateFirst, boolean inheritProps) throws Exception {
        JWSystem.prepareOrForkVirtualApp(false, virtualAppName, launchProperties, commandLineArgs, elevateToAdmin, checkForUpdateFirst, null, inheritProps);
    }

    private static void prepareOrForkVirtualApp(boolean prepareOnly, String virtualAppName, Properties launchProperties, String[] commandLineArgs, boolean elevateToAdmin, boolean checkForUpdateFirst, JWPrelaunchVerifier prelaunchVerifier, boolean inheritProps) throws Exception {
        String staticUpdateURL;
        if (launchProperties == null) {
            launchProperties = new Properties();
        }
        launchProperties = (Properties)launchProperties.clone();
        if (JWLaunchProperties.isDynamicUpdateURL()) {
            String dynamicURL = JWSystem.getUpdateURL();
            staticUpdateURL = "D";
            launchProperties.setProperty("update_url", dynamicURL);
        } else {
            staticUpdateURL = JWSystem.getUpdateURL();
        }
        if (prepareOnly) {
            JWSystem.prepareForkVirtualApp(virtualAppName, staticUpdateURL, launchProperties, commandLineArgs, elevateToAdmin, checkForUpdateFirst);
        } else {
            JWSystem.forkVirtualApp(virtualAppName, staticUpdateURL, launchProperties, commandLineArgs, elevateToAdmin, checkForUpdateFirst, prelaunchVerifier, inheritProps);
        }
    }

    public static void prepareForkVirtualApp(String virtualAppName, String staticUpdateURL, Properties launchProperties, String[] commandLineArgs, boolean elevateToAdmin, boolean checkForUpdateFirst) throws Exception {
        String eventuallShowUI = launchProperties.getProperty("show_no_ui");
        if (eventuallShowUI == null) {
            eventuallShowUI = "true";
        }
        launchProperties.setProperty("launch_prepare_only", "true");
        launchProperties.setProperty("show_no_ui", "false");
        launchProperties.setProperty("post_prep_show_ui", eventuallShowUI);
        JWSockIPC.setupForIPC("JWVappPreparation", launchProperties, true);
        System.out.println("[JWSystem] Forking preparatory virtual app");
        JWSystem.forkVirtualApp(virtualAppName, staticUpdateURL, launchProperties, commandLineArgs, elevateToAdmin, checkForUpdateFirst);
        JWSockIPC ipc = JWSockIPC.connectParent("JWVappPreparation", launchProperties);
        ipc.setupMultipleChannels();
        System.out.println("[JWSystem] IPC set up OK to " + ipc);
        if (unlaunched != null) {
            unlaunched.terminate();
        }
        unlaunched = new UnlaunchedVapp(ipc, virtualAppName, staticUpdateURL, launchProperties, commandLineArgs, elevateToAdmin, checkForUpdateFirst);
        ipc.setupPingsAndReportClosure(unlaunched, (short)99, 10000L);
        System.out.println("[JWSystem] Preparatory virtual app ready for future use on " + ipc);
    }

    public static Properties getPreparedForkProperties() {
        try {
            if (unlaunched != null) {
                return JWSystem.unlaunched.launchProperties;
            }
            return null;
        }
        catch (Exception x) {
            return null;
        }
    }

    public static void clearPreparedFork() {
        try {
            if (unlaunched != null) {
                unlaunched.terminate();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        unlaunched = null;
    }

    public static void embedJvmArgs(Properties launchProperties, String[] jvmargs) {
        LaunchFile.embedJvmArgs(launchProperties, jvmargs);
    }

    public static void forkVirtualApp(String virtualAppName, String staticUpdateURL, Properties launchProperties, String[] commandLineArgs, boolean elevateToAdmin, boolean checkForUpdateFirst) throws Exception {
        JWSystem.forkVirtualApp(virtualAppName, staticUpdateURL, launchProperties, commandLineArgs, elevateToAdmin, checkForUpdateFirst, null, true);
    }

    public static void forkVirtualApp(String virtualAppName, String staticUpdateURL, Properties launchProperties, String[] commandLineArgs, boolean elevateToAdmin, boolean checkForUpdateFirst, JWPrelaunchVerifier prelaunchVerifier, boolean inheritProps) throws Exception {
        if (launchProperties == null) {
            launchProperties = new Properties();
        }
        if (commandLineArgs == null) {
            commandLineArgs = new String[]{};
        }
        if (unlaunched != null) {
            System.out.println("[JWSystem] Prepared virtual app found...");
            if (unlaunched.verify(virtualAppName, staticUpdateURL, launchProperties, commandLineArgs, elevateToAdmin, prelaunchVerifier)) {
                System.out.println("[JWSystem] Prepared virtual app is suitable for launching, launching now");
                try {
                    unlaunched.launch(launchProperties, commandLineArgs);
                    System.out.println("[JWSystem] Pre-prepared app launched OK");
                    return;
                }
                catch (Exception x) {
                    System.out.println("[JWSystem] Pre-prepared app failed to launch, will launch from scratch instead");
                    x.printStackTrace();
                }
            } else {
                System.out.println("[JWSystem] Prepared virtual app is not suitable for launching, continuing with full launch");
            }
        }
        if (staticUpdateURL != null && staticUpdateURL.equals("D") && !launchProperties.containsKey("update_url")) {
            System.err.println("[JWSystem] Forking virtual app " + virtualAppName + " with a dynamic update URL but no URL is set in the launch properties.");
        }
        Properties appArgs = JWSystem.buildInheritedLaunchProperties(launchProperties, virtualAppName, elevateToAdmin, inheritProps);
        File jre = JWSystem.getMyJreHome();
        if (JWOsType.isMacOS()) {
            jre = null;
        }
        if (checkForUpdateFirst) {
            LaunchFile.runAutoupdatedVirtualAppFromNoExit(JWSystem.getAppFolder(), appArgs, jre, staticUpdateURL, commandLineArgs, virtualAppName);
        } else {
            LaunchFile.runVirtualAppFromNoExit(JWSystem.getAppFolder(), appArgs, jre, staticUpdateURL, commandLineArgs, virtualAppName, false);
        }
    }

    public static File saveLauncherShortcutForVirtualApp(File dir, String shortcutName, String virtualAppName, Properties launchProperties, boolean elevateToAdmin) throws IOException {
        String app = JWSystem.getAppBundleName();
        File appdir = JWSystem.getAppFolder();
        Properties appArgs = JWSystem.buildInheritedLaunchProperties(launchProperties, virtualAppName, elevateToAdmin, true);
        return GenericUpdater.saveLauncherShortcutForVirtualApp(app, appdir, dir, shortcutName, appArgs, elevateToAdmin);
    }

    public static File getLauncherLocationForVirtualApp(File dir, String shortcutName) {
        String postfix = OS.isWindows() ? ".exe" : (OS.isMacOS() ? ".app" : "");
        return new File(dir, shortcutName + postfix);
    }

    public static String getUpdateURL() {
        return JWLaunchProperties.getProperty("update_url");
    }

    public static void overrideAppBundleUpdateURL(URL url) throws IOException {
        File appdir = JWSystem.getAppFolder();
        File master = appdir.getParentFile();
        File jwdir = JWApp.getJWAppsFolder(master);
        File override = new File(jwdir, GenericUpdater.getUpdateUrlOverrideFileName());
        FileUtil.writeFileAsStringUTF8(override.getAbsolutePath(), url.toString());
        JWLaunchProperties.overrideProperty("update_url", url.toString());
    }

    public static String getSourceLauncherUpdateURL() throws IOException {
        File dynPropsFile = JWSystem.getDynamicPropsFile();
        System.out.println("[JWSystem] Final source launcher path is " + dynPropsFile);
        JWParameteriser jwp = new JWParameteriser();
        Properties props = jwp.getParameters(dynPropsFile);
        return props.getProperty("update_url");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void overrideSourceLauncherUpdateURL(URL url) throws IOException {
        Object object = launcher_LOCK;
        synchronized (object) {
            File dynPropsFile = JWSystem.getDynamicPropsFile();
            System.out.println("[JWSystem] Overriding source launcher update URL at " + dynPropsFile + " with " + url);
            JWParameteriser jwp = new JWParameteriser();
            Properties props = jwp.getParameters(dynPropsFile);
            props.setProperty("update_url", url.toString());
            jwp.setParameters(props, dynPropsFile, true);
        }
    }

    private static File getDynamicPropsFile() {
        String path = JWLaunchProperties.getProperty("launched_from_dynprops");
        if (OS.isWindows()) {
            int last = path.lastIndexOf(58);
            if (last != -1 && last > 1) {
                path = path.substring(last - 1);
                System.out.println("[JWSystem] Trimmed source launcher path to " + path);
            }
        } else if (OS.isMacOS()) {
            File dotApp;
            for (dotApp = new File(path); dotApp != null && !dotApp.getName().endsWith(".app"); dotApp = dotApp.getParentFile()) {
            }
            if (dotApp == null) {
                dotApp = new File(path).getParentFile().getParentFile();
            }
            File paramsFile = JWMacOS.getParameterisationFile(dotApp);
            path = paramsFile.getAbsolutePath();
        }
        return new File(path);
    }

    public static void main(String[] args) {
        File dotApp;
        String s = "/Applications/SimpleHelp Technician.app/Contents/MacOS/osxwrapper";
        for (dotApp = new File(s); dotApp != null && !dotApp.getName().endsWith(".app"); dotApp = dotApp.getParentFile()) {
        }
        if (dotApp == null) {
            dotApp = new File(s).getParentFile().getParentFile();
        }
        File paramsFile = JWMacOS.getParameterisationFile(dotApp);
        s = paramsFile.getAbsolutePath();
        System.out.println(s);
    }

    public static void removeOverrideAppBundleUpdateURL() {
        File appdir = JWSystem.getAppFolder();
        File master = appdir.getParentFile();
        File jwdir = JWApp.getJWAppsFolder(master);
        File override = new File(jwdir, GenericUpdater.getUpdateUrlOverrideFileName());
        override.delete();
    }

    public static File getAppFolder() {
        return new File(JWLaunchProperties.getProperty("app_dir"));
    }

    public static String getAppBundleVersion() {
        return LaunchFile.pickVersionFromAppFolder(JWSystem.getAppFolder());
    }

    public static File getAllAppVersionsSharedFolder() {
        return JWSystem.getAllAppVersionsSharedFolder(JWSystem.getAppFolder().getParentFile());
    }

    public static File getSpecificVersionAppFolder(String version) {
        File appdir = JWSystem.getAppFolder();
        File master = appdir.getParentFile();
        return LaunchFile.getSpecificVersionOf(JWSystem.getAppBundleName(), version, master);
    }

    public static File getAllAppVersionsSharedFolder(File master) {
        File config = new File(master, "JWAppsSharedConfig");
        if (JWTesting.FAKE_CONFIG_FOLDER != null) {
            System.out.println("[JWSystem] Using fake testing config folder name of " + JWTesting.FAKE_CONFIG_FOLDER);
            config = new File(master, JWTesting.FAKE_CONFIG_FOLDER);
        }
        config.mkdirs();
        return config;
    }

    public static File getAllAppLoggingFolder() {
        File logDir = new File(JWSystem.getAppFolder().getParentFile(), "logs");
        logDir.mkdirs();
        return logDir;
    }

    public static String getMyAppName() {
        try {
            return JWApp.getMyVirtualApp().getUserVisibleName();
        }
        catch (Exception x) {
            x.printStackTrace();
            return "ERROR";
        }
    }

    public static byte[] getMyAppLogoICO() throws IOException {
        return JWApp.getMyVirtualApp().getLogoICO();
    }

    public static byte[] getMyAppLogoPNG() throws IOException {
        return JWApp.getMyVirtualApp().getLogoPNG();
    }

    public static byte[] getAppBundleSplashPNG() throws IOException {
        return FileUtil.readFile(new File(JWSystem.getAppFolder(), GenericUpdater.getSplashFileNameFor(JWSystem.getAppBundleName())).getAbsolutePath());
    }

    public static byte[] getAppBundleUninstallerICO() throws IOException {
        IcoPng icp = new IcoPng(new File(JWSystem.getAppFolder(), GenericUpdater.getUninstallerIcopngFileNameFor(JWSystem.getAppBundleName())));
        return icp.getICO();
    }

    public static byte[] getAppBundleUninstallerPNG() throws IOException {
        IcoPng icp = new IcoPng(new File(JWSystem.getAppFolder(), GenericUpdater.getUninstallerIcopngFileNameFor(JWSystem.getAppBundleName())));
        return icp.getPNG();
    }

    public static String getOsxAppDomainName() {
        return JWConstants.buildOsxDomainFromBundle(JWSystem.getAppBundleName());
    }

    public static String getAppBundleName() {
        return JWLaunchProperties.getProperty("app_name");
    }

    public static String getInstallType() {
        return JWLaunchProperties.getProperty("install_type");
    }

    public static String getAppLaunchProperty(String propertyName) {
        return JWLaunchProperties.getProperty(propertyName);
    }

    public static boolean matchingClientToServerVersion() {
        try {
            return JWLaunchProperties.getProperty("match_versions").equalsIgnoreCase("true");
        }
        catch (Exception x) {
            return false;
        }
    }

    public static void loadJWrapperProxies() {
    }

    public static Proxy getJWrapperProxy() {
        if (JWDetectedProxy.DETECTED_PROXY_OK) {
            return JWDetectedProxy.DETECTED_PROXY;
        }
        return null;
    }

    public static JWProxyCredentials.Credentials getJWrapperProxyCredentials() {
        Proxy proxy = JWSystem.getJWrapperProxy();
        if (proxy == null) {
            return null;
        }
        File sharedFolder = JWSystem.getAllAppVersionsSharedFolder();
        File credentialsFile = new File(sharedFolder, "ProxyCredentials");
        JWProxyCredentials credentials = new JWProxyCredentials();
        try {
            credentials.loadFromFile(credentialsFile);
        }
        catch (IOException e) {
            return null;
        }
        return credentials.getCredentialsFor(proxy);
    }

    public static void addAppSpecificProxy(Proxy proxy) throws IOException {
        File appProxies = new File(JWSystem.getAllAppVersionsSharedFolder(), "AppProxies");
        JWProxyList proxyList = new JWProxyList(10);
        proxyList.loadFromFile(appProxies);
        proxyList.addProxyToFront(proxy);
        proxyList.saveToFile(appProxies);
    }

    public static void addAppSpecificProxy(Proxy proxy, String username, String password) throws IOException {
        JWSystem.addAppSpecificProxy(proxy);
        File credentialsFile = new File(JWSystem.getAllAppVersionsSharedFolder(), "ProxyCredentials");
        JWProxyCredentials credentialsList = new JWProxyCredentials();
        credentialsList.loadFromFile(credentialsFile);
        credentialsList.setCredentialsFor(proxy, new JWProxyCredentials.Credentials(username, password));
        credentialsList.saveToFile(credentialsFile);
    }

    public static String[] getSupportedLanguages() {
        String suplangs = JWLaunchProperties.getProperty("supported_langs");
        String[] alllangs = suplangs.split(",");
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < alllangs.length; ++i) {
            String tmp = alllangs[i];
            if ((tmp = tmp.trim()).length() <= 0) continue;
            list.add(tmp);
        }
        String[] ret = new String[list.size()];
        list.toArray(ret);
        return ret;
    }

    public static File getMyLogFile() {
        return StdLogging.getMyLogFile();
    }

    public static void setInitialLogAreaBytes(long b) {
        StdLogging.setInitialLogSize(b);
    }

    public static void setCircularLogAreaBytes(long b) {
        StdLogging.setCircularLogSize(b);
    }

    public static void fetchAuxiliaryArchive(String archiveName) throws Exception {
        GenericUpdater.fetchAuxiliaryArchive(archiveName, false);
    }

    public static void fetchAuxiliaryArchive(String archiveName, boolean redownload) throws Exception {
        GenericUpdater.fetchAuxiliaryArchive(archiveName, redownload);
    }

    public static boolean haveAuxiliaryArchive(String archiveName) {
        return GenericUpdater.haveAuxiliaryArchive(archiveName);
    }

    public static void resetStdinStdout() {
        System.setIn(new FileInputStream(FileDescriptor.in));
        System.setOut(new PrintStream(new FileOutputStream(FileDescriptor.out)));
    }

    static class UnlaunchedVapp
    implements JWSockIPCListener {
        JWSockIPC ipc;
        String vapp;
        String staticUpdateURL;
        Properties launchProperties;
        boolean elevateToAdmin;
        boolean checkForNewVersion;

        public UnlaunchedVapp(JWSockIPC ipc, String vapp, String staticUpdateURL, Properties launchProperties, String[] commandLineArgs, boolean elevateToAdmin, boolean checkForUpdateFirst) {
            this.ipc = ipc;
            this.vapp = vapp;
            this.staticUpdateURL = staticUpdateURL;
            this.launchProperties = launchProperties;
            this.elevateToAdmin = elevateToAdmin;
            this.checkForNewVersion = checkForUpdateFirst;
        }

        public boolean verify(String vvapp, String vstaticUpdateURL, Properties vlaunchProperties, String[] vcommandLineArgs, boolean velevateToAdmin, JWPrelaunchVerifier prelaunchVerifier) {
            String[] additionalPropertiesToCheck;
            Field[] fields;
            if (!StringUtil.equal(this.vapp, vvapp)) {
                System.out.println("[JWSystem] Unable to use prepared virtual app, virtual app name does not match (" + this.vapp + " vs " + vvapp + ")");
                return false;
            }
            if (!StringUtil.equal(this.staticUpdateURL, vstaticUpdateURL)) {
                System.out.println("[JWSystem] Unable to use prepared virtual app, static update URL does not match (" + this.staticUpdateURL + " vs " + vstaticUpdateURL + ")");
                return false;
            }
            if (this.elevateToAdmin != velevateToAdmin) {
                System.out.println("[JWSystem] Unable to use prepared virtual app, elevateToAdmin does not match (" + this.elevateToAdmin + " vs " + velevateToAdmin + ")");
                return false;
            }
            for (Field field : fields = JWLaunchProperties.class.getDeclaredFields()) {
                String name = field.getName();
                if (!name.startsWith("PROP_")) continue;
                System.out.println("[JWSystem] Verifying " + name + "...");
                if (StringUtil.equal(this.launchProperties.getProperty(name), vlaunchProperties.getProperty(name))) continue;
                System.out.println("[JWSystem] Unable to use prepared virtual app, GU-intereprted launch properties do not match (" + name + " = " + this.launchProperties.getProperty(name) + " vs " + vlaunchProperties.getProperty(name) + ")");
                return false;
            }
            for (String s : additionalPropertiesToCheck = new String[]{"launch_in_specific_session", "launch_in_session"}) {
                if (StringUtil.equal(this.launchProperties.getProperty(s), vlaunchProperties.getProperty(s))) continue;
                System.out.println("[JWSystem] Unable to use prepared virtual app, GU-intereprted launch properties do not match (" + s + " = " + this.launchProperties.getProperty(s) + " vs " + vlaunchProperties.getProperty(s) + ")");
                return false;
            }
            if (this.checkForNewVersion) {
                // empty if block
            }
            return prelaunchVerifier == null || prelaunchVerifier.usePrelaunchedApp(this.launchProperties, vlaunchProperties);
        }

        public void launch(Properties launchProps, String[] commandLineArgs) throws IOException {
            unlaunched = null;
            System.out.println("[JWSystem] Attempting to launch pre-prepared virtual app on " + this.ipc);
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            launchProps.store(bout, "");
            DataOutputStream dout = new DataOutputStream(this.ipc.getOutChannel((short)0));
            dout.writeInt(bout.size());
            dout.write(bout.toByteArray());
            dout.flush();
            dout.writeInt(commandLineArgs.length);
            for (String cmd : commandLineArgs) {
                dout.writeUTF(cmd);
                dout.flush();
            }
            dout.flush();
            System.out.println("[JWSystem] Sent IPC properties");
            DataInputStream din = new DataInputStream(this.ipc.getInChannel((short)0));
            if (din.readInt() != 123456) {
                System.out.println("[JWSystem] IPC launch failed");
                throw new IOException("IPC launch failed");
            }
            System.out.println("[JWSystem] IPC launch reported as successful");
            try {
                this.ipc.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void terminate() {
            try {
                this.ipc.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this == unlaunched) {
                unlaunched = null;
            }
        }

        @Override
        public void ipcClosed() {
            this.terminate();
        }
    }
}

