/*
 * Decompiled with CFR 0.152.
 */
package jwrapper.cmdline;

import java.util.Properties;
import jwrapper.allplatformwrapper.AllPlatformWrapper;
import jwrapper.appletwrapper.JWAppletWrapper;
import jwrapper.updater.JWLaunchProperties;

public class JWCommandLineWrapper {
    public static final String INSTALL_TYPE_ALL_USERS = "perm_all";
    public static final String INSTALL_TYPE_CURRENT_USER = "perm_user";
    public static final String INSTALL_TYPE_TEMPORARY = "temp_user";
    Properties lprops = new Properties();
    Properties rprops = new Properties();
    String oVapp;
    String oupdateURL;
    String oApp;
    boolean oMatch;
    String oInstall;

    public void setLaunchProperties(Properties props) {
        this.lprops = props;
    }

    public void setElevate(boolean elevate) {
        this.rprops.setProperty("launch_elevate", elevate + "");
    }

    public void setVirtualApp(String vapp) {
        this.rprops.setProperty("gu_virt_app", vapp);
    }

    public void overrideUpdateURL(String url) {
        this.oupdateURL = url;
    }

    public void overrideApp(String appName, boolean matchAppVersionToServer, String installType) {
        this.oApp = appName;
        this.oMatch = matchAppVersionToServer;
        this.oInstall = installType;
    }

    public void updateAndLaunchAppNow() {
        this.launch();
    }

    private void launch() {
        JWAppletWrapper jwa = new JWAppletWrapper();
        String updateURL = jwa.getStaticProperty("update_url");
        if (this.oupdateURL != null) {
            updateURL = this.oupdateURL;
        }
        jwa.init();
        jwa.setCmdlineURL(updateURL);
        JWLaunchProperties.addAllProperties(this.lprops, this.rprops);
        jwa.setCmdlineLaunchProps(this.lprops);
        if (this.oApp != null) {
            jwa.setCmdlineApp(this.oApp, this.oMatch, this.oInstall);
        }
        if (JWLaunchProperties.isNonEmpty(this.lprops.getProperty("splash_image"))) {
            jwa.setCmdlineBase64SplashPNG(this.lprops.getProperty("splash_image"));
        }
        jwa.loadProperties();
        jwa.launchNow();
    }

    public static void main(String[] args) {
        System.out.println("Usage: JWCommandLineWrapper <Optional Update URL>");
        AllPlatformWrapper.APW_REDIRECT_TO_LOG = true;
        JWCommandLineWrapper jwc = new JWCommandLineWrapper();
        if (args.length > 0) {
            jwc.overrideUpdateURL(args[0]);
        }
        jwc.launch();
    }
}

