/*
 * Decompiled with CFR 0.152.
 */
package jwrapper;

import java.io.File;
import java.lang.reflect.Method;
import jwrapper.legacyutils.JREFinder;
import jwrapper.legacyutils.VMStateUtil;

public class JWrapper {
    public static void main(String[] args) throws Exception {
        String osname = System.getProperty("os.name");
        boolean isWindows = osname.contains("Windows");
        try {
            Class<?> cl = Class.forName("jwrapper.JWrapperMain");
            Method method = cl.getMethod("main", String[].class);
            method.invoke(null, new Object[]{args});
        }
        catch (UnsupportedClassVersionError t) {
            System.out.println("[JWrapper] Class version error detected (" + t.getMessage() + "). Handling SH-2096 (part 2).");
            t.printStackTrace();
            VMStateUtil vmStateUtil = new VMStateUtil("jwrapper.JWrapper", args);
            File latestJREHome = JREFinder.getLatestJREHome();
            File existingJREHome = new File(vmStateUtil.getJavaExecutable()).getParentFile();
            System.out.println("[JWrapper] Latest JRE: " + latestJREHome);
            System.out.println("[JWrapper] Existing JRE: " + existingJREHome);
            if (latestJREHome.getCanonicalFile().equals(existingJREHome.getCanonicalFile())) {
                throw t;
            }
            vmStateUtil.setJavaHome(latestJREHome);
            int ret = vmStateUtil.fork(true);
            System.exit(ret);
        }
    }
}

