/*
 * Decompiled with CFR 0.152.
 */
package bcutil;

import bcutil.BCUtil;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import utils.stream.OpenByteArrayOutputStream;

public class BCUtilInputStream
extends InputStream {
    private byte[] markerBuffer = null;
    private byte[] marker;
    private long minBytesBetweenMarker;
    private long bytesReadSinceLastMarker;
    private DataInputStream in;
    private BCUtil bcu;
    private int cptr = 0;
    private int clen = 0;
    private byte[] chunk = new byte[0];
    private OpenByteArrayOutputStream interim = new OpenByteArrayOutputStream();
    private byte[] buffer = new byte[200000];
    private OpenByteArrayOutputStream plain = new OpenByteArrayOutputStream();

    public BCUtilInputStream(InputStream in, BCUtil bcu) {
        this.in = new DataInputStream(in);
        this.bcu = bcu;
    }

    public BCUtilInputStream(InputStream in, BCUtil bcu, byte[] marker, long minBytesBetweenMarker) {
        this(in, bcu);
        this.marker = marker;
        this.minBytesBetweenMarker = minBytesBetweenMarker;
        if (marker != null) {
            this.markerBuffer = new byte[marker.length];
        }
    }

    @Override
    public int read() throws IOException {
        if (this.readNextChunk() == -1) {
            return -1;
        }
        return 0xFF & this.chunk[this.cptr++];
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.readNextChunk() == -1) {
            return -1;
        }
        int rem_clen = this.clen - this.cptr;
        int minlen = Math.min(len, rem_clen);
        System.arraycopy(this.chunk, this.cptr, b, off, minlen);
        this.cptr += minlen;
        return minlen;
    }

    public int readNextChunk() throws IOException {
        if (this.cptr < this.clen) {
            return 0;
        }
        try {
            int n = this.readChunk();
            if (n == -1) {
                return -1;
            }
            while (this.plain.size() == 0) {
                n = this.readChunk();
                if (n != -1) continue;
                return -1;
            }
            this.chunk = this.plain.getByteArray();
            this.cptr = 0;
            this.clen = this.plain.size();
            return this.plain.size();
        }
        catch (EOFException e) {
            return -1;
        }
    }

    private int readChunk() throws IOException {
        this.interim.reset();
        this.plain.reset();
        if (this.marker != null && this.bytesReadSinceLastMarker > this.minBytesBetweenMarker) {
            this.in.read(this.markerBuffer);
            this.bytesReadSinceLastMarker = 0L;
        }
        int read = this.bcu.unwrapHighPerformance(this.in, this.interim, this.buffer, this.plain);
        if (this.marker != null && read > -1) {
            this.bytesReadSinceLastMarker += (long)read;
        }
        return read;
    }
}

