/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.layout;

import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import utils.swing.customlaf.SHBorderFactory;

public class BorderPanel
extends JPanel {
    private Border space = null;

    public BorderPanel() {
        this((Insets)null);
    }

    public BorderPanel(Insets insets) {
        super.setLayout(new BorderLayout());
        this.space = this.getBorderFor(insets);
    }

    private Border getBorderFor(Insets insets) {
        if (insets == null) {
            return null;
        }
        return SHBorderFactory.createEmptyBorder(insets.top, insets.left, insets.bottom, insets.right);
    }

    @Override
    public void setLayout(LayoutManager mgr) {
    }

    public void addNorth(JComponent comp) {
        this.addTo("North", comp, this.space);
    }

    public void addNorth(JComponent comp, Insets insets) {
        this.addTo("North", comp, this.getBorderFor(insets));
    }

    public void addSouth(JComponent comp) {
        this.addTo("South", comp, this.space);
    }

    public void addSouth(JComponent comp, Insets insets) {
        this.addTo("South", comp, this.getBorderFor(insets));
    }

    public void addEast(JComponent comp) {
        this.addTo("East", comp, this.space);
    }

    public void addEast(JComponent comp, Insets insets) {
        this.addTo("East", comp, this.getBorderFor(insets));
    }

    public void addWest(JComponent comp) {
        this.addTo("West", comp, this.space);
    }

    public void addWest(JComponent comp, Insets insets) {
        this.addTo("West", comp, this.getBorderFor(insets));
    }

    public void addCenter(JComponent comp) {
        this.addTo("Center", comp, this.space);
    }

    public void addCenter(JComponent comp, Insets insets) {
        this.addTo("Center", comp, this.getBorderFor(insets));
    }

    private void addTo(String name, JComponent comp, Border space) {
        if (space != null) {
            JPanel tmp = new JPanel();
            tmp.setOpaque(comp.isOpaque());
            tmp.setBackground(comp.getBackground());
            tmp.setLayout(new GridLayout(1, 1));
            if (space != null) {
                tmp.setBorder(space);
            }
            tmp.add(comp);
            super.add(name, tmp);
        } else {
            super.add(name, comp);
        }
    }
}

