/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.dialog.panels;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComponent;
import utils.swing.SwingUtil;
import utils.swing.dialog.panels.AbstractDialogPanel;

public class MultiChoiceDialogPanel
extends AbstractDialogPanel
implements ActionListener {
    private ArrayList<JButton> buttons = new ArrayList();
    private int choice = -1;

    public MultiChoiceDialogPanel(String[] options) {
        for (int i = 0; i < options.length; ++i) {
            JButton jButton = this.addRightButton(options[i], i == 0, this);
            this.buttons.add(jButton);
            jButton.addActionListener(this);
        }
        int min = -1;
        int max = -1;
        for (JButton button : this.buttons) {
            int w = button.getPreferredSize().width;
            if (min == -1) {
                min = w;
                max = w;
                continue;
            }
            min = Math.min(w, min);
            max = Math.max(w, max);
        }
        if ((double)(max - min) < 0.8 * (double)min) {
            SwingUtil.setSizesToWidest(this.buttons.toArray(new JButton[0]));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JButton) {
            this.buttonPressed((JButton)e.getSource());
        }
    }

    public JComponent getInitialFocusComponent() {
        return this.buttons.get(0);
    }

    private void buttonPressed(JButton e) {
        this.choice = -1;
        for (int i = 0; i < this.buttons.size(); ++i) {
            if (this.buttons.get(i) != e) continue;
            this.choice = i;
        }
        this.finish(e);
    }

    public int getChoice() {
        return this.choice;
    }

    private void finish(JComponent source) {
        if (this.dialogHandler != null) {
            this.dialogHandler.closeDialog(source);
        }
    }

    public void setOkEnabled(boolean okEnabled) {
        for (JButton button : this.buttons) {
            button.setEnabled(okEnabled);
            button.repaint();
        }
    }
}

