/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.cui.validators;

import utils.swing.cui.validators.AbstractTextFieldValidator;

public class TextFieldIntegerRangeValidator
extends AbstractTextFieldValidator {
    private int minIncluding;
    private int maxIncluding;

    public TextFieldIntegerRangeValidator(int minIncluding, int maxIncluding) {
        this.minIncluding = minIncluding;
        this.maxIncluding = maxIncluding;
    }

    @Override
    protected boolean isValid(String contents) {
        try {
            int val = Integer.parseInt(contents);
            return val >= this.minIncluding && val <= this.maxIncluding;
        }
        catch (Throwable t) {
            return false;
        }
    }

    @Override
    public String getValidatorID() {
        return "textFieldIntegerRange";
    }

    @Override
    public String toXML() {
        return "<Validator type=\"" + this.getValidatorID() + "\" from=\"" + this.minIncluding + "\" to=\"" + this.maxIncluding + "\"/>";
    }
}

