/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.browser;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import utils.swing.browser.ReadThread;

public class MacBrowser {
    private static ClassLoader nsWorkspaceLoader;

    private static boolean openMacNSWorkspaceURL(URL url) throws Exception {
        Class<?> nsWorkspaceClass;
        block3: {
            nsWorkspaceClass = null;
            try {
                nsWorkspaceClass = Class.forName("com.apple.cocoa.application.NSWorkspace");
            }
            catch (ClassNotFoundException ex) {
                if (!new File("/System/Library/Java/com/apple/cocoa/application/NSWorkspace.class").exists()) break block3;
                if (nsWorkspaceLoader == null) {
                    nsWorkspaceLoader = new URLClassLoader(new URL[]{new File("/System/Library/Java").toURL()});
                }
                nsWorkspaceClass = Class.forName("com.apple.cocoa.application.NSWorkspace", true, nsWorkspaceLoader);
            }
        }
        Method sharedWorkspace = nsWorkspaceClass.getMethod("sharedWorkspace", new Class[0]);
        Object workspace = sharedWorkspace.invoke(null, new Object[0]);
        Method openURL = nsWorkspaceClass.getMethod("openURL", URL.class);
        Boolean success = (Boolean)openURL.invoke(workspace, url);
        return success;
    }

    private static boolean openMacMRJURL(URL url) throws Exception {
        Class<?> mrjFileUtils = Class.forName("com.apple.mrj.MRJFileUtils");
        Method openURL = mrjFileUtils.getMethod("openURL", String.class);
        openURL.invoke(null, url);
        return true;
    }

    private static boolean openMacOpenURL(URL url) throws Exception {
        Process process = Runtime.getRuntime().exec("which open");
        ReadThread thread1 = new ReadThread(process.getInputStream());
        ReadThread thread2 = new ReadThread(process.getErrorStream());
        thread1.start();
        thread2.start();
        if (process.waitFor() == 0) {
            process = Runtime.getRuntime().exec("open " + url);
            thread1 = new ReadThread(process.getInputStream());
            thread2 = new ReadThread(process.getErrorStream());
            thread1.start();
            thread2.start();
            process.waitFor();
            return true;
        }
        return false;
    }

    public static void openURL(URL url) throws Exception {
        try {
            if (MacBrowser.openMacNSWorkspaceURL(url)) {
                return;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (MacBrowser.openMacMRJURL(url)) {
                return;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (MacBrowser.openMacOpenURL(url)) {
                return;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        throw new Exception("[MacBrowser] Unable to open URL in browser...");
    }
}

