/*
 * Decompiled with CFR 0.152.
 */
package utils.swing;

import java.awt.Dimension;

public class DimensionUtil {
    private static double getRatio(double original, double bound) {
        return bound / original;
    }

    private static double getScaleFactorToFit(Dimension original, Dimension toFit) {
        double dScale = 1.0;
        if (original != null && toFit != null) {
            double dScaleWidth = DimensionUtil.getRatio(original.width, toFit.width);
            double dScaleHeight = DimensionUtil.getRatio(original.height, toFit.height);
            dScale = Math.min(dScaleHeight, dScaleWidth);
        }
        return dScale;
    }

    public static Dimension getScaledDimension(Dimension original, Dimension bound, boolean scaleUp) {
        double factor = DimensionUtil.getScaleFactorToFit(original, bound);
        if (factor < 1.0 || scaleUp) {
            return new Dimension((int)(original.getWidth() * factor), (int)(original.getHeight() * factor));
        }
        return original;
    }
}

