/*
 * Decompiled with CFR 0.152.
 */
package utils.progtools;

import java.util.TimeZone;

public final class TimeConverter {
    public static final TimeZone utcTZ = TimeZone.getTimeZone("UTC");

    public static long toLocalTime(long time, TimeZone to) {
        return TimeConverter.convertTime(time, utcTZ, to);
    }

    public static long toUTC(long time, TimeZone from) {
        return TimeConverter.convertTime(time, from, utcTZ);
    }

    public static long convertTime(long time, TimeZone from, TimeZone to) {
        return time + TimeConverter.getTimeZoneOffset(time, from, to);
    }

    private static long getTimeZoneOffset(long time, TimeZone from, TimeZone to) {
        int fromOffset = from.getOffset(time);
        int toOffset = to.getOffset(time);
        int diff = 0;
        if (fromOffset >= 0) {
            toOffset = toOffset > 0 ? -1 * toOffset : Math.abs(toOffset);
            diff = (fromOffset + toOffset) * -1;
        } else {
            if (toOffset <= 0) {
                toOffset = -1 * Math.abs(toOffset);
            }
            diff = Math.abs(fromOffset) + toOffset;
        }
        return diff;
    }
}

