/*
 * Decompiled with CFR 0.152.
 */
package utils.files;

import java.io.File;

public class PathUtil {
    public static File replaceSuffix(File orig, String suffix) {
        String path = orig.getPath();
        int index = path.lastIndexOf(46);
        if (index != -1) {
            path = path.substring(0, index);
            if (suffix.length() != 0) {
                path = suffix.startsWith(".") ? path + suffix : path + "." + suffix;
            }
        }
        return new File(path);
    }

    public static boolean containsDotDot(String path) {
        String[] components;
        path = PathUtil.makePathForwardSlashes(path);
        for (String comp : components = path.split("/")) {
            if (!comp.equals("..")) continue;
            return true;
        }
        return false;
    }

    public static String makePathNonWindows(String path) {
        path = path.replace('\\', '/');
        return path;
    }

    public static String makePathNative(String path) {
        path = path.replace('\\', File.separatorChar);
        path = path.replace('/', File.separatorChar);
        return path;
    }

    public static String makePathForwardSlashes(String path) {
        path = path.replace('\\', '/');
        return path;
    }

    public static String removeTrailing(String path) {
        if (path.endsWith("\\") || path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static String ensureTrailing(String path) {
        return PathUtil.removeTrailing(path) + File.separator;
    }

    public static String ensureTrailingFwd(String path) {
        return PathUtil.removeTrailing(path) + "/";
    }

    public static String ensureTrailingBwd(String path) {
        return PathUtil.removeTrailing(path) + "\\";
    }

    public static void main(String[] args) {
        PathUtil.containsDotDot("././../");
        PathUtil.containsDotDot("..//./one/");
        PathUtil.containsDotDot("/././.two./");
        PathUtil.containsDotDot("/././.two../");
        PathUtil.containsDotDot("..");
        PathUtil.containsDotDot("/..");
        PathUtil.containsDotDot("../");
    }
}

