/*
 * Decompiled with CFR 0.152.
 */
package utils.files;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import utils.files.AtomicFileOutputStream;
import utils.stream.StreamPiper;
import utils.stream.StreamUtils;

public class FileUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadFile(URL url, File targetFile) throws IOException {
        BufferedOutputStream out = null;
        InputStream in = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(targetFile), 10000);
            FileUtil.downloadFile(url, out);
        }
        catch (Throwable throwable) {
            FileUtil.robustClose(out);
            FileUtil.robustClose(in);
            throw throwable;
        }
        FileUtil.robustClose(out);
        FileUtil.robustClose(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long downloadFile(URL url, OutputStream out) throws IOException {
        long size = 0L;
        URLConnection conn = url.openConnection();
        BufferedInputStream in = new BufferedInputStream(conn.getInputStream(), 10000);
        try {
            byte[] dat = new byte[20000];
            int n = 0;
            while (n != -1) {
                n = ((InputStream)in).read(dat);
                if (n <= 0) continue;
                size += (long)n;
                out.write(dat, 0, n);
            }
        }
        finally {
            FileUtil.robustClose(in);
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadFile_ignoreInvalidCertificate(URL url, File targetFile) throws IOException {
        URLConnection conn = url.openConnection();
        BufferedInputStream in = new BufferedInputStream(conn.getInputStream(), 10000);
        BufferedOutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(targetFile), 10000);
            byte[] dat = new byte[20000];
            int n = 0;
            while (n != -1) {
                n = ((InputStream)in).read(dat);
                if (n <= 0) continue;
                ((OutputStream)out).write(dat, 0, n);
            }
        }
        catch (Throwable throwable) {
            FileUtil.robustClose(out);
            FileUtil.robustClose(in);
            throw throwable;
        }
        FileUtil.robustClose(out);
        FileUtil.robustClose(in);
    }

    public static File getFirstFileStarting(File folder, String start) {
        File[] files = folder.listFiles();
        if (files == null) {
            return null;
        }
        for (File file : files) {
            if (!file.getName().startsWith(start)) continue;
            return file;
        }
        return null;
    }

    public static File getFirstFileEnding(File folder, String end) {
        File[] files = folder.listFiles();
        if (files == null) {
            return null;
        }
        for (File file : files) {
            if (!file.getName().endsWith(end)) continue;
            return file;
        }
        return null;
    }

    public static boolean isSymlink(File file) throws IOException {
        File canon;
        if (file == null) {
            throw new NullPointerException("File must not be null");
        }
        if (file.getParent() == null) {
            canon = file;
        } else {
            File canonDir = file.getParentFile().getCanonicalFile();
            canon = new File(canonDir, file.getName());
        }
        return !canon.getCanonicalFile().equals(canon.getAbsoluteFile());
    }

    public static File createTempDirectory() throws IOException {
        File temp = File.createTempFile("temp", Long.toString(System.nanoTime()));
        if (!temp.delete()) {
            throw new IOException("Could not delete temp file: " + temp.getAbsolutePath());
        }
        if (!temp.mkdir()) {
            throw new IOException("Could not create temp directory: " + temp.getAbsolutePath());
        }
        return temp;
    }

    public static boolean same(File f1, File f2) throws IOException {
        return f1.getCanonicalPath().equals(f2.getCanonicalPath());
    }

    public static InputStream ropen(File f) throws IOException {
        return new BufferedInputStream(new FileInputStream(f));
    }

    public static OutputStream wopen(File f) throws IOException {
        return new BufferedOutputStream(new FileOutputStream(f));
    }

    public static String appendToNamePreservingExtension(String name, String app) {
        int n = name.lastIndexOf(46);
        if (n == -1) {
            return name + app;
        }
        return name.substring(0, n) + app + name.substring(n);
    }

    public static File getSubFile(File dest, String name) {
        String path = dest.getAbsolutePath();
        path = !path.endsWith(File.separator) ? path + File.separator + name : path + name;
        return new File(path);
    }

    public static String stripExtension(String name) {
        int n = name.lastIndexOf(46);
        if (n == -1) {
            return name;
        }
        return name.substring(0, n);
    }

    public static String replaceExtension(String name, String extension) {
        return FileUtil.stripExtension(name) + "." + extension;
    }

    public static File replaceExtension(File file, String extension) {
        String name = file.getName();
        String newName = FileUtil.stripExtension(name) + "." + extension;
        return new File(file.getParentFile(), newName);
    }

    public static void appendToFile(String path, String append) throws IOException {
        FileOutputStream fout = new FileOutputStream(path, true);
        fout.write(append.getBytes(StandardCharsets.UTF_8));
        fout.flush();
        fout.close();
    }

    public static void writeFileAsString(File path, String dat) throws IOException {
        FileUtil.writeFile(path.getPath(), dat.getBytes(StandardCharsets.ISO_8859_1));
    }

    public static void writeFileAsString(String path, String dat) throws IOException {
        FileUtil.writeFile(path, dat.getBytes(StandardCharsets.ISO_8859_1));
    }

    public static void writeFileAsStringUTF8(String path, String dat) throws IOException {
        FileUtil.writeFile(path, dat.getBytes(StandardCharsets.UTF_8));
    }

    public static void writeFileAsStringUTF8(File file, String dat) throws IOException {
        FileUtil.writeFile(file, dat.getBytes(StandardCharsets.UTF_8));
    }

    public static void writeFile(String path, byte[] dat) throws IOException {
        File f = new File(path);
        FileUtil.writeFile(f, dat);
    }

    public static void writeFile(File f, byte[] dat) throws IOException {
        FileUtil.writeFile(f, dat, 0, dat.length);
    }

    public static void writeFileAtomic(File f, byte[] dat) throws IOException {
        FileUtil.writeFile(f, dat, 0, dat.length, true);
    }

    public static void writeFile(File f, byte[] dat, int offset, int len) throws IOException {
        FileUtil.writeFile(f, dat, offset, len, false);
    }

    public static void writeFile(File f, byte[] dat, int offset, int len, boolean atomic) throws IOException {
        File parent = f.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        BufferedOutputStream fout = atomic ? new BufferedOutputStream(new AtomicFileOutputStream(f)) : new BufferedOutputStream(new FileOutputStream(f));
        try {
            fout.write(dat, offset, len);
        }
        catch (IOException x) {
            throw x;
        }
        finally {
            FileUtil.robustClose(fout);
        }
    }

    public static byte[] readFile(String path) throws IOException {
        FileInputStream fin = new FileInputStream(path);
        BufferedInputStream bin = new BufferedInputStream(fin);
        try {
            byte[] s = StreamUtils.readAll(bin);
            FileUtil.robustClose(bin);
            return s;
        }
        catch (IOException e) {
            FileUtil.robustClose(bin);
            throw e;
        }
    }

    public static byte[] readFirst(File file, long len) throws IOException {
        long flen = file.length();
        long validLen = Math.min(len, flen);
        return FileUtil.readFileChunk(file, 0L, validLen);
    }

    public static byte[] readLast(File file, long len) throws IOException {
        long flen = file.length();
        long validLen = Math.min(len, flen);
        return FileUtil.readFileChunk(file, flen - validLen, validLen);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFileChunk(File file, long off, long len) throws IOException {
        byte[] result = new byte[(int)len];
        try (RandomAccessFile raf = new RandomAccessFile(file, "r");){
            raf.seek(off);
            raf.readFully(result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File readFileChunkAsFile(File file, long off, long len) throws IOException {
        File tmp = new File(file.getParentFile(), file.getName() + ".chunk_" + (long)(Math.random() * 1.0E8));
        FileOutputStream fout = new FileOutputStream(tmp);
        FileChannel destChannel = fout.getChannel();
        try (RandomAccessFile raf = new RandomAccessFile(file, "r");){
            raf.seek(off);
            FileChannel sourceChannel = raf.getChannel();
            destChannel.transferFrom(sourceChannel, 0L, len);
        }
        finally {
            fout.close();
            destChannel.close();
        }
        return tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void overwriteIntoFile(File modify, long start, byte[] data, boolean curtail) throws IOException {
        try (RandomAccessFile push = new RandomAccessFile(modify, "rw");){
            push.seek(start);
            push.write(data);
            if (curtail) {
                push.setLength(push.getFilePointer());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void overwriteIntoFile(File modify, long start, byte[] data1, byte[] data2, boolean curtail) throws IOException {
        try (RandomAccessFile push = new RandomAccessFile(modify, "rw");){
            push.seek(start);
            push.write(data1);
            push.write(data2);
            if (curtail) {
                push.setLength(push.getFilePointer());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void overwriteIntoFile(File modify, long start, File source, long off, long len, boolean curtail) throws IOException {
        try (RandomAccessFile push = new RandomAccessFile(modify, "rw");){
            read.seek(off);
            try (RandomAccessFile read = new RandomAccessFile(source, "r");){
                push.seek(start);
                byte[] buf = new byte[100000];
                int n = 0;
                int tot = 0;
                while ((long)tot < len) {
                    n = read.read(buf, 0, (int)Math.min((long)buf.length, len - (long)tot));
                    if (n > 0) {
                        push.write(buf, 0, n);
                        tot += n;
                    }
                    if (n != -1) continue;
                    throw new EOFException("Unexpected end of file");
                }
                if (curtail) {
                    push.setLength(push.getFilePointer());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insertIntoFile(File modify, long insert, File source, int off, long len) throws IOException {
        long tailLen = modify.length() - insert;
        File tail = FileUtil.readFileChunkAsFile(modify, insert, tailLen);
        try {
            FileUtil.overwriteIntoFile(modify, insert, source, off, len, true);
            FileUtil.overwriteIntoFile(modify, insert + len, tail, 0L, tailLen, true);
        }
        finally {
            tail.delete();
        }
    }

    public static void insertIntoFileInMemory(File modify, long insert, File source, int off, int len) throws IOException {
        byte[] insertData = FileUtil.readFileChunk(source, off, len);
        FileUtil.insertIntoFileInMemory(modify, insert, insertData, 0, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insertIntoFileInMemory(File modify, long insert, byte[] insertData, int off, int len) throws IOException {
        long tailLen = modify.length() - insert;
        byte[] tailData = new byte[(int)tailLen];
        try (RandomAccessFile raf = new RandomAccessFile(modify, "rw");){
            raf.seek(insert);
            raf.readFully(tailData);
            raf.seek(insert);
            raf.write(insertData, off, len);
            raf.write(tailData);
            raf.setLength(raf.getFilePointer());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteFromFile(File modify, long start, long len) throws IOException {
        long tailStart = start + len;
        long tailLen = modify.length() - tailStart;
        File tail = FileUtil.readFileChunkAsFile(modify, tailStart, tailLen);
        try {
            FileUtil.overwriteIntoFile(modify, start, tail, 0L, tailLen, true);
        }
        finally {
            tail.delete();
        }
    }

    private static void dumpAsChars(File f) throws IOException {
        int c;
        FileInputStream in = new FileInputStream(f);
        do {
            if ((c = ((InputStream)in).read()) == -1) continue;
            System.out.print((char)c);
        } while (c != -1);
        System.out.println();
    }

    public static byte[] readFileAtomic(File file) throws IOException {
        AtomicFileOutputStream.prepareForReading(file);
        return FileUtil.readFile(file);
    }

    public static byte[] readFile(File file) throws IOException {
        FileInputStream fin = new FileInputStream(file);
        BufferedInputStream bin = new BufferedInputStream(fin);
        try {
            byte[] s = StreamUtils.readAll(bin);
            FileUtil.robustClose(bin);
            return s;
        }
        catch (IOException e) {
            FileUtil.robustClose(bin);
            throw e;
        }
    }

    public static String readFileAsString(String path) throws IOException {
        return FileUtil.readFileAsString(new File(path));
    }

    public static String readFileAsString(File path) throws IOException {
        BufferedInputStream bin = new BufferedInputStream(new FileInputStream(path));
        try {
            String string = StreamUtils.readAllAsString(bin);
            return string;
        }
        finally {
            FileUtil.robustClose(bin);
        }
    }

    public static String readFileAsString_NoBuffer(File path) throws IOException {
        FileInputStream fin = new FileInputStream(path);
        try {
            String string = StreamUtils.readAllAsString(fin);
            return string;
        }
        finally {
            FileUtil.robustClose(fin);
        }
    }

    public static String readFileAsStringUTF8(String path) throws IOException {
        FileInputStream fin = new FileInputStream(path);
        BufferedInputStream bin = new BufferedInputStream(fin);
        try {
            String s = StreamUtils.readAllAsStringUTF8(bin);
            FileUtil.robustClose(bin);
            return s;
        }
        catch (IOException e) {
            FileUtil.robustClose(bin);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileAsStringUTF8(File path) throws IOException {
        FileInputStream fin = new FileInputStream(path);
        BufferedInputStream bin = new BufferedInputStream(fin);
        try {
            String string = StreamUtils.readAllAsStringUTF8(bin);
            return string;
        }
        finally {
            FileUtil.robustClose(bin);
        }
    }

    public static void copyFileOrDir(File src, File dest) throws IOException {
        if (!src.isDirectory()) {
            FileUtil.copy(src, dest);
        } else {
            dest.delete();
            dest.mkdirs();
            File[] files = src.listFiles();
            if (files != null) {
                for (File file : files) {
                    File ndest = new File(dest.getAbsolutePath(), file.getName());
                    FileUtil.copyFileOrDir(file, ndest);
                }
            }
        }
    }

    public static void copy(File src, File dest) throws IOException {
        BufferedInputStream fin = null;
        BufferedOutputStream fout = null;
        try {
            fin = new BufferedInputStream(new FileInputStream(src));
            fout = new BufferedOutputStream(new FileOutputStream(dest));
            StreamPiper.pipe(fin, fout, 300000, true, false, false);
            ((OutputStream)fout).flush();
        }
        catch (IOException e) {
            block5: {
                try {
                    if (!(e instanceof FileNotFoundException) || !e.getMessage().toLowerCase().contains("symbolic links")) break block5;
                }
                catch (Throwable throwable) {
                    FileUtil.robustClose(fin);
                    FileUtil.robustClose(fout);
                    throw throwable;
                }
                FileUtil.robustClose(fin);
                FileUtil.robustClose(fout);
                return;
            }
            throw e;
        }
        FileUtil.robustClose(fin);
        FileUtil.robustClose(fout);
        dest.setLastModified(src.lastModified());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFast(File sourceFile, File destFile) throws IOException {
        if (!destFile.exists()) {
            destFile.createNewFile();
        }
        FileChannel source = null;
        AbstractInterruptibleChannel destination = null;
        try {
            source = new FileInputStream(sourceFile).getChannel();
            destination = new FileOutputStream(destFile).getChannel();
            ((FileChannel)destination).transferFrom(source, 0L, source.size());
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
    }

    public static void robustAppend(String path, String append) {
        try {
            FileUtil.appendToFile(path, append);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void robustClose(InputStream in) {
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void robustClose(OutputStream in) {
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void robustClose(Socket s) {
        try {
            if (s != null) {
                s.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void robustDelete(String s) {
        try {
            if (s != null) {
                FileUtil.robustDelete(new File(s));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void robustDelete(File f) {
        try {
            if (f != null && f.exists()) {
                f.delete();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void deleteDir(File f) {
        try {
            f.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!f.exists()) {
            return;
        }
        if (f.isDirectory()) {
            File[] files = f.listFiles();
            if (files != null) {
                for (File file : files) {
                    FileUtil.deleteDir(file);
                }
            }
            if (!f.delete()) {
                System.err.println("[FileUtil] Unable to delete directory: " + f);
            }
        } else if (!f.delete()) {
            System.err.println("[FileUtil] Unable to delete file: " + f);
        }
    }

    public static void removeCVS(File f) {
        if (f.isDirectory()) {
            if (f.getName().equals("CVS")) {
                FileUtil.deleteDir(f);
            } else {
                File[] files = f.listFiles();
                if (files != null) {
                    for (File file : files) {
                        FileUtil.removeCVS(file);
                    }
                }
            }
        }
    }

    public static long recursiveSize(File fileOrDir) {
        if (fileOrDir.isDirectory()) {
            File[] files = fileOrDir.listFiles();
            long total = 0L;
            if (files != null) {
                for (File f : files) {
                    total += FileUtil.recursiveSize(f);
                }
            }
            return total;
        }
        return fileOrDir.length();
    }

    public static File[] deepList(File dir) {
        return FileUtil.deepList(dir, -1L);
    }

    public static File[] deepList(File dir, long lastModifiedFilesNewerThan) {
        ArrayList<File> list = new ArrayList<File>();
        FileUtil.deepList(dir, list, lastModifiedFilesNewerThan);
        return list.toArray(new File[0]);
    }

    private static void deepList(File file, ArrayList<File> list, long lastModifiedFilesNewerThan) {
        if (!file.isDirectory()) {
            if (lastModifiedFilesNewerThan == -1L || file.lastModified() > lastModifiedFilesNewerThan) {
                list.add(file);
            }
        } else {
            File[] tmp = file.listFiles();
            if (tmp != null) {
                for (File aTmp : tmp) {
                    FileUtil.deepList(aTmp, list, lastModifiedFilesNewerThan);
                }
            }
        }
    }

    public static String listDir(File dir) {
        StringBuilder sb = new StringBuilder();
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                sb.append(file.getName()).append(" - ").append(file.length()).append('\n');
            }
        }
        return sb.toString();
    }

    public static String normaliseAsFilename(String potentialFilename) {
        String s = potentialFilename;
        int len = s.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            if (Character.isLetterOrDigit(ch)) {
                sb.append(ch);
                continue;
            }
            sb.append(Integer.toHexString(ch));
        }
        return sb.toString();
    }

    public static String toFilenameTrimmed(String potentialFilename) {
        if (potentialFilename == null) {
            return null;
        }
        potentialFilename = potentialFilename.trim();
        int len = potentialFilename.length();
        StringBuilder sb = new StringBuilder(len);
        for (char ch : potentialFilename.toCharArray()) {
            if (!Character.isLetterOrDigit(ch) && !Character.isSpaceChar(ch)) continue;
            sb.append(ch);
        }
        return sb.toString();
    }

    public static FileOutputStream repeatAttemptOpenFromForWriting(File file, int attempts, int sleep) throws FileNotFoundException {
        int attemptCount = 0;
        while (attemptCount < attempts) {
            ++attemptCount;
            try {
                return new FileOutputStream(file);
            }
            catch (FileNotFoundException ex) {
                if (attemptCount == attempts) {
                    throw ex;
                }
                System.out.println("[" + attemptCount + "/" + attempts + "] [W] Open failed (" + ex.getMessage() + ")");
                try {
                    Thread.sleep(Math.max(0L, (long)((double)sleep + Math.random() * 50.0)));
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public static FileInputStream repeatAttemptOpenFromForReading(File file, int attempts, int sleep) throws FileNotFoundException {
        int attemptCount = 0;
        while (attemptCount < attempts) {
            ++attemptCount;
            try {
                return new FileInputStream(file);
            }
            catch (FileNotFoundException ex) {
                if (attemptCount == attempts) {
                    throw ex;
                }
                System.out.println("[" + attemptCount + "/" + attempts + "] [R] Open failed (" + ex.getMessage() + ")");
                try {
                    Thread.sleep(Math.max(0L, (long)((double)sleep + Math.random() * 50.0)));
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public static String trimTrailingSlash(String absolutePath) {
        if (absolutePath == null) {
            return null;
        }
        if (absolutePath.length() == 1) {
            return absolutePath;
        }
        if (absolutePath.endsWith("\\") || absolutePath.endsWith("/")) {
            return absolutePath.substring(0, absolutePath.length() - 1);
        }
        return absolutePath;
    }

    public static boolean isDescendentOf(File descendent, File parent) {
        for (File tmp = descendent; tmp != null; tmp = tmp.getParentFile()) {
            if (!tmp.equals(parent)) continue;
            return true;
        }
        return false;
    }

    public static File getAncestorFolderByName(File child, String name) {
        while (child != null && !child.getName().equals(name)) {
            child = child.getParentFile();
        }
        return child;
    }

    public static boolean containsChild(File parent, String childName) {
        File[] files = parent.listFiles();
        if (files == null) {
            return false;
        }
        for (File f : files) {
            if (!f.getName().equals(childName)) continue;
            return true;
        }
        return false;
    }

    public static void touch(File reportFile) throws IOException {
        if (!reportFile.exists()) {
            FileOutputStream fout = new FileOutputStream(reportFile);
            fout.close();
        } else {
            reportFile.setLastModified(System.currentTimeMillis());
        }
    }

    public static FileIterator getDepthFirstIterator(File parent) {
        return new FileIterator(parent);
    }

    public static boolean isEmpty(File parent) {
        if (!parent.exists()) {
            return true;
        }
        File[] files = parent.listFiles();
        if (files == null) {
            return true;
        }
        return files.length == 0;
    }

    public static void main(String[] args) {
        FileIterator it = new FileIterator(new File("/Users/gchristelis/Desktop"));
        while (it.hasNext()) {
            System.out.println(it.next);
        }
    }

    public static class FileIterator
    implements Iterator<File> {
        private LinkedList<File> children = new LinkedList();
        private File next;

        public FileIterator(File root) {
            this.children.add(root);
        }

        @Override
        public boolean hasNext() {
            if (this.children.size() == 0) {
                return false;
            }
            this.next = this.children.pop();
            while (this.children.size() > 0 && !this.next.exists()) {
                this.next = this.children.pop();
            }
            if (this.next.isDirectory()) {
                File[] childFiles = this.next.listFiles();
                if (childFiles != null) {
                    for (int i = childFiles.length - 1; i >= 0; --i) {
                        this.children.addFirst(childFiles[i]);
                    }
                }
                return this.hasNext();
            }
            return true;
        }

        @Override
        public File next() {
            return this.next;
        }

        @Override
        public void remove() {
            this.next.delete();
        }
    }
}

