/*
 * Decompiled with CFR 0.152.
 */
package utils.files;

import java.io.File;
import java.io.IOException;
import utils.files.FileUtil;
import utils.progtools.ProcessPrinter;

public class AutoChmodFile {
    public static String getChmodExe() {
        String chmodExe = "chmod";
        if (new File("/bin/chmod").exists()) {
            chmodExe = "/bin/chmod";
        } else if (new File("/sbin/chmod").exists()) {
            chmodExe = "/sbin/chmod";
        }
        return chmodExe;
    }

    public static String getCPExe() {
        String cpExe = "cp";
        if (new File("/bin/cp").exists()) {
            cpExe = "/bin/cp";
        } else if (new File("/sbin/cp").exists()) {
            cpExe = "/sbin/cp";
        }
        return cpExe;
    }

    public static File autoChmodFile(File unchmodSource, File chmoddedTarget, boolean force) throws IOException {
        String chmodExe = AutoChmodFile.getChmodExe();
        String cpExe = AutoChmodFile.getCPExe();
        if (!force && chmoddedTarget.exists()) {
            return chmoddedTarget;
        }
        FileUtil.deleteDir(chmoddedTarget);
        System.out.println("[AutoChmod] chmodding " + unchmodSource + "...");
        try {
            Process p = Runtime.getRuntime().exec(new String[]{chmodExe, "-R", "755", unchmodSource.getCanonicalPath()});
            new ProcessPrinter(p, System.out, System.err);
            int retCode = p.waitFor();
            System.out.println("[AutoChmod] Completed " + unchmodSource + " chmod (" + retCode + ")");
            p = Runtime.getRuntime().exec(new String[]{cpExe, "-rf", unchmodSource.getCanonicalPath(), chmoddedTarget.getCanonicalPath()});
            new ProcessPrinter(p, System.out, System.err);
            retCode = p.waitFor();
            System.out.println("[AutoChmod] Copied " + unchmodSource + " chmod (" + retCode + " / " + chmoddedTarget + ")");
        }
        catch (InterruptedException xx) {
            throw new IOException("Interrupted while waiting for command to finish");
        }
        return chmoddedTarget;
    }
}

