/*
 * Decompiled with CFR 0.152.
 */
package jwrapper.updater;

import bcutil.BCUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.LinkedList;
import jwrapper.HeadlessSwipeLoadUtil;
import jwrapper.archive.ArchiveSignature;
import jwrapper.jwutils.JWGenericOS;
import jwrapper.pack200.Pack200Decompressor;
import jwrapper.updater.DownloaderInputStream;
import jwrapper.updater.GenericUpdater;
import jwrapper.updater.JWLaunchProperties;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.signers.PSSSigner;
import org.tukaani.xz.LZMAInputStream;
import utils.files.FileUtil;
import utils.files.PathUtil;
import utils.files.PermissionsUtil;
import utils.ostools.RunCommandGetOutput;
import utils.progtools.time.TimeSet;
import utils.stream.CFriendlyStreamUtils;

public class Unarchiver
implements DownloaderInputStream.ProgressListener {
    private static boolean doNativeUnpack = false;
    private static String unpack200Exe;
    private final TimeSet times;
    private final LinkedList<P200Thread> unpack200Jobs = new LinkedList();
    private final HeadlessSwipeLoadUtil swu;
    private DownloaderInputStream downloadInputStream;
    private long previousProgressComplete = -1L;

    public static void forceUseNativeUnpack(boolean useNativeUnpack) {
        doNativeUnpack = useNativeUnpack;
    }

    public Unarchiver(TimeSet times, HeadlessSwipeLoadUtil swu) {
        this.times = times;
        this.swu = swu;
    }

    public void downloadAndExtract(URL archiveURL, File destinationDir, String signaturePubkey, GenericUpdater.UpdaterInfo updaterInfo, GenericUpdater.CACertsSource cacertsSource) throws IOException {
        if (this.times != null) {
            this.times.start("Archive - Download and Extract");
        }
        this.downloadInputStream = new DownloaderInputStream(archiveURL);
        this.downloadInputStream.addProgressListener(this);
        BufferedInputStream in = new BufferedInputStream(new LZMAInputStream(this.downloadInputStream), 500000);
        this.unpackArchive(in, destinationDir, signaturePubkey, updaterInfo, cacertsSource);
        if (this.times != null) {
            this.times.stop("Archive - Download and Extract");
        }
    }

    public void unpackArchive(InputStream archiveStream, File appDirectory, String signaturePubkey, GenericUpdater.UpdaterInfo updaterInfo, GenericUpdater.CACertsSource cacertsSource) throws IOException {
        this.unpackArchive(archiveStream, appDirectory, signaturePubkey, updaterInfo, false, cacertsSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unpackArchive(InputStream archiveStream, File appDirectory, String signaturePubkey, GenericUpdater.UpdaterInfo updaterInfo, boolean chmod777, GenericUpdater.CACertsSource cacertsSource) throws IOException {
        System.out.println("[UnArchiver] Extracting archive to " + appDirectory);
        File copyPrevent = new File(appDirectory, "extracting_nocopy");
        FileOutputStream copyPrevention = new FileOutputStream(copyPrevent);
        PSSSigner signer = null;
        if (signaturePubkey != null) {
            RSAKeyParameters pubkey = BCUtil.getPublicKeyFromHex(signaturePubkey);
            signer = BCUtil.initStreamSigner(pubkey);
        }
        ArchiveSignature archiveSignature = null;
        CFriendlyStreamUtils.ReadCache readCache = new CFriendlyStreamUtils.ReadCache();
        try {
            Object path;
            try {
                byte[] buf = new byte[100000];
                block30: while (true) {
                    BufferedOutputStream out;
                    int t;
                    if ((t = CFriendlyStreamUtils.readInt(archiveStream, readCache)) == 1) {
                        path = CFriendlyStreamUtils.readString(archiveStream, readCache);
                        System.out.println("[Archive] Extracting folder " + (String)path);
                        path = PathUtil.makePathNative((String)path);
                        File folder = new File(appDirectory, (String)path);
                        folder.mkdirs();
                        if (chmod777) {
                            JWGenericOS.setWritableForAllUsers(folder, false);
                        }
                        if (signer != null) {
                            signer.update(readCache.getByteArray(), 0, readCache.getLength());
                        }
                        readCache.clear();
                        continue;
                    }
                    if (t != 0 && t != 2) continue;
                    path = CFriendlyStreamUtils.readString(archiveStream, readCache);
                    if (((String)path).startsWith("jwArcSpBlock_")) {
                        long asblen = CFriendlyStreamUtils.readLong(archiveStream, readCache);
                        path = ((String)path).substring("jwArcSpBlock_".length());
                        System.out.println("[Archive] Archive Special Block " + (String)path);
                        if (((String)path).equals("DigitalSignature1")) {
                            int len = CFriendlyStreamUtils.readInt(archiveStream, readCache);
                            String sig = CFriendlyStreamUtils.readString(archiveStream, readCache);
                            System.out.println("[Archive] Digital Signature (SHA256+SHA3, RSA) " + len + " = " + sig);
                            archiveSignature = new ArchiveSignature(len, sig);
                            break;
                        }
                        long tot = 0L;
                        int n = 0;
                        while (true) {
                            if (n == -1 || tot >= asblen) continue block30;
                            n = archiveStream.read(buf, 0, Math.min(buf.length, (int)(asblen - tot)));
                            if (n <= 0) continue;
                            tot += (long)n;
                        }
                    }
                    System.out.println("[Archive] Extracting file " + (String)path);
                    long len = CFriendlyStreamUtils.readLong(archiveStream, readCache);
                    File f = new File(appDirectory, (String)path);
                    if (this.times != null) {
                        this.times.start("Archive - Extract");
                    }
                    try {
                        out = new BufferedOutputStream(new FileOutputStream(f));
                    }
                    catch (FileNotFoundException x) {
                        f.mkdirs();
                        f.delete();
                        out = new BufferedOutputStream(new FileOutputStream(f));
                    }
                    long tot = 0L;
                    int n = 0;
                    if (signer != null) {
                        signer.update(readCache.getByteArray(), 0, readCache.getLength());
                    }
                    readCache.clear();
                    try {
                        while (n != -1 && tot < len) {
                            n = archiveStream.read(buf, 0, Math.min(buf.length, (int)(len - tot)));
                            if (n <= 0) continue;
                            ((OutputStream)out).write(buf, 0, n);
                            if (signer != null) {
                                signer.update(buf, 0, n);
                            }
                            tot += (long)n;
                        }
                    }
                    finally {
                        FileUtil.robustClose(out);
                    }
                    System.out.println("[Archive] Extracted file " + (String)path + " (" + tot + "/" + len + ")");
                    if (this.times != null) {
                        this.times.stop("Archive - Extract");
                    }
                    if (t == 2) {
                        File p2 = new File(appDirectory, ((String)path).substring(0, ((String)path).length() - 4) + ".p2");
                        f.renameTo(p2);
                        P200Thread p200Thread = new P200Thread((String)path, p2, appDirectory, updaterInfo, cacertsSource);
                        LinkedList<P200Thread> linkedList = this.unpack200Jobs;
                        synchronized (linkedList) {
                            this.unpack200Jobs.add(p200Thread);
                            if (this.unpack200Jobs.size() == 1) {
                                p200Thread.start();
                            }
                        }
                    } else if (((String)path).endsWith("unpack200") || ((String)path).endsWith("unpack200.exe")) {
                        unpack200Exe = f.getCanonicalPath();
                        System.out.println("[Archive] Noted unpack200 executable path: " + unpack200Exe);
                        PermissionsUtil.setRecursiveFullPermissions(unpack200Exe);
                    }
                    if (!chmod777) continue;
                    JWGenericOS.setWritableForAllUsers(f, false);
                }
            }
            catch (EOFException x) {
                System.out.println("Extraction complete");
            }
            finally {
                FileUtil.robustClose(archiveStream);
            }
            boolean signatureValid = false;
            if (signaturePubkey != null && archiveSignature != null) {
                System.out.println("[Archive] Author pubkey provided, checking signature");
                if (this.times != null) {
                    this.times.start("Archive - Signature");
                }
                byte[] signature = BCUtil.getSignatureFromHex(archiveSignature.sig);
                signatureValid = BCUtil.finishStreamSigner(signer, signature);
                if (this.times != null) {
                    this.times.stop("Archive - Signature");
                }
            } else {
                if (archiveSignature != null) {
                    System.out.println("[Archive] Author pubkey not provided, ignoring signature");
                } else {
                    System.out.println("[Archive] Author pubkey not provided, archive has no signature");
                }
                signatureValid = true;
            }
            int unfinishedJobs = 0;
            path = this.unpack200Jobs;
            synchronized (path) {
                unfinishedJobs = this.unpack200Jobs.size();
            }
            if (unfinishedJobs > 0) {
                System.out.println("[Archive] Waiting for " + unfinishedJobs + " jobs to complete.");
                while (unfinishedJobs > 0) {
                    P200Thread job;
                    LinkedList<P200Thread> linkedList = this.unpack200Jobs;
                    synchronized (linkedList) {
                        unfinishedJobs = this.unpack200Jobs.size();
                        if (unfinishedJobs <= 0) {
                            continue;
                        }
                        job = this.unpack200Jobs.removeFirst();
                    }
                    try {
                        job.join();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    linkedList = job;
                    synchronized (linkedList) {
                        if (job.error != null) {
                            IOException ioException = new IOException("Pack200 delegate thread failed");
                            ioException.initCause(job.error);
                            throw ioException;
                        }
                    }
                    linkedList = this.unpack200Jobs;
                    synchronized (linkedList) {
                        unfinishedJobs = this.unpack200Jobs.size();
                    }
                }
            }
            if (!signatureValid) {
                System.out.println("[Archive] Archive signature was INVALID, deleting...");
                FileUtil.deleteDir(appDirectory);
                throw new IOException("Archive contained an invalid signature");
            }
            if (signaturePubkey != null) {
                System.out.println("[Archive] Archive signature was verified OK");
            } else {
                System.out.println("[Archive] Archive signature not checked");
            }
        }
        finally {
            FileUtil.robustClose(copyPrevention);
            copyPrevent.delete();
        }
    }

    @Override
    public void progressChanged(long bytesDownloaded, long totalBytes) {
        double progress = bytesDownloaded;
        long newPercentComplete = (long)((progress /= (double)totalBytes) * 100.0);
        if (this.previousProgressComplete != newPercentComplete && this.swu != null) {
            this.swu.setProgress(progress);
        }
        this.previousProgressComplete = newPercentComplete;
    }

    private class P200Thread
    extends Thread {
        private final String path;
        private final File p2;
        private final File appDirectory;
        private final GenericUpdater.UpdaterInfo updaterInfo;
        private final GenericUpdater.CACertsSource cacertsSource;
        private Exception error;
        private boolean complete = false;

        public P200Thread(String path, File p2, File appDirectory, GenericUpdater.UpdaterInfo updaterInfo, GenericUpdater.CACertsSource cacertsSource) {
            this.appDirectory = appDirectory;
            this.path = path;
            this.p2 = p2;
            this.updaterInfo = updaterInfo;
            this.cacertsSource = cacertsSource;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                System.out.println("[Archive] Unpacking file " + this.path);
                if (Unarchiver.this.times != null) {
                    Unarchiver.this.times.start("Archive - Unpack200");
                }
                if (!doNativeUnpack) {
                    this.tryJavaUnpack();
                }
                if (doNativeUnpack && !this.tryNativeUnpack()) {
                    System.exit(1);
                }
                if (Unarchiver.this.times != null) {
                    Unarchiver.this.times.stop("Archive - Unpack200");
                }
                LinkedList linkedList = Unarchiver.this.unpack200Jobs;
                synchronized (linkedList) {
                    Unarchiver.this.unpack200Jobs.remove(this);
                    if (Unarchiver.this.unpack200Jobs.size() > 0) {
                        ((P200Thread)Unarchiver.this.unpack200Jobs.get(0)).start();
                    }
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
                P200Thread p200Thread = this;
                synchronized (p200Thread) {
                    this.error = ex;
                }
            }
        }

        private boolean tryNativeUnpack() throws IOException {
            String[] output = RunCommandGetOutput.runCommandGetOutput(new String[]{unpack200Exe, "-r", this.p2.getCanonicalPath(), new File(this.appDirectory, this.path).getCanonicalPath()});
            if (output == null) {
                System.out.println("[Archive] Unable to unpack p2 archive");
                return false;
            }
            System.out.println("[Archive] Native unpack OK: " + output[0]);
            return true;
        }

        private void tryJavaUnpack() throws IOException {
            block8: {
                try {
                    boolean forceNativeUnpack = false;
                    try {
                        String upcheck;
                        if (JWLaunchProperties.isJWrapperSetup() && (upcheck = JWLaunchProperties.getProperty("force_native_unpack200")).equalsIgnoreCase("true")) {
                            System.out.println("[Archive] Forcing native unpack");
                            forceNativeUnpack = true;
                        }
                    }
                    catch (Exception upcheck) {
                        // empty catch block
                    }
                    if (forceNativeUnpack) {
                        throw new IOException("Forcing native unpack (corrupted magic simulation)");
                    }
                    Pack200Decompressor.initDecompressor().decompressDirectory(this.p2, false);
                }
                catch (IOException x) {
                    String s = x.getMessage();
                    s = s.toLowerCase();
                    if (!s.contains("cafe") && !s.contains("corrupted") && !s.contains("should be") && !s.contains("magic")) break block8;
                    System.out.println("[Unarchiver] Detected corrupted pack file. Attempting native fallback if this is a JRE");
                    if (unpack200Exe != null) {
                        System.out.println("[Unarchiver] Unpack200 is currently " + unpack200Exe);
                        if (this.tryNativeUnpack()) {
                            doNativeUnpack = true;
                            System.out.println("[Unarchiver] Native fallback worked. Returning.");
                            return;
                        }
                    }
                    System.out.println("[Unarchiver] Native fallback failed. Updating JRE.");
                    doNativeUnpack = true;
                    GenericUpdater.mustUpdateJreForPack200(this.appDirectory, this.updaterInfo, this.cacertsSource);
                }
            }
        }
    }
}

