/*
 * Decompiled with CFR 0.152.
 */
package jwrapper.updater;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Properties;
import jwrapper.InsideApplet;
import jwrapper.VMTransmuter;
import jwrapper.archive.Archive;
import jwrapper.hidden.JWNativeAPI;
import jwrapper.hidden.events.JWMacOSEventManager;
import jwrapper.jwutils.JWLinuxOS;
import jwrapper.jwutils.JWMacOS;
import jwrapper.jwutils.JWSystem;
import jwrapper.updater.AppDoesNotExistException;
import jwrapper.updater.GenericUpdater;
import jwrapper.updater.JWApp;
import jwrapper.updater.JWLaunchProperties;
import utils.files.AutoChmodFile;
import utils.files.FileUtil;
import utils.files.PathUtil;
import utils.osstats.OsStats;
import utils.osstats.Stats;
import utils.ostools.OS;
import utils.progtools.ProcessPrinter;
import utils.stream.CFriendlyStreamUtils;
import utils.string.StringReplace;
import utils.switches.Switches;
import utils.vm.VMFork;

public class LaunchFile {
    public static String JW_VAPP_UPDATE_APP = "JWrapperUpdateApp";
    public static String JW_VAPP_COMPATIBILITY_APP = "JWrapperJreCompatibilityApp";
    public static String JW_VAPP_POST_INSTALL_APP = "JWrapperPostInstallApp";
    public static String JW_VAPP_PRE_UNINSTALL_APP = "JWrapperPreUninstallApp";
    public static String JW_VAPP_POST_UNINSTALL_APP = "JWrapperPostUninstallApp";
    public static String JW_VAPP_MATCH_VERSIONS_SERVER_UNAVAILABLE = "JWrapperMatchedVersionServerUnavailable";
    public static String JWRAPPER_JVM_OPTION = "-Djwrapper.JWrapper=true";
    private static boolean AUTOCOPY_GU_JW_UTILS_AND_INCLUDE = false;
    private static String GU_DIR = null;
    public static int POST_LAUNCH_PRINT_FOR = 100;
    public static final int LAUNCHFILE_VAPP_DOES_NOT_EXIST = 999001;
    public static final int PINST_CONTINUE_USE_STANDARD = 41;
    public static final int PINST_CONTINUE_SKIP_STANDARD = 42;
    public static final int PINST_QUIT_AND_ROLL_BACK = 43;
    public static final int UAPP_UPDATE_AND_RUN = 50;
    public static final int UAPP_JUST_RUN = 51;
    public static final int UAPP_EXIT = 52;
    public static final int UAPP_JUST_RUN_STOP_TELLING_ME = 53;
    public static final int PUNIN_DO_UNINSTALL = 61;
    public static final int PUNIN_ASK_IF_UNINSTALL = 62;
    public static final int PUNIN_CANCEL_UNINSTALL = 63;
    public static final int UJRE_OK = 72;
    public static final int UJRE_NOTSUPPORTED = 73;
    public static final int UNAVAIL_SHOW_ERROR = 81;
    public static final int UNAVAIL_HIDE_ERROR = 82;
    public static final int UNAVAIL_RELAUNCH_SOURCELAUNCHER = 83;
    private static final int LF_VERSION = 6;
    public static final String FILE_NAME = "JWrapperLaunch";
    public static final String JREVER_FILE_NAME = "JWrapperUseJRE";
    String mainClass;
    String mainClassOnUpdate;
    String mainClassForCompatibility;
    String mainClassPostInstall;
    String mainClassPreUninstall;
    String appName;
    private final ArrayList<String> classpath = new ArrayList();
    private final ArrayList<String> params = new ArrayList();
    private final ArrayList<String> jvmOptions = new ArrayList();
    boolean willRequireURL = false;
    String osxIcnsFile = "";
    boolean mustFork = false;

    public static File getJvmLastSuccessfulOptionsFile(File master, File jre) {
        File jwapps = new File(master, "JWApps");
        jwapps.mkdirs();
        if (jre == null) {
            String jvm_home = System.getProperty("java.home");
            jre = new File(jvm_home);
        }
        return new File(jwapps, "JRE-LastSuccessfulOptions-" + jre.getName());
    }

    static void setAutoCopyJWUtilsAndInclude(String gu_dir) {
        GU_DIR = gu_dir;
        AUTOCOPY_GU_JW_UTILS_AND_INCLUDE = true;
    }

    public static void main(String[] args) throws Exception {
        System.out.println("yeah");
        LaunchFile.getLaunchCommandFor(new File("/Users/aem/Library/Application Support/JWrapper-JWTestApp/JWrapper-JWrapper-00015753914-complete"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LaunchFile getLaunchCommandFor(File app) throws IOException {
        File command = new File(app, FILE_NAME);
        if (!command.exists()) {
            return null;
        }
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(command));
        try {
            int i;
            int VER = CFriendlyStreamUtils.readInt(in);
            String clazz = CFriendlyStreamUtils.readString(in);
            String onupdate = CFriendlyStreamUtils.readString(in);
            String appName = CFriendlyStreamUtils.readString(in);
            String osxIcnsFile = CFriendlyStreamUtils.readString(in);
            boolean urlreq = CFriendlyStreamUtils.readBoolean(in);
            LaunchFile lf = new LaunchFile(clazz, urlreq, onupdate, osxIcnsFile, appName);
            System.out.println(CFriendlyStreamUtils.readInt(in));
            System.out.println(CFriendlyStreamUtils.readInt(in));
            int n = CFriendlyStreamUtils.readInt(in);
            for (i = 0; i < n; ++i) {
                lf.addClasspath(CFriendlyStreamUtils.readString(in));
            }
            n = CFriendlyStreamUtils.readInt(in);
            for (i = 0; i < n; ++i) {
                lf.addParam(CFriendlyStreamUtils.readString(in));
            }
            if (VER >= 3) {
                lf.setMainClassForJreCompatibility(CFriendlyStreamUtils.readString(in));
            }
            if (VER >= 4) {
                lf.setMainClassForPostInstall(CFriendlyStreamUtils.readString(in));
                lf.setMainClassForPreUninstall(CFriendlyStreamUtils.readString(in));
            }
            if (VER >= 5) {
                n = CFriendlyStreamUtils.readInt(in);
                for (i = 0; i < n; ++i) {
                    lf.addJvmOption(CFriendlyStreamUtils.readString(in));
                }
            }
            if (VER >= 6) {
                lf.setMustFork(CFriendlyStreamUtils.readBoolean(in));
            }
            LaunchFile launchFile = lf;
            return launchFile;
        }
        finally {
            FileUtil.robustClose(in);
        }
    }

    public static ArrayList<File> getFilesStartingWith(File dir, String prefix, boolean removeVersionFiles) {
        File[] files = dir.listFiles();
        if (files == null) {
            files = new File[]{};
        }
        ArrayList<File> list = new ArrayList<File>();
        if (files != null) {
            for (File file : files) {
                if (!file.getName().startsWith(prefix) || removeVersionFiles && file.getName().endsWith("version.txt")) continue;
                list.add(file);
            }
        }
        return list;
    }

    public static boolean versionIsLater(String orig, String compare) {
        int i1 = Integer.parseInt(orig.trim());
        int i2 = Integer.parseInt(compare.trim());
        return i2 > i1;
    }

    public static boolean versionIsSame(String orig, String compare) {
        int i1 = Integer.parseInt(orig.trim());
        int i2 = Integer.parseInt(compare.trim());
        return i2 == i1;
    }

    public static boolean versionIsSameOrLater(String orig, String compare) {
        int i1 = Integer.parseInt(orig.trim());
        int i2 = Integer.parseInt(compare.trim());
        return i2 >= i1;
    }

    public static String pickAppNameFromAppFolder(File app) {
        String name = app.getName();
        name = name.substring(name.indexOf(45) + 1);
        name = name.substring(0, name.indexOf(45));
        return name;
    }

    public static int pickIntegerVersionFromAppFolder(File app) {
        return (int)Long.parseLong(LaunchFile.pickVersionFromAppFolder(app));
    }

    public static String pickVersionFromAppFolder(File app) {
        String name = app.getName();
        name = name.substring(name.indexOf(45) + 1);
        name = name.substring(name.indexOf(45) + 1);
        return name.substring(0, name.indexOf(45));
    }

    public static boolean isAppArchive(File test) {
        String name = test.getName();
        if (name.startsWith("JWrapper-")) {
            if (name.endsWith("-archive.p2.l2")) {
                try {
                    LaunchFile.pickIntegerVersionFromAppArchive(test);
                    return true;
                }
                catch (Exception x) {
                    return false;
                }
            }
            return false;
        }
        return false;
    }

    public static boolean isAppFolder(File test) {
        String name = test.getName();
        if (test.isDirectory()) {
            if (name.startsWith("JWrapper-")) {
                if (name.endsWith("-complete")) {
                    try {
                        LaunchFile.pickIntegerVersionFromAppFolder(test);
                        return true;
                    }
                    catch (Exception x) {
                        return false;
                    }
                }
                return false;
            }
            return false;
        }
        return false;
    }

    public static int pickIntegerVersionFromAppArchive(File app) {
        return (int)Long.parseLong(LaunchFile.pickVersionFromAppArchive(app));
    }

    public static String pickVersionFromAppArchive(File app) {
        String name = app.getName();
        name = name.substring(name.indexOf(45) + 1);
        name = name.substring(name.indexOf(45) + 1);
        return name.substring(0, name.indexOf(45));
    }

    public static boolean fileExistsStartingWith(File dir, String prefix, boolean removeVersionFiles) {
        return LaunchFile.getFilesStartingWith(dir, prefix, removeVersionFiles).size() > 0;
    }

    public static File[] getAllVersionsOf(String app, File master) {
        ArrayList<File> various = LaunchFile.getFilesStartingWith(master, "JWrapper-" + app + "-", true);
        File[] tmp = new File[various.size()];
        various.toArray(tmp);
        return tmp;
    }

    public static File getSpecificVersionOf(String app, String version, File master) {
        File f = new File(master, "JWrapper-" + app + "-" + version + "-complete");
        if (f.exists()) {
            System.out.println("[LaunchFile] Specific app version " + app + "-" + version + " does exist");
            return f;
        }
        System.out.println("[LaunchFile] Specific app version " + app + "-" + version + " does NOT exist");
        return null;
    }

    public static File getLatestVersionOf(String app, File master) {
        return LaunchFile.getLatestVersionOf(app, master, true);
    }

    public static File getLatestVersionOf(String app, File master, boolean ignoreDotPlugins) {
        ArrayList<File> various = LaunchFile.getFilesStartingWith(master, "JWrapper-" + app + "-", true);
        if (various.size() == 0) {
            return null;
        }
        if (ignoreDotPlugins) {
            for (int i = various.size() - 1; i >= 0; --i) {
                File f = various.get(i);
                if (!f.getName().toLowerCase().endsWith(".plugin")) continue;
                various.remove(i);
            }
        }
        Collections.sort(various);
        File latest = various.get(various.size() - 1);
        System.out.println("[LaunchFile] Most recent app version is " + latest.getName());
        return latest;
    }

    public static void setJreVersionForApp(File appFolder, String jreVersion) throws Exception {
        File f = new File(appFolder, JREVER_FILE_NAME);
        FileOutputStream fout = new FileOutputStream(f);
        CFriendlyStreamUtils.writeString(fout, jreVersion);
        fout.close();
    }

    public static String getJreVersionForApp(File appFolder) {
        File f = new File(appFolder, JREVER_FILE_NAME);
        if (!f.exists()) {
            return null;
        }
        try {
            FileInputStream fin = new FileInputStream(f);
            String ver = CFriendlyStreamUtils.readString(fin);
            fin.close();
            return ver;
        }
        catch (Exception x) {
            return null;
        }
    }

    public static void runAutoupdatedVirtualAppFrom(File dir, Properties args, File jre, String urlbase, String[] otherParams, String runAsExe) throws Exception {
        File master = dir.getParentFile();
        File gulatest = LaunchFile.getLatestVersionOf("JWrapper", master);
        LaunchFile.runAppFrom(gulatest, args, jre, urlbase, otherParams, runAsExe, true, false, false);
    }

    public static void runAutoupdatedVirtualAppFromNoExit(File dir, Properties args, File jre, String urlbase, String[] otherParams, String runAsExe) throws Exception {
        File master = dir.getParentFile();
        File gulatest = LaunchFile.getLatestVersionOf("JWrapper", master);
        LaunchFile.runAppFrom(gulatest, args, jre, urlbase, otherParams, runAsExe, false, false, false);
    }

    static boolean runGuSanityCheck(File dir, Properties args, File jre, String urlbase, String[] otherParams, String runAsExe) throws AppDoesNotExistException, Exception {
        Object[] keys;
        System.out.println("[LaunchFile] Launching GU sanity test from " + dir);
        Properties tmp = new Properties();
        for (Object key : keys = args.keySet().toArray()) {
            tmp.setProperty((String)key, (String)args.get(key));
        }
        tmp.setProperty("gu_virt_app", GenericUpdater.VAPP_SANITYCHECK);
        tmp.setProperty("show_no_ui", "true");
        tmp.setProperty("launch_in_session", "false");
        tmp.setProperty("launch_elevate", "false");
        tmp.setProperty("launch_elevate_silent", "");
        try {
            int returnCode = LaunchFile.runAppFrom(dir, tmp, jre, urlbase, otherParams, runAsExe, false, false, true);
            System.out.println("[LaunchFile] Sanity check returned: " + returnCode);
            return returnCode == 55;
        }
        catch (Throwable t) {
            System.out.println("[LaunchFile] Sanity check failed!");
            t.printStackTrace();
            return false;
        }
    }

    public static int runHookAppFrom(File dir, String vapp, Properties args, File jre, String urlbase, String[] otherParams, String runAsExe) throws AppDoesNotExistException, Exception {
        Object[] keys;
        System.out.println("[LaunchFile] Launching jw system virtual app " + vapp + " from " + dir);
        try {
            JWApp jwapp = JWApp.getJWApp(dir, vapp);
            System.out.println("[LaunchFile] JWApp exists, virtual app exists");
        }
        catch (Exception x) {
            System.out.println("[LaunchFile] Virtual app " + vapp + " does not exist");
            throw new AppDoesNotExistException();
        }
        Properties tmp = new Properties();
        for (Object key : keys = args.keySet().toArray()) {
            tmp.setProperty((String)key, (String)args.get(key));
        }
        tmp.setProperty("gu_virt_app", vapp);
        return LaunchFile.runAppFrom(dir, tmp, jre, urlbase, otherParams, runAsExe, false, false, true);
    }

    public static void embedJvmArgs(Properties launchProperties, String[] jvmargs) {
        launchProperties.setProperty("jvm_add_param_count", "" + jvmargs.length);
        for (int i = 0; i < 200; ++i) {
            if (i < jvmargs.length) {
                launchProperties.setProperty("jvm_add_param_" + i, "" + jvmargs[i]);
                continue;
            }
            launchProperties.remove("jvm_add_param");
        }
    }

    public static String[] readEmbeddedJvmArgs(Properties props) {
        String countProp = props.getProperty("jvm_add_param_count");
        if (countProp == null) {
            return new String[0];
        }
        if (countProp.length() == 0) {
            return new String[0];
        }
        int count = Integer.parseInt(countProp);
        String[] jvmargs = new String[count];
        for (int i = 0; i < jvmargs.length; ++i) {
            jvmargs[i] = props.getProperty("jvm_add_param_" + i);
            if (jvmargs[i] != null) continue;
            jvmargs[i] = "";
        }
        return jvmargs;
    }

    public static void runVirtualAppFrom(File dir, Properties args, File jre, String urlbase, String[] otherParams, String runAsExe, boolean transmute) throws Exception {
        LaunchFile.runAppFrom(dir, args, jre, urlbase, otherParams, runAsExe, true, transmute, false);
    }

    public static void runVirtualAppFromNoExit(File dir, Properties args, File jre, String urlbase, String[] otherParams, String runAsExe, boolean transmute) throws Exception {
        LaunchFile.runAppFrom(dir, args, jre, urlbase, otherParams, runAsExe, false, transmute, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static int runAppFrom(File dir, Properties args, File jre, String urlbase, String[] otherParams, String runAsExe, boolean mustExit, boolean transmute, boolean waitForRetcode) throws Exception {
        Process p;
        String requestedURL;
        String elevate;
        void var20_35;
        Object[] keys;
        String jip;
        String headless_jvm;
        boolean launchingGU = false;
        String bundleName = LaunchFile.pickAppNameFromAppFolder(dir);
        if (bundleName.equals("JWrapper")) {
            System.out.println("[LaunchFile] Asked to launch GU (we must be in a wrapper)");
            launchingGU = true;
        } else {
            System.out.println("[LaunchFile] Asked to launch from app bundle " + bundleName + " (" + dir + ")");
        }
        LaunchFile launch = LaunchFile.getLaunchCommandFor(dir);
        String resetXmx = null;
        String xmx_override = args.getProperty("xmx_override");
        if (xmx_override != null) {
            resetXmx = "-Xmx" + xmx_override + "m";
        } else {
            String xmx_pc_max = args.getProperty("xmx_max");
            String xmx_pc_min = args.getProperty("xmx_min");
            String xmx_pc_phys = args.getProperty("xmx_pc_phys");
            String xmx_pc_free = args.getProperty("xmx_pc_free");
            int min = 64;
            int max = 1536;
            if (xmx_pc_max != null) {
                max = Integer.parseInt(xmx_pc_max);
                System.out.println("[LaunchFile] Memory maximum specified: " + max + "m");
            }
            if (xmx_pc_min != null) {
                min = Integer.parseInt(xmx_pc_min);
                System.out.println("[LaunchFile] Memory minimum specified: " + min + "m");
            }
            if (xmx_pc_phys != null || xmx_pc_free != null) {
                int megs;
                double percent;
                if (OS.isWindows()) {
                    if (JWNativeAPI.getInstance().is32Bit() && max > 1536) {
                        max = 1536;
                        System.out.println("[LaunchFile] Max memory limited to 1536m due to 32-bit Windows architecture");
                    }
                } else if (OS.isLinux() && !OS.isLinux64bit()) {
                    max = 1536;
                    System.out.println("[LaunchFile] Max memory limited to 1536m due to 32-bit Linux architecture");
                } else if (OS.isMacOS() && !OS.isMacOS64bit()) {
                    max = 1536;
                    System.out.println("[LaunchFile] Max memory limited to 1536m due to 32-bit MacOS architecture");
                }
                Stats stats = OsStats.getMemoryStats();
                double freemegs = stats.getMemoryFree() / 1048576.0;
                double physmegs = (stats.getMemoryFree() + stats.getMemoryUsed()) / 1048576.0;
                System.out.println("[LaunchFile] Physical memory: " + physmegs + "m");
                System.out.println("[LaunchFile] Free physical free: " + freemegs + "m");
                if (xmx_pc_free != null) {
                    percent = Double.parseDouble(xmx_pc_free);
                    megs = (int)(percent / 100.0 * freemegs);
                    System.out.println("[LaunchFile] Calculated memory: " + megs + "m (" + percent + "%)");
                } else {
                    percent = Double.parseDouble(xmx_pc_phys);
                    megs = (int)(percent / 100.0 * physmegs);
                    System.out.println("[LaunchFile] Calculated memory: " + megs + "m (" + percent + "%)");
                }
                if (megs > max) {
                    megs = max;
                    System.out.println("[LaunchFile] Adjusted memory (maxed): " + megs + "m");
                }
                if (megs < min) {
                    megs = min;
                    System.out.println("[LaunchFile] Adjusted memory (minned): " + megs + "m");
                }
                resetXmx = "-Xmx" + megs + "m";
            }
        }
        if (resetXmx != null) {
            System.out.println("[LaunchFile] JVM memory size overridden by launch property to [" + resetXmx + "], must fork");
            launch.mustFork = true;
            boolean found = false;
            for (int i = 0; i < launch.jvmOptions.size(); ++i) {
                String opt = launch.jvmOptions.get(i);
                if (!opt.startsWith("-Xmx")) continue;
                System.out.println("[LaunchFile] Replaced existing Xmx option with " + resetXmx);
                launch.jvmOptions.set(i, resetXmx);
                found = true;
            }
            if (!found) {
                System.out.println("[LaunchFile] Added Xmx option with " + resetXmx);
                launch.jvmOptions.add(resetXmx);
            }
        }
        if ((headless_jvm = args.getProperty("headless_jvm_jvmargs")) != null) {
            System.out.println("[LaunchFile] JVM set headless JVM args by launch property, must fork");
            if (headless_jvm.equalsIgnoreCase("true")) {
                launch.jvmOptions.add("-Djava.awt.headless=true");
            }
        }
        if ((jip = args.getProperty("jip_options")) != null) {
            Object homedir;
            boolean useXML = false;
            if (jip.equalsIgnoreCase("xml")) {
                useXML = true;
            }
            if (!((String)(homedir = System.getProperty("user.home"))).endsWith(File.separator)) {
                homedir = (String)homedir + File.separator;
            }
            File tmp = File.createTempFile("JW_JIP", "properties");
            PrintStream pout = new PrintStream(new FileOutputStream(tmp));
            pout.println("profiler=on");
            if (useXML) {
                pout.println("output=xml");
                pout.println("file=jip." + args.getProperty("gu_virt_app") + "." + System.currentTimeMillis() + ".xml");
            } else {
                pout.println("output=text");
                pout.println("file=jip." + args.getProperty("gu_virt_app") + "." + System.currentTimeMillis() + ".txt");
            }
            pout.close();
            launch.jvmOptions.add("-javaagent:" + (String)homedir + "profile.jar");
            launch.jvmOptions.add("-Dprofile.properties=" + tmp.getAbsolutePath());
            System.out.println("[LaunchFile] Setting JIP agent: " + launch.jvmOptions.get(launch.jvmOptions.size() - 2));
            System.out.println("[LaunchFile] Setting JIP properties: " + launch.jvmOptions.get(launch.jvmOptions.size() - 1));
        }
        if (Switches.JW_customJvmArgsViaFork) {
            String[] jvmargs = LaunchFile.readEmbeddedJvmArgs(args);
            for (String string : jvmargs) {
                if (string == null || string.length() <= 0) continue;
                launch.jvmOptions.add(string);
                System.out.println("[LaunchFile] Custom JVM argument: " + (String)string);
            }
        }
        if (launch.mustFork && transmute) {
            System.out.println("[LaunchFile] App does not allow transmuting");
            transmute = false;
        }
        String virtualApp = args.getProperty("gu_virt_app");
        if (launchingGU) {
            virtualApp = null;
        } else {
            System.out.println("[LaunchFile] Asked to launch virtual app " + virtualApp);
        }
        JWApp jwapp = null;
        if (virtualApp == null) {
            System.out.println("[LaunchFile] Virtual app not specified, GU Launch?");
        } else if (virtualApp.equals(GenericUpdater.VAPP_SANITYCHECK)) {
            System.out.println("[LaunchFile] Running GU sanity check vapp - no JWAppSpec expected");
        } else if (virtualApp.equals(GenericUpdater.VAPP_UNINSTALLER)) {
            System.out.println("[LaunchFile] Running GU uninstaller vapp - no JWAppSpec expected");
        } else {
            try {
                jwapp = JWApp.load(dir, virtualApp);
            }
            catch (Exception x) {
                System.out.println("[LaunchFile] Unable to load virtual app [" + virtualApp + "] (" + x + "), returning that app does not exist");
                return 999001;
            }
        }
        System.out.println("[LaunchFile] will launch virtual app " + virtualApp + " for " + dir.getName() + ":\n" + launch);
        JWLaunchProperties.cleanDir(dir);
        JWLaunchProperties lprops = new JWLaunchProperties(dir);
        lprops.addStaticProperty("update_url", urlbase);
        lprops.addStaticProperty("app_dir", dir.getAbsolutePath());
        for (Object key1 : keys = args.keySet().toArray()) {
            String key = (String)key1;
            lprops.addDynamicProperty(key, args.getProperty(key));
        }
        ArrayList<String> list = launch.params;
        list.add(0, lprops.getFileRef());
        if (otherParams != null) {
            Collections.addAll(list, otherParams);
        }
        boolean bl = false;
        while (var20_35 < list.size()) {
            System.out.println("Param " + (int)var20_35 + ": " + list.get((int)var20_35));
            ++var20_35;
        }
        String[] stringArray = new String[list.size()];
        list.toArray(stringArray);
        String path = dir.getAbsolutePath();
        path = PathUtil.makePathNative(path);
        path = PathUtil.ensureTrailing(path);
        String[] jars = new String[launch.classpath.size()];
        for (int i = 0; i < jars.length; ++i) {
            jars[i] = path + launch.classpath.get(i);
        }
        VMFork fork = new VMFork(launch.mainClass, stringArray, dir);
        fork.setBaseClasspath(jars);
        fork.setCondenseClasspath(true);
        String dirpath = dir.getCanonicalFile().getAbsolutePath();
        if (dirpath.endsWith(File.separator)) {
            dirpath = dirpath.substring(0, dirpath.length() - 1);
        }
        if (AUTOCOPY_GU_JW_UTILS_AND_INCLUDE) {
            String utilsJarName = GenericUpdater.autoCopyJWrapperUtils(new File(GU_DIR), dir);
            fork.setClasspathExtras(new String[]{dirpath + File.separator + utilsJarName});
        }
        if (jre != null) {
            File javaExe;
            if (OS.isWindows()) {
                javaExe = new File(jre, "bin" + File.separator + "javaw.exe");
                try {
                    if (!javaExe.exists()) {
                        System.out.println("[LaunchFile] ************ ERROR ************");
                        System.out.println("[LaunchFile] The executable '" + javaExe + "' does not exist.");
                        System.out.println("[LaunchFile] JRE folder exists is " + jre.exists());
                        File bin = new File(jre, "bin");
                        System.out.println("[LaunchFile] Bin folder exists is " + bin.exists());
                        if (bin.exists()) {
                            File[] child;
                            StringBuilder files = new StringBuilder();
                            for (File f : child = bin.listFiles()) {
                                files.append(f.getName()).append("(").append(f.length()).append(") ");
                            }
                            System.out.println("[LaunchFile] Files in bin are: " + files);
                        }
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                File appExe = null;
                File jreBin = jre != null && jre.exists() ? new File(jre, "bin") : new File(JWSystem.getMyJreHome(), "bin");
                File jlauncher = new File(jreBin, "windowslauncher.exe");
                if (runAsExe != null) {
                    System.out.println("[LaunchFile] [JLauncher] Run the Windows Launcher as " + runAsExe);
                    appExe = new File(jreBin, runAsExe + ".exe");
                    File proposedLauncher = null;
                    if (jlauncher.exists()) {
                        System.out.println("[LaunchFile] [JLauncher] Using Windows Launcher: " + jlauncher.getAbsolutePath() + " (" + jlauncher.length() + ")");
                        System.out.println("[LaunchFile] [JLauncher] Setting up (windows) exe " + runAsExe);
                        proposedLauncher = jlauncher;
                    } else {
                        System.out.println("[LaunchFile] Setting up (windows) exe " + runAsExe);
                        proposedLauncher = javaExe;
                    }
                    boolean overwrite = true;
                    if (appExe.exists()) {
                        overwrite = false;
                        System.out.println("[LaunchFile] [JLauncher] " + appExe.getName() + " already exists (" + appExe.length() + ")");
                        if (proposedLauncher != null && appExe.length() != proposedLauncher.length()) {
                            try {
                                overwrite = appExe.delete();
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                                System.out.println("[LaunchFile] [JLauncher] Unable to delete existing launcher: " + ex.getClass().getName() + ": " + ex.getMessage() + " (perhaps it is in use)");
                            }
                        }
                    }
                    if (overwrite) {
                        try {
                            FileUtil.copy(proposedLauncher, appExe);
                        }
                        catch (IOException ex) {
                            appExe = null;
                            System.out.println("[LaunchFile] [JLauncher] Unable to overwrite launcher: " + ex.getClass().getName() + ": " + ex.getMessage());
                        }
                    }
                    System.out.println("[LaunchFile] [JLauncher] Using final launcher: " + appExe);
                }
                if (appExe != null && appExe.exists()) {
                    System.out.println("[LaunchFile] Using exe " + appExe);
                    javaExe = appExe;
                }
            } else {
                javaExe = new File(jre, "bin" + File.separator + "java");
                if (runAsExe != null) {
                    File appExe = new File(jre, "bin" + File.separator + runAsExe);
                    if (!appExe.exists()) {
                        System.out.println("[LaunchFile] Setting up (non windows) exe " + runAsExe);
                        AutoChmodFile.autoChmodFile(javaExe, appExe, false);
                    }
                    if (appExe.exists()) {
                        System.out.println("[LaunchFile] Using exe " + runAsExe);
                        javaExe = appExe;
                    }
                }
            }
            System.out.println("[LaunchFile] Java Exe: " + javaExe);
            fork.setJavaExe(javaExe.getCanonicalPath());
        }
        boolean usingOSXJWJLauncher = false;
        if (OS.isMacOS64bit() && OS.isMacOS1073OrLater()) {
            System.out.println("[LaunchFile] [JLauncher] OS is Mac OS X, 64bit, 10.7.3 or later");
            try {
                String launchedFrom = args.getProperty("launched_from_dynprops");
                if (launchedFrom != null) {
                    File wrapperPath = new File(launchedFrom);
                    System.out.println("[LaunchFile] Launched from is " + wrapperPath);
                    if (wrapperPath.exists()) {
                        if (wrapperPath.getParentFile() != null) {
                            File launcher = new File(wrapperPath.getParentFile(), "osxlauncher");
                            if (launcher.exists()) {
                                usingOSXJWJLauncher = true;
                                System.out.println("[LaunchFile] Using OSX Launcher: " + launcher);
                                fork.setJavaExe(launcher.getCanonicalFile().getAbsolutePath());
                            } else {
                                System.out.println("[LaunchFile] [JLauncher]  No OSX launcher exists.");
                            }
                        } else {
                            System.out.println("[LaunchFile] [JLauncher] No OSX launcher exists (no wrapper launch parent folder).");
                        }
                    } else {
                        System.out.println("[LaunchFile] [JLauncher] Wrapper path " + wrapperPath.getAbsolutePath() + " does not exist?");
                    }
                } else {
                    System.out.println("[LaunchFile] [JLauncher] Wrapper launched from dynprop not set (launched_from_dynprops), assuming no OSX launcher");
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        if (launch.jvmOptions.size() > 0) {
            int i;
            if (launchingGU) {
                System.out.println("[LaunchFile] Launching GU, will pick up last successful JVM options");
                File lso = LaunchFile.getJvmLastSuccessfulOptionsFile(dir.getParentFile(), jre);
                ArrayList<String> options = new ArrayList<String>();
                if (lso.exists()) {
                    BufferedInputStream in = new BufferedInputStream(new FileInputStream(lso));
                    try {
                        try {
                            int N = CFriendlyStreamUtils.readInt(in);
                            for (i = 0; i < N; ++i) {
                                String option = CFriendlyStreamUtils.readString(in);
                                options.add(option);
                                System.out.println("[LaunchFile] JVM Option " + i + "/" + N + ": " + option);
                            }
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                    }
                    finally {
                        FileUtil.robustClose(in);
                    }
                } else {
                    System.out.println("[LaunchFile] No existing JVM options");
                }
                LaunchFile.overrideHTTPSProtocols(args, options);
                System.out.println("[LaunchFile] Setting " + options.size() + " options");
                fork.setVMSpecificArgs(options.toArray(new String[0]));
                lprops.addStaticProperty("jvm_options_count", "" + options.size());
                for (int i2 = 0; i2 < options.size(); ++i2) {
                    lprops.addStaticProperty("jvm_options_" + i2, options.get(i2));
                }
            } else {
                String[] vmargs = new String[launch.jvmOptions.size()];
                launch.jvmOptions.toArray(vmargs);
                for (int i3 = 0; i3 < vmargs.length; ++i3) {
                    if (!vmargs[i3].equals("-javaagent:jwcrypt.jar")) continue;
                    vmargs[i3] = "-javaagent:" + path + "jwcrypt.jar";
                    System.out.println("[LaunchFile] Transforming JWC path to " + vmargs[i3]);
                }
                if (Switches.JW_vmargs_variables) {
                    String[] checks = new String[]{"$JW{YMD}", "$JW{HMS}", "$JW{YMDHMS}", "$JW{DATEMS}"};
                    Date date = new Date();
                    boolean containsArgs = false;
                    for (i = 0; i < vmargs.length; ++i) {
                        SimpleDateFormat sdf;
                        String vmarg = vmargs[i];
                        if (vmarg.contains("$JW{YMD}")) {
                            sdf = new SimpleDateFormat("yyyyMMdd");
                            vmarg = StringReplace.replaceAll(vmarg, "$JW{YMD}", sdf.format(date), true);
                            System.out.println("Substituted VM option: " + vmarg);
                        }
                        if (vmarg.contains("$JW{HMS}")) {
                            sdf = new SimpleDateFormat("HHmmss");
                            vmarg = StringReplace.replaceAll(vmarg, "$JW{HMS}", sdf.format(date), true);
                            System.out.println("Substituted VM option: " + vmarg);
                        }
                        if (vmarg.contains("$JW{YMDHMS}")) {
                            sdf = new SimpleDateFormat("yyyyMMddHHmmss");
                            vmarg = StringReplace.replaceAll(vmarg, "$JW{YMDHMS}", sdf.format(date), true);
                            System.out.println("Substituted VM option: " + vmarg);
                        }
                        if (vmarg.contains("$JW{DATEMS}")) {
                            sdf = new SimpleDateFormat("yyyyMMdd_HHmmss_SSS");
                            vmarg = StringReplace.replaceAll(vmarg, "$JW{DATEMS}", sdf.format(date), true);
                            System.out.println("Substituted VM option: " + vmarg);
                        }
                        vmargs[i] = vmarg;
                    }
                }
                fork.setVMSpecificArgs(vmargs);
                lprops.addStaticProperty("jvm_options_count", "" + vmargs.length);
                for (int i4 = 0; i4 < vmargs.length; ++i4) {
                    lprops.addStaticProperty("jvm_options_" + i4, vmargs[i4]);
                }
            }
        }
        if (OS.isMacOS() && !usingOSXJWJLauncher) {
            String name = null;
            if (jwapp != null) {
                name = jwapp.getUserVisibleName();
            }
            if (name == null || name.length() == 0) {
                name = args.getProperty("app_name");
            }
            System.out.println("[LaunchFile] JWApp = " + jwapp);
            if (jwapp != null) {
                System.out.println("[LaunchFile] App name = " + jwapp.getUserVisibleName());
            }
            System.out.println("[LaunchFile] PROP_APP_NAME = " + args.getProperty("app_name"));
            System.out.println("[LaunchFile] LAUNCHER_VIRTUAL_APP = " + args.getProperty("gu_virt_app"));
            System.out.println("[LaunchFile] Bundle name = " + bundleName);
            System.out.println("[LaunchFile] Detected OSX app name as " + name);
            if (!name.equals("JWrapper")) {
                fork.setVMSpecificArgs(new String[]{"-Xdock:name=" + name + ""});
            }
        }
        if (transmute) {
            System.out.println("[LaunchFile] Checking JVM folder ready for transmute");
            String myJvmHome = System.getProperty("java.home");
            System.out.println("[LaunchFile] Current JVM folder: [" + myJvmHome + "]");
            if (jre == null) {
                System.out.println("[LaunchFile] No JRE specified (on MacOS-32 we always use the current JVM)");
            } else {
                String targetJvmHome = jre.getAbsolutePath();
                System.out.println("[LaunchFile] Target JVM folder: [" + targetJvmHome + "]");
                if (new File(myJvmHome).equals(new File(targetJvmHome))) {
                    System.out.println("[LaunchFile] JVM folders match, OK to transmute");
                } else {
                    System.out.println("[LaunchFile] JVM folders do not match, unable to transmute, will fork and exit");
                    transmute = false;
                    mustExit = true;
                }
            }
        }
        if (transmute) {
            System.out.println("[LaunchFile] Checking JVM Options ready for transmute");
            System.out.println("[LaunchFile] Current JVM Options: [" + LaunchFile.getMyJvmOptionString() + "]");
            System.out.println("[LaunchFile] Target  JVM Options: [" + launch.getJvmOptionString() + "]");
            if (LaunchFile.getMyJvmOptionString().equals(launch.getJvmOptionString()) && !LaunchFile.getMyJvmOptionString().contains("javaagent:")) {
                System.out.println("[LaunchFile] JVM Options match, OK to transmute");
            } else {
                if (LaunchFile.getMyJvmOptionString().contains("javaagent:")) {
                    System.out.println("[LaunchFile] JVM Options do not match or using JWCrypt, unable to transmute, will fork and exit");
                } else {
                    System.out.println("[LaunchFile] JVM Options do not match, unable to transmute, will fork and exit");
                }
                transmute = false;
                mustExit = true;
            }
        }
        ArrayList<String> preJvmExecs = new ArrayList<String>();
        String insession = args.getProperty("launch_in_session");
        String inSpecificSession = args.getProperty("launch_in_specific_session");
        System.out.println("[LaunchFile] InSession = " + insession);
        System.out.println("[LaunchFile] InSpecificSession = " + inSpecificSession);
        File supplementaryExecutablesDir = dir;
        if (launchingGU) {
            File master = dir.getParentFile();
            supplementaryExecutablesDir = LaunchFile.getLatestVersionOf(args.getProperty("app_name"), master);
        }
        System.out.println("[LaunchFile] Supplementary executables dir is " + supplementaryExecutablesDir);
        if (insession != null && insession.trim().equalsIgnoreCase("true")) {
            boolean useSessionWin = OS.isWindowsVistaOrAbove();
            if (Switches.SH_1509_XP_RDP_SUPPORT) {
                boolean bl2 = useSessionWin = OS.isWindowsXpOr2003() || OS.isWindowsVistaOrAbove();
            }
            if (useSessionWin) {
                System.out.println("[LaunchFile] Launch must run in session (unable to transmute)");
                transmute = false;
                File elevator = new File(supplementaryExecutablesDir, "session_win.exe");
                if (!elevator.exists()) {
                    throw new IOException("Unable to run in session on Windows - this app has not been set up to launch virtual apps in session (" + elevator + " file does not exist)");
                }
                preJvmExecs.add(elevator.getCanonicalPath());
            }
        }
        if (inSpecificSession != null && !inSpecificSession.trim().equalsIgnoreCase("false")) {
            boolean isValid = false;
            try {
                Integer.parseInt(inSpecificSession);
                isValid = true;
            }
            catch (Throwable elevator) {
                // empty catch block
            }
            if (isValid) {
                System.out.println("[LaunchFile] Launch must run in session (unable to transmute) (" + inSpecificSession + ")");
                transmute = false;
                boolean launchInSession = OS.isWindowsVistaOrAbove();
                if (Switches.SH_1509_XP_RDP_SUPPORT) {
                    boolean bl3 = launchInSession = OS.isWindowsXpOr2003() || OS.isWindowsVistaOrAbove();
                }
                if (launchInSession) {
                    File elevator = new File(supplementaryExecutablesDir, "session_win.exe");
                    if (!elevator.exists()) {
                        throw new IOException("Unable to run in session on Windows - this app has not been set up to launch virtual apps in session");
                    }
                    preJvmExecs.add(elevator.getCanonicalPath());
                    preJvmExecs.add("--slConnectToSessionID" + inSpecificSession);
                }
            }
        }
        String pipePassword = null;
        String elevateSilent = args.getProperty("launch_elevate_silent");
        if (elevateSilent == null) {
            elevateSilent = "";
        }
        if (launchingGU) {
            elevateSilent = "";
        }
        if (OS.isWindows()) {
            elevateSilent = "";
        }
        if ((elevate = args.getProperty("launch_elevate")) == null) {
            elevate = "";
        }
        if (launchingGU) {
            elevate = "";
        }
        boolean haveRootPermissions = false;
        if (Switches.JW_launchFileCheckForRootPermissions) {
            if (OS.isLinux() && JWLinuxOS.haveSudoPermissions()) {
                haveRootPermissions = true;
                System.out.println("[LaunchFile] Have root permissions");
            }
            if (OS.isMacOS() && JWMacOS.haveSudoPermissions()) {
                haveRootPermissions = true;
                System.out.println("[LaunchFile] Have root permissions");
            }
        }
        if (elevateSilent.length() > 0) {
            System.out.println("[LaunchFile] Launch must elevate silently via credentials (unable to transmute)");
            transmute = false;
            if (OS.isLinux() || OS.isMacOS()) {
                preJvmExecs.add("sudo");
                preJvmExecs.add("-S");
                pipePassword = elevateSilent;
            }
        } else if (elevate.trim().equalsIgnoreCase("true") && !haveRootPermissions) {
            System.out.println("[LaunchFile] Launch must elevate via dialog (unable to transmute)");
            transmute = false;
            if (OS.isLinux()) {
                if (JWLinuxOS.isGkSudoAvailable()) {
                    fork.setMergeAllCommandsAfterPreExec(true);
                    fork.setEscapeSpacesAfterPreExec(true);
                    System.out.println("Elevation command set up, using gksudo");
                    preJvmExecs.add("gksudo");
                } else if (JWLinuxOS.isKdeSudoAvailable()) {
                    fork.setMergeAllCommandsAfterPreExec(true);
                    fork.setEscapeSpacesAfterPreExec(true);
                    System.out.println("Elevation command set up, using kdesudo");
                    preJvmExecs.add("kdesudo");
                } else if (JWLinuxOS.isBeeSuAvailable()) {
                    fork.setMergeAllCommandsAfterPreExec(true);
                    fork.setEscapeSpacesAfterPreExec(true);
                    System.out.println("Elevation command set up, using beesu");
                    preJvmExecs.add("beesu");
                } else if (JWLinuxOS.isPkExecAvailable()) {
                    System.out.println("Elevation command set up, using pkexec");
                    preJvmExecs.add("pkexec");
                } else if (JWLinuxOS.isGnomeSuAvailable()) {
                    System.out.println("Elevation command set up, using gnomesu");
                    preJvmExecs.add("gnomesu");
                } else {
                    System.out.println("WARNING: Unable to locate a suitable elevation command.");
                }
            } else if (OS.isMacOS()) {
                void var36_98;
                File elevator_nr = new File(supplementaryExecutablesDir, "elev_mac");
                if (!elevator_nr.exists()) {
                    throw new IOException("Unable to elevate on Mac - this app has not been set up to launch elevated virtual apps");
                }
                File elevator = new File(supplementaryExecutablesDir, "elev_mac_exe");
                elevator = AutoChmodFile.autoChmodFile(elevator_nr, elevator, false);
                String string = args.getProperty("app_name");
                if (virtualApp != null) {
                    String string2 = string + " - " + virtualApp;
                }
                System.out.println("Elevation command set up, using " + elevator);
                preJvmExecs.add(elevator.getCanonicalPath());
                preJvmExecs.add("--prompt=" + (String)var36_98);
            } else if (OS.isWindows()) {
                File elevator = new File(supplementaryExecutablesDir, "elev_win.exe");
                if (!elevator.exists()) {
                    throw new IOException("Unable to elevate on Windows - this app has not been set up to launch elevated virtual apps");
                }
                System.out.println("Elevation command set up, using " + elevator);
                preJvmExecs.add(elevator.getCanonicalPath());
            } else {
                throw new IOException("Unable to elevate on unknown base OS");
            }
        }
        String[] preJvmExec = new String[preJvmExecs.size()];
        preJvmExecs.toArray(preJvmExec);
        if (OS.isMacOS() && (requestedURL = JWMacOSEventManager.INSTANCE.getRequestedURL()) != null) {
            System.out.println("[LaunchFile] Detected existing request URL: " + requestedURL);
            lprops.addDynamicProperty("url_req", requestedURL);
        }
        System.out.println("[LaunchFile] Storing launch properties");
        lprops.store(true);
        if (transmute) {
            System.out.println("[LaunchFile] Transmuting:\n" + fork);
            VMTransmuter.transmuteInto(fork);
            System.out.println("[LaunchFile] Transmuted process returned, pausing\n" + fork);
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(9999999L);
                    }
                }
                catch (Throwable t) {
                    System.out.println("[LaunchFile] Transmute pause issue: " + t);
                    continue;
                }
                break;
            }
        }
        System.out.println("[LaunchFile] Forking:\n" + fork);
        if (preJvmExec == null) {
            p = fork.fork();
        } else {
            for (String aPreJvmExec : preJvmExec) {
                System.out.println("[LaunchFile] Pre-executing: " + aPreJvmExec);
            }
            p = fork.fork(preJvmExec);
        }
        if (pipePassword != null) {
            System.out.println("[LaunchFile] sending elevation password");
            OutputStream outputStream = p.getOutputStream();
            outputStream.write((pipePassword + "\n").getBytes());
            outputStream.flush();
        }
        ProcessPrinter.printAllOutputToStdout(p);
        if (waitForRetcode) {
            System.out.println("[LaunchFile] launched, waiting for return code of app");
            int n = p.waitFor();
            System.out.println("[LaunchFile] got return code (" + n + ")");
            return n;
        }
        if (mustExit) {
            System.out.println("[LaunchFile] *** launched, exiting in 0.5...");
            try {
                Thread.sleep(POST_LAUNCH_PRINT_FOR);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!InsideApplet.INSIDE_APPLET) {
                System.exit(0);
            }
        } else {
            System.out.println("[LaunchFile] *** launched (without exit, will print output below)");
        }
        return -1;
    }

    private LaunchFile(String mainClass, boolean willRequireUrl, String mainClassOnUpdate, String osxIcnsFile, String appName) {
        this(mainClass, willRequireUrl, mainClassOnUpdate, null, null, null, osxIcnsFile, appName);
    }

    public LaunchFile(String mainClass, boolean willRequireUrl, String mainClassOnUpdate, String mainClassForCompatibility, String mainClassPostInstall, String mainClassPreUninstall, String osxIcnsFile, String appName) {
        this.mainClass = mainClass;
        this.willRequireURL = willRequireUrl;
        this.appName = appName;
        if (mainClassOnUpdate == null) {
            mainClassOnUpdate = "";
        }
        this.mainClassOnUpdate = mainClassOnUpdate;
        if (mainClassForCompatibility == null) {
            mainClassForCompatibility = "";
        }
        this.mainClassForCompatibility = mainClassForCompatibility;
        if (mainClassPostInstall == null) {
            mainClassPostInstall = "";
        }
        this.mainClassPostInstall = mainClassPostInstall;
        if (mainClassPreUninstall == null) {
            mainClassPreUninstall = "";
        }
        this.mainClassPreUninstall = mainClassPreUninstall;
        if (osxIcnsFile == null) {
            osxIcnsFile = "";
        }
        this.osxIcnsFile = osxIcnsFile;
    }

    public void addClasspath(String s) {
        this.classpath.add(s);
    }

    public void insertClasspath(String s) {
        this.classpath.add(0, s);
    }

    public void addParam(String s) {
        this.params.add(s);
    }

    public void addJvmOption(String s) {
        this.jvmOptions.add(s);
    }

    public void setMustFork(boolean b) {
        this.mustFork = b;
    }

    public static String getMyJvmOptionString() {
        String s = " ";
        try {
            int n = Integer.parseInt(JWLaunchProperties.getProperty("jvm_options_count"));
            for (int i = 0; i < n; ++i) {
                s = s + JWLaunchProperties.getProperty("jvm_options_" + i);
                s = s + " ";
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return s;
    }

    public String getJvmOptionString() {
        String s = " ";
        for (String jvmOption : this.jvmOptions) {
            s = s + jvmOption;
            s = s + " ";
        }
        return s;
    }

    public void setMainClassForJreCompatibility(String mainClassForCompatibility) {
        if (mainClassForCompatibility == null) {
            mainClassForCompatibility = "";
        }
        this.mainClassForCompatibility = mainClassForCompatibility;
    }

    public void setMainClassForPostInstall(String mainClassForPostInstall) {
        if (mainClassForPostInstall == null) {
            mainClassForPostInstall = "";
        }
        this.mainClassPostInstall = mainClassForPostInstall;
    }

    public void setMainClassForPreUninstall(String mainClassForPreUninstall) {
        if (mainClassForPreUninstall == null) {
            mainClassForPreUninstall = "";
        }
        this.mainClassPreUninstall = mainClassForPreUninstall;
    }

    private File writeLaunchCommandFile() throws IOException {
        System.out.println("[LaunchFile] Writing command file");
        File f = new File("JWrapperLaunchTemp");
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(f));
            this.writeLaunchCommandFile(out);
            ((OutputStream)out).close();
        }
        catch (IOException x) {
            x.printStackTrace();
            throw x;
        }
        catch (Error x) {
            x.printStackTrace();
            throw x;
        }
        catch (RuntimeException x) {
            x.printStackTrace();
            throw x;
        }
        System.out.println("[LaunchFile] Wrote command file");
        return f;
    }

    public void writeLaunchCommandFile(OutputStream out) throws IOException {
        CFriendlyStreamUtils.writeInt(out, 6);
        CFriendlyStreamUtils.writeString(out, this.mainClass);
        CFriendlyStreamUtils.writeString(out, this.mainClassOnUpdate);
        CFriendlyStreamUtils.writeString(out, this.appName);
        CFriendlyStreamUtils.writeString(out, this.osxIcnsFile);
        CFriendlyStreamUtils.writeBoolean(out, this.willRequireURL);
        CFriendlyStreamUtils.writeInt(out, 0);
        CFriendlyStreamUtils.writeInt(out, 0);
        CFriendlyStreamUtils.writeInt(out, this.classpath.size());
        for (String aClasspath : this.classpath) {
            CFriendlyStreamUtils.writeString(out, aClasspath);
        }
        CFriendlyStreamUtils.writeInt(out, this.params.size());
        for (String param : this.params) {
            CFriendlyStreamUtils.writeString(out, param);
        }
        CFriendlyStreamUtils.writeString(out, this.mainClassForCompatibility);
        CFriendlyStreamUtils.writeString(out, this.mainClassPostInstall);
        CFriendlyStreamUtils.writeString(out, this.mainClassPreUninstall);
        CFriendlyStreamUtils.writeInt(out, this.jvmOptions.size());
        for (String jvmOption : this.jvmOptions) {
            CFriendlyStreamUtils.writeString(out, jvmOption);
        }
        CFriendlyStreamUtils.writeBoolean(out, this.mustFork);
    }

    public void addToArchive(Archive archive) throws IOException {
        System.out.println("[LaunchFile] Adding self to (launchable) archive");
        archive.addFile(this.writeLaunchCommandFile(), FILE_NAME);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Main Class: ").append(this.mainClass).append("\n");
        sb.append("Main Class on Update: ").append(this.mainClassOnUpdate).append("\n");
        sb.append("OSX ICNS file: ").append(this.osxIcnsFile).append("\n");
        for (String aClasspath : this.classpath) {
            sb.append("Classpath: ").append(aClasspath).append("\n");
        }
        for (String param : this.params) {
            sb.append("Param: ").append(param).append("\n");
        }
        return sb.toString();
    }

    private static void overrideHTTPSProtocols(Properties args, ArrayList<String> options) {
        String httpsProtocols = System.getProperty("https.protocols");
        if (args.getProperty("gu_protocols") != null) {
            httpsProtocols = args.getProperty("gu_protocols");
            System.out.println("[LaunchFile] Overriding inhertied https.protocols with '" + httpsProtocols + "'");
        }
        if (httpsProtocols != null && httpsProtocols.length() > 0) {
            System.out.println("[LaunchFile] Inheriting https.protocols setting '" + httpsProtocols + "'");
            boolean found = false;
            for (int i = 0; i < options.size(); ++i) {
                String opt = options.get(i);
                if (!opt.startsWith("-Dhttps.protocols")) continue;
                System.out.println("[LaunchFile] Replaced existing (" + opt + ") option with " + httpsProtocols);
                options.set(i, "-Dhttps.protocols=" + httpsProtocols);
                found = true;
            }
            if (!found) {
                System.out.println("[LaunchFile] Adding -Dhttps.protocols=" + httpsProtocols);
                options.add("-Dhttps.protocols=" + httpsProtocols);
            }
        }
    }
}

