/*
 * Decompiled with CFR 0.152.
 */
package jwrapper.ui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import jwrapper.ui.CanvasPanel;
import jwrapper.ui.RoundRectBorder;
import jwrapper.updater.JWApp;
import utils.swing.customlaf.SHBorderFactory;

public class JWAppletChooserFrame {
    static final int outerPadding = 30;
    static final int innerPadding = 5;
    static final int appWidth = 170;
    private AppOption[] options;
    private AppOption returnOption;
    private RoundRectBorder roundBorder;
    private RoundRectBorder roundBorderGray;
    private JDialog frame;

    public static String chooseVirtualApp(File appdir, JWApp[] apps) throws IOException {
        AppOption[] options = new AppOption[apps.length];
        for (int i = 0; i < apps.length; ++i) {
            options[i] = new AppOption(apps[i].getUserVisibleName(), ImageIO.read(new ByteArrayInputStream(apps[i].getLogoPNG())));
        }
        JWAppletChooserFrame chooser = new JWAppletChooserFrame(options);
        AppOption option = chooser.getChosenApp();
        return option.name;
    }

    public JWAppletChooserFrame(AppOption[] options) {
        this.options = options;
        this.initFrame();
    }

    private void initBorders() {
        this.roundBorder = new RoundRectBorder(Color.LIGHT_GRAY);
        this.roundBorder.setFillColor(Color.white);
        this.roundBorder.overrideWithPaint(new GradientPaint(0.0f, 0.0f, new Color(105, 190, 244), 0.0f, 200.0f, new Color(0, 135, 193)));
        this.roundBorderGray = new RoundRectBorder(Color.LIGHT_GRAY);
        this.roundBorderGray.setFillColor(Color.white);
        this.roundBorderGray.overrideWithPaint(new GradientPaint(0.0f, 0.0f, new Color(229, 229, 229), 0.0f, 200.0f, new Color(186, 186, 186)));
    }

    private void closeFrame() {
        this.frame.setVisible(false);
    }

    private void initFrame() {
        this.frame = new JDialog((Frame)null, true);
        this.frame.setDefaultCloseOperation(2);
        this.frame.setUndecorated(true);
        int rowsOfApps = this.options.length / 3;
        if (this.options.length % 3 > 0) {
            ++rowsOfApps;
        }
        int width = Math.min(this.options.length, 3) * 170 + 60 + Math.min(this.options.length - 1, 2) * 30;
        int height = 220 * rowsOfApps + 60 + 30 * (rowsOfApps - 1);
        this.frame.setSize(width, height);
        this.frame.setLocationRelativeTo(null);
        this.initBorders();
        CanvasPanel contentPanel = new CanvasPanel();
        contentPanel.setBorder(SHBorderFactory.createEmptyBorder(30, 30, 30, 30));
        contentPanel.setLayout(new GridLayout(rowsOfApps, 1, 30, 30));
        for (int row = 0; row < rowsOfApps; ++row) {
            CanvasPanel rowPanel = new CanvasPanel();
            GridBagLayout gbl = new GridBagLayout();
            rowPanel.setLayout(gbl);
            contentPanel.add(rowPanel);
            int appsInThisRow = Math.min(this.options.length - row * 3, 3);
            for (int i = row * 3; i < row * 3 + appsInThisRow; ++i) {
                JPanel borderPanel = new JPanel(new GridLayout(1, 1));
                borderPanel.setOpaque(false);
                AppPanel appPanel = new AppPanel(this.options[i]);
                appPanel.setOpaque(false);
                appPanel.setBorder(this.roundBorderGray);
                appPanel.addMouseListener(new BorderChangerListener());
                borderPanel.add(appPanel);
                if (i == row * 3) {
                    gbl.setConstraints(borderPanel, new GridBagConstraints(i, 0, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
                } else {
                    gbl.setConstraints(borderPanel, new GridBagConstraints(i, 0, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 30, 0, 0), 0, 0));
                }
                rowPanel.add(borderPanel);
            }
        }
        this.frame.getContentPane().add(contentPanel);
        CloseKeyListener closeKeyListener = new CloseKeyListener();
        this.frame.addKeyListener(closeKeyListener);
        contentPanel.addKeyListener(closeKeyListener);
        this.frame.setVisible(true);
    }

    public AppOption getChosenApp() {
        return this.returnOption;
    }

    public static void main(String[] args) throws IOException {
        BufferedImage img1 = ImageIO.read(new File("../PaidMedia/SimpleHelp/Logos/New/logo/green/sh_256.png"));
        BufferedImage img2 = ImageIO.read(new File("../PaidMedia/SimpleHelp/Logos/New/logo/normal/sh_256.png"));
        BufferedImage img3 = ImageIO.read(new File("../PaidMedia/SimpleHelp/Logos/New/logo/red/sh_256.png"));
        JWAppletChooserFrame chooser = new JWAppletChooserFrame(new AppOption[]{new AppOption("SimpleGateway\nService Configuration", img1), new AppOption("Run SimpleGateway", img2)});
        System.out.println("You picked: " + chooser.getChosenApp());
    }

    class AppPanel
    extends JPanel {
        int padding = 10;
        private AppOption option;
        private BufferedImage shadowImage;

        public AppPanel(AppOption option) {
            this.option = option;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dim = super.getPreferredSize();
            dim.width = 170;
            return dim;
        }

        @Override
        public Dimension getMinimumSize() {
            Dimension dim = super.getPreferredSize();
            dim.width = 170;
            return dim;
        }

        @Override
        public Dimension getMaximumSize() {
            Dimension dim = super.getPreferredSize();
            dim.width = 170;
            return dim;
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            Insets insets = this.getInsets();
            g2d.setColor(this.getBackground());
            g2d.fillRect(insets.left, insets.top, this.getWidth() - insets.left - insets.right, this.getHeight() - insets.top - insets.bottom);
            int desiredWidth = this.getWidth() - 2 * this.padding - insets.left - insets.right;
            g2d.drawImage(this.option.image, this.padding + insets.left, this.padding + insets.top, desiredWidth + this.padding + insets.left, desiredWidth + this.padding + insets.top, 0, 0, this.option.image.getWidth(null), this.option.image.getHeight(null), null);
            String[] rows = this.option.name.split("\n");
            FontRenderContext frc = g2d.getFontRenderContext();
            Font font = g2d.getFont();
            for (int i = 0; i < rows.length; ++i) {
                String text = rows[i];
                TextLayout layout = new TextLayout(text, font, frc);
                float textWidth = (float)layout.getBounds().getWidth();
                float textHeight = (float)layout.getBounds().getHeight();
                float targetX = (float)(this.getWidth() / 2) - textWidth / 2.0f;
                float targetY = (float)(insets.top + 2 * this.padding + 15 + desiredWidth) + (textHeight + 5.0f) * (float)i;
                g2d.setColor(Color.WHITE);
                layout.draw(g2d, targetX, targetY + 1.0f);
                g2d.setColor(new Color(30, 30, 30));
                layout.draw(g2d, targetX, targetY);
            }
        }
    }

    class CloseKeyListener
    extends KeyAdapter {
        CloseKeyListener() {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 27) {
                JWAppletChooserFrame.this.returnOption = null;
                JWAppletChooserFrame.this.closeFrame();
            }
        }
    }

    class BorderChangerListener
    extends MouseAdapter {
        BorderChangerListener() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            JWAppletChooserFrame.this.returnOption = ((AppPanel)e.getSource()).option;
            JWAppletChooserFrame.this.closeFrame();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            ((JComponent)e.getSource()).setBorder(JWAppletChooserFrame.this.roundBorder);
            ((JComponent)e.getSource()).setCursor(Cursor.getPredefinedCursor(12));
        }

        @Override
        public void mouseExited(MouseEvent e) {
            ((JComponent)e.getSource()).setBorder(JWAppletChooserFrame.this.roundBorderGray);
            ((JComponent)e.getSource()).setCursor(Cursor.getDefaultCursor());
        }
    }

    public static class AppOption {
        public String name;
        public Image image;

        public AppOption(String name, Image image) {
            this.name = name;
            this.image = image;
        }

        public String toString() {
            return this.name;
        }
    }
}

