/*
 * Decompiled with CFR 0.152.
 */
package jwrapper.jwutils;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import jwrapper.HeadlessLanguageChooserUtil;
import jwrapper.jwutils.JWGenericOS;
import jwrapper.jwutils.JWLinuxOS;
import jwrapper.jwutils.JWSystem;
import jwrapper.jwutils.JWSystemUI;
import jwrapper.jwutils.JWWindowsOS;
import jwrapper.updater.GenericUpdater;
import jwrapper.updater.JWApp;
import jwrapper.updater.JWLaunchProperties;
import utils.files.FileUtil;
import utils.ostools.OS;

public class JWInstallApp {
    static String lang;

    public static void exitJvm_ContinueAndSkipStandardSetup() {
        System.exit(42);
    }

    public static void exitJvm_ContinueAndPerformStandardSetup() {
        System.exit(41);
    }

    public static void exitJvm_QuitInstallAndRollBack() {
        System.exit(43);
    }

    private static File getChosenLanguageFile() {
        File appdir = JWSystem.getAppFolder();
        File master = appdir.getParentFile();
        File jwdir = JWApp.getJWAppsFolder(master);
        File chosen = new File(jwdir, "ChosenLanguage");
        return chosen;
    }

    public static String getChosenLanguage() throws IOException {
        if (lang != null) {
            return lang;
        }
        File file = JWInstallApp.getChosenLanguageFile();
        if (!file.exists()) {
            return null;
        }
        lang = FileUtil.readFileAsString(file.getCanonicalPath());
        return lang;
    }

    public static void setChosenLanguage(String code) throws IOException {
        File file = JWInstallApp.getChosenLanguageFile();
        FileUtil.writeFileAsString(file.getCanonicalPath(), code);
        lang = code;
        JWGenericOS.setWritableForAllUsers(file, false);
    }

    public static String showLanguageChooser() {
        return HeadlessLanguageChooserUtil.chooseLanguage(JWSystem.getSupportedLanguages());
    }

    public static void addUninstallerShortcut(String shortcutName) throws IOException {
        JWInstallApp.addUninstallerShortcutInFolder(shortcutName, null);
    }

    public static void addUninstallerShortcutInFolder(String shortcutName, File targetFolder) throws IOException {
        String app = JWSystem.getAppBundleName();
        File appdir = JWSystem.getAppFolder();
        File master = appdir.getParentFile();
        File uninstallerICO = new File(JWApp.getJWAppsFolder(master), GenericUpdater.getUninstallerIcoFileNameFor(app));
        JWInstallApp.addAppShortcutInFolder(shortcutName, GenericUpdater.VAPP_UNINSTALLER, uninstallerICO, 0, targetFolder);
    }

    public static void addUninstallerShortcut(String shortcutName, File iconFile, int iconIndex) throws IOException {
        JWInstallApp.addAppShortcut(shortcutName, GenericUpdater.VAPP_UNINSTALLER, iconFile, iconIndex);
    }

    public static void addUninstallerShortcutInFolder(String shortcutName, File iconFile, int iconIndex, File targetFolder) throws IOException {
        JWInstallApp.addAppShortcutInFolder(shortcutName, GenericUpdater.VAPP_UNINSTALLER, iconFile, iconIndex, targetFolder);
    }

    public static void addWebShortcut(String url, String shortcutName) throws IOException {
        JWApp jwapp = JWApp.getJWApp(JWSystem.getAppFolder(), url);
        JWInstallApp.addWebShortcut(shortcutName, jwapp.getFilesystemName(), null, 0);
    }

    public static void addWebShortcut(String url, String shortcutName, File iconFile, int iconIndex) throws IOException {
        JWInstallApp.addShortcut(shortcutName, url, iconFile, iconIndex, true, null, null);
    }

    public static void addAppShortcut(String shortcutName, String virtualAppName) throws IOException {
        JWApp jwapp = JWApp.getJWApp(JWSystem.getAppFolder(), virtualAppName);
        JWInstallApp.addAppShortcut(shortcutName, jwapp.getFilesystemName(), null, 0);
    }

    public static void removeAppShortcut(String shortcutName) throws IOException {
        JWInstallApp.removeShortcut(shortcutName, false);
    }

    public static void removeAppShortcut(String shortcutName, boolean web) throws IOException {
        JWInstallApp.removeShortcut(shortcutName, web);
    }

    private static void removeShortcut(String shortcutName, boolean web) throws IOException {
        boolean allUsers = JWSystem.getInstallType().equalsIgnoreCase("perm_all");
        if (OS.isWindows()) {
            JWWindowsOS win = new JWWindowsOS();
            File appmenu = win.getAppStartMenuFolder();
            File applink = new File(appmenu, shortcutName);
            if (web) {
                win.deleteWebShortcut(applink);
            } else {
                win.deleteShortcut(applink);
            }
            if (appmenu.listFiles().length == 0) {
                appmenu.delete();
            }
        } else if (OS.isLinux()) {
            if (web) {
                JWLinuxOS.deleteWebpageStartShortcut(shortcutName, allUsers);
            } else {
                JWLinuxOS.deleteApplicationStartShortcut(shortcutName, allUsers);
            }
        }
    }

    public static void addAppShortcut(String shortcutName, String virtualAppName, File iconFile, int iconIndex) throws IOException {
        JWInstallApp.addShortcut(shortcutName, virtualAppName, iconFile, iconIndex, false, null, null);
    }

    public static void addAppShortcutWithID(String shortcutName, String virtualAppName, File iconFile, int iconIndex, String appID) throws IOException {
        JWInstallApp.addShortcut(shortcutName, virtualAppName, iconFile, iconIndex, false, appID, null);
    }

    public static void addAppShortcutInFolder(String shortcutName, String virtualAppName, File iconFile, int iconIndex, File targetFolder) throws IOException {
        JWInstallApp.addShortcut(shortcutName, virtualAppName, iconFile, iconIndex, false, null, targetFolder);
    }

    public static void addAppShortcutWithIDInFolder(String shortcutName, String virtualAppName, File iconFile, int iconIndex, String appID, File targetFolder) throws IOException {
        JWInstallApp.addShortcut(shortcutName, virtualAppName, iconFile, iconIndex, false, appID, targetFolder);
    }

    private static void addShortcut(String shortcutName, String vappOrUrl, File iconFile, int iconIndex, boolean web, String appID, File targetDirectory) throws IOException {
        String app = JWSystem.getAppBundleName();
        File appdir = JWSystem.getAppFolder();
        File master = appdir.getParentFile();
        if (OS.isWindows()) {
            File launcher = new File(master, GenericUpdater.getLauncherNameFor(app, false, false, false, false));
            if (iconFile == null) {
                iconFile = launcher;
            }
            JWWindowsOS win = new JWWindowsOS();
            if (targetDirectory == null) {
                targetDirectory = win.getAppStartMenuFolder();
                System.out.println("[GenericUpdater] App start menu is " + targetDirectory);
                targetDirectory.mkdirs();
            } else {
                System.out.println("[GenericUpdater] Target shortcut parent is " + targetDirectory);
            }
            File applink = new File(targetDirectory, shortcutName);
            System.out.println("[GenericUpdater] Creating shortcut to " + launcher.getAbsolutePath() + " from " + applink.getAbsolutePath());
            System.out.println("[GenericUpdater] Using icon file " + iconFile.getAbsolutePath());
            if (web) {
                win.createWebShortcut(applink, vappOrUrl, iconFile, iconIndex);
            } else if (appID == null) {
                win.createShortcut(applink, "", launcher, "JWVAPP " + JWApp.normaliseName(vappOrUrl), iconFile, iconIndex);
            } else {
                win.createShortcutWithAppID(applink, "", launcher, "JWVAPP " + JWApp.normaliseName(vappOrUrl), iconFile, iconIndex, appID);
            }
        } else if (OS.isLinux()) {
            File launcher = new File(master, GenericUpdater.getLauncherNameFor(app, true, OS.isLinux64bit(), false, OS.isARM()));
            String command = "\"" + launcher.getCanonicalPath() + "\" JWVAPP " + JWApp.normaliseName(vappOrUrl);
            boolean allUsers = JWSystem.getInstallType().equalsIgnoreCase("perm_all");
            System.out.println("[GenericUpdater] Using icon file " + JWSystemUI.getMyAppLogoFile());
            if (web) {
                JWLinuxOS.createWebpageStartShortcut(shortcutName, shortcutName, vappOrUrl, allUsers, JWSystemUI.getMyAppLogoFile());
            } else {
                JWLinuxOS.createApplicationStartShortcut(shortcutName, shortcutName, command, allUsers, JWSystemUI.getMyAppLogoFile());
            }
        }
    }

    public static File getWindowsOrLinuxShortcutLauncherFile() {
        return new File(JWSystem.getAppFolder().getParentFile(), GenericUpdater.getLauncherNameFor(JWSystem.getAppBundleName(), OS.isLinux(), OS.isLinux64bit(), false, OS.isARM()));
    }

    public static void setupAllStandardShortcuts(boolean createMacOsApplicationLauncher) throws IOException {
        JWInstallApp.setupAllStandardShortcutsInFolder(createMacOsApplicationLauncher, null);
    }

    public static void setupAllStandardShortcutsInFolder(boolean createMacOsApplicationLauncher, File targetFolder) throws IOException {
        JWApp[] jwapps = JWApp.getAllJWApps(JWSystem.getAppFolder(), true);
        Properties osxLaunchProperties = JWLaunchProperties.getAsProperties();
        GenericUpdater.setupAllStandardShortcuts(JWSystem.getAppBundleName(), JWSystem.getAppFolder(), jwapps, osxLaunchProperties, null, createMacOsApplicationLauncher, targetFolder);
    }

    public static void setupAllStandardShortcutsInFolderAndOverrideProperties(boolean createMacOsApplicationLauncher, File targetFolder, Properties overridePropertiesOSX) throws IOException {
        JWApp[] jwapps = JWApp.getAllJWApps(JWSystem.getAppFolder(), true);
        Properties osxLaunchProperties = JWLaunchProperties.getAsProperties();
        GenericUpdater.setupAllStandardShortcuts(JWSystem.getAppBundleName(), JWSystem.getAppFolder(), jwapps, osxLaunchProperties, overridePropertiesOSX, createMacOsApplicationLauncher, targetFolder);
    }

    public static void removeAllStandardShortcuts() throws IOException {
        JWApp[] jwapps = JWApp.getAllJWApps(JWSystem.getAppFolder(), true);
        GenericUpdater.removeAllStandardShortcuts(jwapps, true);
    }
}

