/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.images;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.awt.image.IndexColorModel;
import java.awt.image.Kernel;
import java.awt.image.RGBImageFilter;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.swing.JTextPane;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import utils.swing.images.ColorFilter;
import utils.swing.images.ColorUtils;

public class ImageHelper {
    public static float LEFT = 0.0f;
    public static float CENTER = 0.5f;
    public static float RIGHT = 1.0f;
    static RenderingHints highQuality;
    public static final int ALIGN_CENTER = 1;
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_RIGHT = 2;
    public static final int ALIGN_JUSTIFIED = 3;

    public static RenderingHints getQualityRenderingHints() {
        if (highQuality == null) {
            RenderingHints hints = new RenderingHints(new HashMap());
            hints.put(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
            hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            hints.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
            hints.put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
            hints.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
            hints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            hints.put(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            highQuality = hints;
        }
        return highQuality;
    }

    public static BufferedImage toBufferedImageARGB(Image img) {
        return ImageHelper.toBufferedImageType(img, 2);
    }

    public static BufferedImage toBufferedImageRGB(Image img) {
        return ImageHelper.toBufferedImageType(img, 1);
    }

    public static BufferedImage toBufferedImageType(Image img, int imgType) {
        if (imgType == 0) {
            imgType = 2;
        }
        BufferedImage bimg = new BufferedImage(img.getWidth(null), img.getHeight(null), imgType);
        bimg.getGraphics().drawImage(img, 0, 0, null);
        return bimg;
    }

    public static BufferedImage toBufferedImageEquivalent(Image img, BufferedImage sameAsThis) {
        int type = sameAsThis.getType();
        if (type == 0) {
            type = 2;
        }
        return ImageHelper.toBufferedImageType(img, type);
    }

    public static boolean hasTransparentPixels(BufferedImage img) {
        int height = img.getHeight(null);
        int width = img.getWidth(null);
        img = ImageHelper.toBufferedImageARGB(img.getScaledInstance(width, height, 4));
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int n = img.getRGB(x, y);
                if (n >>> 24 == 255) continue;
                return true;
            }
        }
        return false;
    }

    public static BufferedImage replaceColor(BufferedImage img, Color orig, Color replace) {
        int origRGB = orig.getRGB();
        int repRGB = replace.getRGB();
        int height = img.getHeight(null);
        int width = img.getWidth(null);
        img = ImageHelper.toBufferedImageARGB(img.getScaledInstance(width, height, 4));
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int n = img.getRGB(x, y);
                if (n != origRGB) continue;
                img.setRGB(x, y, repRGB);
            }
        }
        return img;
    }

    public static BufferedImage scale(BufferedImage image, int width, int height) {
        return ImageHelper.toBufferedImageARGB(image.getScaledInstance(width, height, 4));
    }

    public static BufferedImage scaleDownProportionallyToFitInside(BufferedImage image, int boundingWidth, int boundingHeight, boolean highQuality) {
        int imageHeight = image.getHeight();
        int imageWidth = image.getWidth();
        double ratioWH = (double)imageWidth / (double)imageHeight;
        if (imageHeight <= boundingHeight && imageWidth <= boundingWidth) {
            return image;
        }
        if (ratioWH > (double)(boundingWidth / boundingHeight)) {
            int targetWidth = boundingWidth;
            int targetHeight = (int)((double)targetWidth / ratioWH);
            return ImageHelper.scaleDownToFitInside(image, targetWidth, targetHeight, highQuality);
        }
        int targetHeight = boundingHeight;
        int targetWidth = (int)((double)targetHeight * ratioWH);
        return ImageHelper.scaleDownToFitInside(image, targetWidth, targetHeight, highQuality);
    }

    public static BufferedImage scaleDownToFitInside(BufferedImage image, int width, int height) {
        return ImageHelper.scaleDownToFitInside(image, width, height, false);
    }

    public static BufferedImage scaleDownToFitInside(BufferedImage image, int width, int height, boolean highQuality) {
        double iwidth = image.getWidth();
        double iheight = image.getHeight();
        double iscale = Math.min(iwidth = (double)width / iwidth, iheight = (double)height / iheight);
        if (iscale > 1.0) {
            return image;
        }
        if (highQuality) {
            if (iscale < 0.7) {
                BufferedImage tmp = ImageHelper.scaleHQ(image, 0.75, 0.75);
                return ImageHelper.scaleDownToFitInside(tmp, width, height, true);
            }
            return ImageHelper.scaleHQ(image, iscale, iscale);
        }
        return ImageHelper.scale(image, iscale, iscale);
    }

    public static byte[] scaleDownToFitInside(byte[] sourceImage, int width, int height, boolean highQuality) throws IOException {
        BufferedImage image = ImageIO.read(new ByteArrayInputStream(sourceImage));
        BufferedImage result = ImageHelper.scaleDownToFitInside(image, width, height, highQuality);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)result, "jpg", bout);
        return bout.toByteArray();
    }

    public static void main(String[] args) throws IOException {
        BufferedImage image = ImageIO.read(new File("../JWrapper/sampleapp/logo.png"));
        image = ImageHelper.scaleDownToFitExactly(image, 256, 256, true);
        File f = new File("../JWrapper/sampleapp/logo2.png");
        FileOutputStream fout = new FileOutputStream(f);
        ImageIO.write((RenderedImage)image, "png", fout);
        fout.close();
    }

    public static BufferedImage scaleDownToFitExactly(BufferedImage image, int width, int height, boolean highQuality) {
        double iwidth = image.getWidth();
        double iheight = image.getHeight();
        if (width <= 0 || height <= 0) {
            return null;
        }
        iwidth = (double)width / iwidth;
        iheight = (double)height / iheight;
        if (iwidth == 1.0 && iheight == 1.0) {
            return image;
        }
        if (highQuality) {
            if (iwidth < 0.7 && iheight < 0.7) {
                BufferedImage tmp = ImageHelper.scaleHQ(image, 0.75, 0.75);
                return ImageHelper.scaleDownToFitInside(tmp, width, height, true);
            }
            return ImageHelper.scaleHQ(image, iwidth, iheight);
        }
        return ImageHelper.scale(image, iwidth, iheight);
    }

    public static Dimension getDimensionToFitInside(Dimension original, int widthBound, int heightBound) {
        double factor = Math.min((double)widthBound / original.getWidth(), (double)heightBound / original.getHeight());
        return new Dimension((int)(original.getWidth() * factor), (int)(original.getHeight() * factor));
    }

    public static BufferedImage scaleToFitInside(BufferedImage image, int width, int height) {
        return ImageHelper.scaleToFitInside(image, width, height, false);
    }

    public static BufferedImage scaleToFitInside(BufferedImage image, int width, int height, boolean highQuality) {
        double iwidth = image.getWidth();
        double iheight = image.getHeight();
        iwidth = (double)width / iwidth;
        iheight = (double)height / iheight;
        double iscale = Math.min(iwidth, iheight);
        if (highQuality) {
            return ImageHelper.scaleHQ(image, iscale, iscale);
        }
        return ImageHelper.scale(image, iscale, iscale);
    }

    public static BufferedImage flipHorizontal(BufferedImage image) {
        int imageWidth = image.getWidth();
        int imageHeight = image.getHeight();
        AffineTransform tx = AffineTransform.getScaleInstance(-1.0, 1.0);
        tx.translate(-image.getWidth(null), 0.0);
        AffineTransformOp scaleOp = new AffineTransformOp(tx, 1);
        int type = image.getType();
        if (type == 0) {
            type = 2;
        }
        return scaleOp.filter(image, new BufferedImage(imageWidth, imageHeight, type));
    }

    public static BufferedImage flipVertical(BufferedImage image) {
        int imageWidth = image.getWidth();
        int imageHeight = image.getHeight();
        AffineTransform tx = AffineTransform.getScaleInstance(1.0, -1.0);
        tx.translate(0.0, -image.getHeight(null));
        AffineTransformOp scaleOp = new AffineTransformOp(tx, 1);
        int type = image.getType();
        if (type == 0) {
            type = 2;
        }
        return scaleOp.filter(image, new BufferedImage(imageWidth, imageHeight, type));
    }

    public static BufferedImage scaleHQ(BufferedImage image, double xscale, double yscale) {
        int imageWidth = image.getWidth();
        int imageHeight = image.getHeight();
        AffineTransform scaleTransform = AffineTransform.getScaleInstance(xscale, yscale);
        AffineTransformOp scaleOp = new AffineTransformOp(scaleTransform, 2);
        int type = image.getType();
        if (type == 0) {
            type = 2;
        }
        return scaleOp.filter(image, new BufferedImage((int)(xscale * (double)imageWidth), (int)(yscale * (double)imageHeight), type));
    }

    public static BufferedImage scale(BufferedImage image, double xscale, double yscale) {
        return ImageHelper.toBufferedImageARGB(image.getScaledInstance((int)((double)image.getWidth(null) * xscale), (int)((double)image.getHeight(null) * yscale), 4));
    }

    public static BufferedImage scale(BufferedImage image, double xyscale) {
        return ImageHelper.toBufferedImageARGB(image.getScaledInstance((int)((double)image.getWidth(null) * xyscale), (int)((double)image.getHeight(null) * xyscale), 4));
    }

    public static BufferedImage rotate(BufferedImage image, double rotations, Color bgcolor) {
        if (rotations > 0.5) {
            rotations = 0.5 - rotations;
        }
        double a = (double)image.getWidth() / 2.0;
        double b = (double)image.getHeight() / 2.0;
        double hyp = Math.sqrt(a * a + b * b);
        int extent = (int)(hyp * 2.0 + 0.5);
        int xborder = (extent - image.getWidth()) / 2;
        int yborder = (extent - image.getHeight()) / 2;
        image = ImageHelper.addBorder(image, null, new Insets(yborder, xborder, yborder, xborder));
        AffineTransform transform = AffineTransform.getRotateInstance(rotations * Math.PI * 2.0, image.getWidth(null) / 2, image.getHeight(null) / 2);
        RenderingHints hints = ImageHelper.getQualityRenderingHints();
        AffineTransformOp op = new AffineTransformOp(transform, hints);
        int type = image.getType();
        if (type == 0) {
            type = 2;
        }
        BufferedImage dest = new BufferedImage(image.getWidth(), image.getHeight(), type);
        if (bgcolor == null) {
            dest.getGraphics().clearRect(-100000, -100000, 100000, 100000);
        } else {
            Graphics g = dest.getGraphics();
            g.setColor(bgcolor);
            g.fillRect(0, 0, image.getWidth(), image.getHeight());
        }
        op.filter(image, dest);
        return dest;
    }

    public static BufferedImage rotateTransparent(BufferedImage image, double rotations) {
        return ImageHelper.rotate(image, rotations, null);
    }

    public static void applyRGBFilter(Image img, Rectangle bounds, RGBImageFilter filter) {
        ImageHelper.applyRGBFilter(ImageHelper.toBufferedImageARGB(img), bounds, filter);
    }

    public static void applyRGBFilter(BufferedImage img, Rectangle bounds, RGBImageFilter filter) {
        BufferedImage bimg = img.getSubimage(bounds.x, bounds.y, bounds.width, bounds.height);
        Image grayImage = Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(bimg.getSource(), filter));
        img.getGraphics().drawImage(grayImage, bounds.x, bounds.y, null);
    }

    public static BufferedImage applyColorFilter(Image img, ColorFilter filter) throws IOException {
        BufferedImage bimg = img instanceof BufferedImage ? (BufferedImage)img : ImageHelper.toBufferedImageARGB(img);
        try {
            ImageHelper.applyReplacingFilter(bimg, new Rectangle(0, 0, bimg.getWidth(), bimg.getHeight()), filter);
        }
        catch (IOException x) {
            x.printStackTrace();
        }
        return bimg;
    }

    public static void applyReplacingFilter(BufferedImage img, Rectangle bounds, ImageFilter filter) throws IOException {
        BufferedImage bimg = img.getSubimage(bounds.x, bounds.y, bounds.width, bounds.height);
        Image grayImage = Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(bimg.getSource(), filter));
        grayImage = ImageHelper.toBufferedImageARGB(grayImage);
        Graphics2D g2 = (Graphics2D)img.getGraphics();
        g2.setBackground(new Color(0, 0, 0, 0));
        g2.clearRect(bounds.x, bounds.y, bounds.width, bounds.height);
        img.getGraphics().drawImage(grayImage, bounds.x, bounds.y, null);
    }

    public static int getAlphaARGB(int ARGB) {
        int alpha = ARGB >>> 24;
        return alpha;
    }

    private static void setAlphaFromDistance(BufferedImage image, int x, int y, int maxDist, int dist, int argb) {
        argb &= 0xFFFFFF;
        double ratio = (double)dist / (double)maxDist;
        int alpha = Math.max((int)(150.0 * ratio), 1);
        System.out.println(alpha + "->" + Integer.toHexString(alpha) + "->" + (argb |= alpha << 24));
        image.setRGB(x, y, argb);
    }

    public static BufferedImage softenTransparentEdges(BufferedImage image, int distance) {
        int y;
        int x;
        int alpha;
        int argb;
        int x2;
        int distanceSinceAlpha;
        int y2;
        distance = 7;
        int[] pixels = image.getRGB(0, 0, image.getWidth(), image.getHeight(), null, 0, image.getWidth());
        int height = image.getHeight();
        int width = image.getWidth();
        for (y2 = 0; y2 < height; ++y2) {
            distanceSinceAlpha = 9999;
            for (x2 = 0; x2 < width; ++x2) {
                argb = pixels[y2 * width + x2];
                alpha = ImageHelper.getAlphaARGB(argb);
                if (alpha == 0) {
                    distanceSinceAlpha = 0;
                    continue;
                }
                if (++distanceSinceAlpha >= distance) continue;
                ImageHelper.setAlphaFromDistance(image, x2, y2, distance, distanceSinceAlpha, argb);
            }
        }
        for (y2 = 0; y2 < height; ++y2) {
            distanceSinceAlpha = 9999;
            for (x2 = width - 1; x2 >= 0; --x2) {
                argb = pixels[y2 * width + x2];
                alpha = ImageHelper.getAlphaARGB(argb);
                if (alpha == 0) {
                    distanceSinceAlpha = 0;
                    continue;
                }
                if (++distanceSinceAlpha >= distance) continue;
                ImageHelper.setAlphaFromDistance(image, x2, y2, distance, distanceSinceAlpha, argb);
            }
        }
        for (x = 0; x < width; ++x) {
            distanceSinceAlpha = 9999;
            for (y = 0; y < height; ++y) {
                argb = pixels[y * width + x];
                alpha = ImageHelper.getAlphaARGB(argb);
                if (alpha == 0) {
                    distanceSinceAlpha = 0;
                    continue;
                }
                if (++distanceSinceAlpha >= distance) continue;
                ImageHelper.setAlphaFromDistance(image, x, y, distance, distanceSinceAlpha, argb);
            }
        }
        for (x = 0; x < width; ++x) {
            distanceSinceAlpha = 9999;
            for (y = height - 1; y >= 0; --y) {
                argb = pixels[y * width + x];
                alpha = ImageHelper.getAlphaARGB(argb);
                if (alpha == 0) {
                    distanceSinceAlpha = 0;
                    continue;
                }
                if (++distanceSinceAlpha >= distance) continue;
                ImageHelper.setAlphaFromDistance(image, x, y, distance, distanceSinceAlpha, argb);
            }
        }
        return image;
    }

    public static void drawText(Graphics2D g2, Rectangle bounds, Font f, String text, int align) {
        ImageHelper.drawText(g2, bounds, f, text, align, Color.black);
    }

    public static void drawText(Graphics2D g2, Rectangle bounds, Font f, String text, int align, Color color) {
        ImageHelper.drawText(g2, bounds, f, text, align, -1.0f, Color.black);
    }

    public static void drawText(Graphics2D g2, Rectangle bounds, Font f, String text, int align, float lineSpacing, Color color) {
        JTextPane area = new JTextPane();
        StyledDocument doc = area.getStyledDocument();
        SimpleAttributeSet standard = new SimpleAttributeSet();
        StyleConstants.setAlignment(standard, align);
        StyleConstants.setFontFamily(standard, f.getFontName());
        StyleConstants.setFontSize(standard, f.getSize());
        StyleConstants.setForeground(standard, color);
        if (lineSpacing != -1.0f) {
            StyleConstants.setLineSpacing(standard, lineSpacing);
        }
        doc.setParagraphAttributes(0, 0, standard, true);
        area.setText(text);
        area.setBackground(new Color(0, 0, 0, 0));
        area.setOpaque(false);
        area.setSize(bounds.width, bounds.height);
        area.setFont(f);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        area.paint(g2.create(bounds.x, bounds.y, bounds.width, bounds.height));
    }

    public static BufferedImage addBorder(BufferedImage image, Color col, Insets is) {
        int type = image.getType();
        if (type == 0) {
            type = 2;
        }
        BufferedImage dest = new BufferedImage(image.getWidth() + is.left + is.right, image.getHeight() + is.top + is.bottom, type);
        Graphics g = dest.getGraphics();
        if (col == null) {
            g.clearRect(-100000, -100000, 100000, 100000);
        } else if (col.getAlpha() != 255) {
            g.clearRect(-100000, -100000, 100000, 100000);
        }
        if (col != null) {
            g.setColor(col);
            g.fillRect(0, 0, dest.getWidth(), dest.getHeight());
        }
        g.drawImage(image, is.left, is.top, null);
        return dest;
    }

    public static BufferedImage[] getFullyRotated(BufferedImage orig, int count) {
        int N = count;
        BufferedImage[] images = new BufferedImage[count];
        for (int i = 0; i < N; ++i) {
            double rot = (double)i * (1.0 / (double)N);
            images[i] = ImageHelper.rotateTransparent(orig, rot);
        }
        return images;
    }

    public static BufferedImage getSimilarImage(BufferedImage img, int nwidth, int nheight) {
        int type = img.getType();
        if (type == 0) {
            type = 2;
        }
        BufferedImage bimg = img.getColorModel() instanceof IndexColorModel ? new BufferedImage(nwidth, nheight, type, (IndexColorModel)img.getColorModel()) : new BufferedImage(nwidth, nheight, type);
        return bimg;
    }

    public static BufferedImage createOverlay(Image main, Image overlay, boolean bottom, boolean right, double overlayProportionalSize, boolean scaleUpIfNecessary) {
        BufferedImage bimg = ImageHelper.toBufferedImageARGB(main);
        int oTargetWidth = (int)((double)main.getWidth(null) * overlayProportionalSize);
        int oTargetHeight = (int)((double)main.getHeight(null) * overlayProportionalSize);
        return ImageHelper.createOverlay(main, overlay, bottom, right, oTargetWidth, oTargetHeight, scaleUpIfNecessary);
    }

    public static BufferedImage createOverlay(Image main, Image overlay, boolean bottom, boolean right, int overlayMaxWidth, int overlayMaxHeight, boolean scaleUpIfNecessary) {
        return ImageHelper.createOverlay(main, overlay, bottom, right, false, false, overlayMaxWidth, overlayMaxHeight, scaleUpIfNecessary);
    }

    public static BufferedImage createOverlay(Image main, Image overlay, boolean bottom, boolean right, boolean hCentre, boolean vCentre, int overlayMaxWidth, int overlayMaxHeight, boolean scaleUpIfNecessary) {
        BufferedImage bimg = ImageHelper.toBufferedImageARGB(main);
        int oTargetWidth = overlayMaxWidth;
        int oTargetHeight = overlayMaxHeight;
        overlay = scaleUpIfNecessary ? ImageHelper.scaleToFitInside(ImageHelper.toBufferedImageARGB(overlay), oTargetWidth, oTargetHeight) : ImageHelper.scaleDownToFitInside(ImageHelper.toBufferedImageARGB(overlay), oTargetWidth, oTargetHeight);
        Graphics g = bimg.getGraphics();
        int x = 0;
        int y = 0;
        if (vCentre) {
            y = main.getHeight(null) / 2 - overlay.getHeight(null) / 2;
        } else if (bottom) {
            y = main.getHeight(null) - overlay.getHeight(null);
        }
        if (hCentre) {
            x = main.getWidth(null) / 2 - overlay.getWidth(null) / 2;
        } else if (right) {
            x = main.getWidth(null) - overlay.getWidth(null);
        }
        g.drawImage(overlay, x, y, null);
        return bimg;
    }

    public static void repeatOffsetText(BufferedImage img, String text, Color textcol) {
        ImageHelper.repeatOffsetText(img, text, textcol, 3);
    }

    public static void repeatOffsetText(BufferedImage img, String text, Color textcol, int perline) {
        Graphics g = img.getGraphics();
        int fsize = g.getFont().getSize();
        while (g.getFontMetrics().stringWidth(text) < img.getWidth() / perline) {
            fsize = (int)((double)fsize * 1.5);
            g.setFont(g.getFont().deriveFont((float)fsize));
        }
        g.setColor(textcol);
        FontMetrics fm = g.getFontMetrics();
        int chunkw = (int)(1.75 * (double)fm.stringWidth(text));
        int chunkh = (int)(1.75 * (double)(fm.getAscent() + fm.getDescent()));
        boolean on = true;
        for (int k = 20; k < img.getHeight(); k += chunkh) {
            for (int i = 0; i < img.getWidth(); i += chunkw) {
                if (on) {
                    g.drawString(text, i, k);
                    continue;
                }
                g.drawString(text, i + chunkw / 2, k);
            }
            on = !on;
        }
    }

    public static byte[] getARGB_Slow(BufferedImage image) {
        int pixelCount = image.getWidth() * image.getHeight();
        byte[] result = new byte[4 * pixelCount];
        int index = 0;
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                int argb = image.getRGB(x, y);
                ColorUtils.writeARGB(argb, result, index);
                index += 4;
            }
        }
        return result;
    }

    public static byte[] getRGBA_Slow(BufferedImage image) {
        int pixelCount = image.getWidth() * image.getHeight();
        byte[] result = new byte[4 * pixelCount];
        int index = 0;
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                int argb = image.getRGB(x, y);
                ColorUtils.writeRGBA(argb, result, index);
                index += 4;
            }
        }
        return result;
    }

    public static byte[] getRGB_Slow(BufferedImage image) {
        int pixelCount = image.getWidth() * image.getHeight();
        byte[] result = new byte[3 * pixelCount];
        int index = 0;
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                int rgb = image.getRGB(x, y);
                ColorUtils.writeRGB(rgb, result, index);
                index += 3;
            }
        }
        return result;
    }

    public static BufferedImage toSepia(BufferedImage img, int sepiaIntensity) {
        BufferedImage sepia = new BufferedImage(img.getWidth(), img.getHeight(), 2);
        int sepiaDepth = 20;
        int w = img.getWidth();
        int h = img.getHeight();
        int[] pixels = new int[w * h * 3];
        img.getRaster().getPixels(0, 0, w, h, pixels);
        for (int x = 0; x < img.getWidth(); ++x) {
            for (int y = 0; y < img.getHeight(); ++y) {
                int gry;
                int rgb = img.getRGB(x, y);
                Color color = new Color(rgb, true);
                int r = color.getRed();
                int g = color.getGreen();
                int b = color.getBlue();
                g = b = (gry = (r + g + b) / 3);
                r = b;
                g += sepiaDepth;
                if ((r += sepiaDepth * 2) > 255) {
                    r = 255;
                }
                if (g > 255) {
                    g = 255;
                }
                if (b > 255) {
                    b = 255;
                }
                if ((b -= sepiaIntensity) < 0) {
                    b = 0;
                }
                if (b > 255) {
                    b = 255;
                }
                color = new Color(r, g, b, color.getAlpha());
                sepia.setRGB(x, y, color.getRGB());
            }
        }
        return sepia;
    }

    public static BufferedImage toGreen(BufferedImage img, int greenIntensity) {
        BufferedImage green = new BufferedImage(img.getWidth(), img.getHeight(), 2);
        for (int x = 0; x < img.getWidth(); ++x) {
            for (int y = 0; y < img.getHeight(); ++y) {
                int rgb = img.getRGB(x, y);
                Color color = new Color(rgb, true);
                int r = color.getRed();
                int g = color.getGreen();
                int b = color.getBlue();
                int a = color.getAlpha();
                int old = g;
                g += greenIntensity;
                g = Math.min(255, g);
                g = Math.max(0, g);
                System.out.println(old + " -> " + g);
                color = new Color(r, g, b, a);
                green.setRGB(x, y, color.getRGB());
            }
        }
        return green;
    }

    public static Dimension scaleDimensionToFitInside(Dimension d, int w, int h) {
        double ratio = d.getWidth() / d.getHeight();
        double boundRatio = (double)w / (double)h;
        if (d.width < w && d.height < h) {
            return d;
        }
        if (ratio > boundRatio) {
            d.width = w;
            d.height = (int)((double)w / ratio);
        } else {
            d.height = h;
            d.width = (int)((double)h * ratio);
        }
        return d;
    }

    public static BufferedImage applyShadow(BufferedImage imgSource, int blurSize, int blurOffsetX, int blurOffsetY, Color color, float alpha) {
        BufferedImage result = ImageHelper.createCompatibleImage(imgSource, imgSource.getWidth(), imgSource.getHeight());
        Graphics2D g2d = result.createGraphics();
        g2d.drawImage((Image)ImageHelper.generateShadow(imgSource, blurSize, color, alpha), blurOffsetX, blurOffsetY, null);
        g2d.drawImage((Image)imgSource, 0, 0, null);
        g2d.dispose();
        return result;
    }

    public static BufferedImage applyShadowAndGrowImage(BufferedImage imgSource, int blurSize, int blurOffsetX, int blurOffsetY, Color color, float alpha) {
        BufferedImage result = ImageHelper.createCompatibleImage(imgSource, imgSource.getWidth() + blurSize * 2, imgSource.getHeight() + blurSize * 2);
        Graphics2D g2d = result.createGraphics();
        g2d.drawImage((Image)ImageHelper.generateShadow(imgSource, blurSize, color, alpha), blurOffsetX, blurOffsetY, null);
        g2d.drawImage((Image)imgSource, blurSize, blurSize, null);
        g2d.dispose();
        return result;
    }

    public static BufferedImage createCompatibleImage(int width, int height) {
        return ImageHelper.createCompatibleImage(width, height, 3);
    }

    public static BufferedImage createCompatibleImage(int width, int height, int transparency) {
        BufferedImage image = ImageHelper.getGraphicsConfiguration().createCompatibleImage(width, height, transparency);
        image.coerceData(true);
        return image;
    }

    public static BufferedImage createCompatibleImage(BufferedImage image) {
        return ImageHelper.createCompatibleImage(image, image.getWidth(), image.getHeight());
    }

    public static BufferedImage createCompatibleImage(BufferedImage image, int width, int height) {
        return ImageHelper.getGraphicsConfiguration().createCompatibleImage(width, height, image.getTransparency());
    }

    public static GraphicsConfiguration getGraphicsConfiguration() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    }

    public static int maxContrast(Color c1, Color c2) {
        int red = Math.abs(c1.getRed() - c2.getRed());
        int green = Math.abs(c1.getGreen() - c2.getGreen());
        int blue = Math.abs(c1.getBlue() - c2.getBlue());
        return Math.max(Math.max(red, green), blue);
    }

    public static BufferedImage generateShadow(BufferedImage imgSource, int size, Color color, float alpha) {
        int imgWidth = imgSource.getWidth() + 2 * size;
        int imgHeight = imgSource.getHeight() + 2 * size;
        BufferedImage imgMask = ImageHelper.createCompatibleImage(imgWidth, imgHeight);
        Graphics2D g2 = imgMask.createGraphics();
        g2.setRenderingHints(ImageHelper.getQualityRenderingHints());
        int x = size;
        int y = size;
        g2.drawImage((Image)imgSource, x, y, null);
        g2.dispose();
        BufferedImage imgGlow = ImageHelper.generateBlur(imgMask, size, color, alpha);
        return imgGlow;
    }

    public static BufferedImage generateBlur(BufferedImage imgSource, int size, Color color, float alpha) {
        int imgWidth = imgSource.getWidth();
        int imgHeight = imgSource.getHeight();
        BufferedImage imgBlur = ImageHelper.createCompatibleImage(imgWidth, imgHeight);
        Graphics2D g2 = imgBlur.createGraphics();
        g2.setRenderingHints(ImageHelper.getQualityRenderingHints());
        g2.drawImage((Image)imgSource, 0, 0, null);
        g2.setComposite(AlphaComposite.getInstance(5, alpha));
        g2.setColor(color);
        g2.fillRect(0, 0, imgSource.getWidth(), imgSource.getHeight());
        g2.dispose();
        imgBlur = ImageHelper.getGaussianBlurFilter(10, false).filter(imgBlur, null);
        imgBlur = ImageHelper.getGaussianBlurFilter(10, true).filter(imgBlur, null);
        return imgBlur;
    }

    public static Image applyMask(BufferedImage sourceImage, BufferedImage maskImage) {
        return ImageHelper.applyMask(sourceImage, maskImage, 6);
    }

    public static BufferedImage applyMask(BufferedImage sourceImage, BufferedImage maskImage, int method) {
        BufferedImage maskedImage = null;
        if (sourceImage != null) {
            int width = maskImage.getWidth(null);
            int height = maskImage.getHeight(null);
            maskedImage = new BufferedImage(width, height, 2);
            Graphics2D mg = maskedImage.createGraphics();
            int x = (width - sourceImage.getWidth(null)) / 2;
            int y = (height - sourceImage.getHeight(null)) / 2;
            mg.drawImage((Image)sourceImage, x, y, null);
            mg.setComposite(AlphaComposite.getInstance(method));
            mg.drawImage((Image)maskImage, 0, 0, null);
            mg.dispose();
        }
        return maskedImage;
    }

    public static ConvolveOp getGaussianBlurFilter(int radius, boolean horizontal) {
        int i;
        if (radius < 1) {
            throw new IllegalArgumentException("Radius must be >= 1");
        }
        int size = radius * 2 + 1;
        float[] data = new float[size];
        float sigma = (float)radius / 3.0f;
        float twoSigmaSquare = 2.0f * sigma * sigma;
        float sigmaRoot = (float)Math.sqrt((double)twoSigmaSquare * Math.PI);
        float total = 0.0f;
        for (i = -radius; i <= radius; ++i) {
            float distance = i * i;
            int index = i + radius;
            data[index] = (float)Math.exp(-distance / twoSigmaSquare) / sigmaRoot;
            total += data[index];
        }
        i = 0;
        while (i < data.length) {
            int n = i++;
            data[n] = data[n] / total;
        }
        Kernel kernel = null;
        kernel = horizontal ? new Kernel(size, 1, data) : new Kernel(1, size, data);
        return new ConvolveOp(kernel, 1, null);
    }
}

