/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.icons;

import java.util.Random;
import utils.swing.icons.CircularProgressIcon;
import utils.swing.icons.ProgressRef;
import utils.swing.icons.colorproviders.ColorProvider;
import utils.swing.icons.colorproviders.PastelColorProvider;

public class InfiniteCircularProgressIcon
extends CircularProgressIcon
implements Runnable {
    private ProgressRef[] array;
    private final Random r = new Random();
    protected int chosen = 0;
    private long sleep = 200L;
    private double speed = 0.07;
    private final double MAX = 1.0;
    long sleepTillTime = 0L;

    public InfiniteCircularProgressIcon(int w, int h) {
        this(w, h, new PastelColorProvider());
    }

    public void setSleep(long ms) {
        this.sleep = ms;
    }

    public void setSpeed(double mult) {
        this.speed = 0.09 * mult;
    }

    public InfiniteCircularProgressIcon(int w, int h, ColorProvider colorProvider) {
        super(w, h, colorProvider);
        int N = w / this.getThickness();
        if (N > 3) {
            N = 3;
        }
        if (N == 0) {
            this.thick = w / 2;
            N = 1;
        }
        this.array = new ProgressRef[N];
        for (int i = 0; i < N; ++i) {
            this.array[i] = new MetaProgressRef();
            this.addProgressRef(this.array[i]);
        }
        this.setRemoveWhenDone(false);
    }

    public void reinitRingCount(int N) {
        this.clearProgressRefs();
        this.array = new ProgressRef[N];
        for (int i = 0; i < N; ++i) {
            this.array[i] = new MetaProgressRef();
            this.addProgressRef(this.array[i]);
        }
    }

    @Override
    public void run() {
        if (this.array.length == 0 || System.currentTimeMillis() < this.sleepTillTime) {
            return;
        }
        this.progress();
        this.c.repaint();
    }

    public void progress() {
        int maxVisibleRings = this.getMaxVisibleRings();
        ProgressRef ref = this.array[this.chosen];
        if (ref.getActualProgress() < 1.0) {
            ref.setProgress(ref.getActualProgress() + this.speed);
        }
        if (ref.getActualProgress() > 0.5 && ref.isSelfConsuming()) {
            ref.setStart(ref.getActualStart() + this.speed);
        }
        if (ref.isComplete()) {
            ref.reset();
            MetaProgressRef mref = (MetaProgressRef)ref;
            if (!ref.isSelfConsuming()) {
                mref.setBackground(mref.getForeground());
            }
            mref.setForeground(mref.pickBackground ? this.colorProvider.nextBackgroundColor(0.0) : this.colorProvider.nextColor(0.0));
            boolean bl = mref.pickBackground = !mref.pickBackground;
            if (maxVisibleRings > 2) {
                int rint = Math.max(this.r.nextInt(maxVisibleRings), 1);
                this.chosen = (this.chosen + rint) % maxVisibleRings;
            } else if (maxVisibleRings > 1) {
                this.chosen = (this.chosen + 1) % maxVisibleRings;
            }
            mref = (MetaProgressRef)this.array[this.chosen];
            mref.reset();
            this.sleepTillTime = System.currentTimeMillis() + this.sleep;
        }
    }

    class MetaProgressRef
    extends ProgressRef {
        boolean pickBackground;
        boolean first;

        public MetaProgressRef() {
            super(0.0, true);
            this.pickBackground = true;
            this.first = false;
        }
    }
}

