/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.icons;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import javax.imageio.ImageIO;

public class ICNSReader {
    public static Image getImageFromICNSFile(File targetICNSFile) throws IOException {
        return (Image)ICNSReader.getFromICNSFile(targetICNSFile, false);
    }

    public static byte[] getPNGFromICNSFile(File targetICNSFile) throws IOException {
        return (byte[])ICNSReader.getFromICNSFile(targetICNSFile, true);
    }

    private static Object getFromICNSFile(File targetICNSFile, boolean bytesOnly) throws IOException {
        DataInputStream din = new DataInputStream(new BufferedInputStream(new FileInputStream(targetICNSFile)));
        HashMap<Integer, BufferedImage> map = new HashMap<Integer, BufferedImage>();
        byte[] temp = new byte[4];
        din.readFully(temp);
        if (!Arrays.equals(temp, new byte[]{105, 99, 110, 115})) {
            throw new IOException("Target file is not an ICNS file.");
        }
        din.readInt();
        ArrayList<BufferedImage> images = new ArrayList<BufferedImage>();
        while (din.available() > 0) {
            din.readFully(temp);
            int imageData = din.readInt() - 8;
            int size = 0;
            boolean isMask = temp[3] == 107;
            int keyIndex = 0;
            if (!isMask) {
                keyIndex = 1;
            }
            switch (temp[keyIndex]) {
                case 115: {
                    size = 16;
                    break;
                }
                case 108: {
                    size = 32;
                    break;
                }
                case 104: {
                    size = 48;
                    break;
                }
                case 116: {
                    size = 128;
                }
            }
            if (size > 0) {
                int rgb;
                BufferedImage image = (BufferedImage)map.get(new Integer(size));
                if (image == null) {
                    image = new BufferedImage(size, size, 2);
                    map.put(new Integer(size), image);
                }
                if (!isMask) {
                    for (int y = 0; y < image.getHeight(); ++y) {
                        for (int x = 0; x < image.getWidth(); ++x) {
                            rgb = image.getRGB(x, y);
                            int pixel = din.readInt();
                            image.setRGB(x, y, (pixel &= 0xFFFFFF) | (rgb &= 0xFF000000));
                        }
                    }
                    continue;
                }
                for (int y = 0; y < image.getHeight(); ++y) {
                    for (int x = 0; x < image.getWidth(); ++x) {
                        rgb = image.getRGB(x, y);
                        int alpha = din.readByte();
                        rgb &= 0xFFFFFF;
                        image.setRGB(x, y, rgb |= (alpha <<= 24));
                    }
                }
                continue;
            }
            boolean png = true;
            if (Arrays.equals(temp, new byte[]{105, 99, 48, 56})) {
                size = 256;
            } else if (Arrays.equals(temp, new byte[]{105, 99, 48, 57})) {
                size = 512;
            } else if (Arrays.equals(temp, new byte[]{105, 99, 49, 48})) {
                size = 1024;
            }
            if (size <= 0) continue;
            byte[] pngData = new byte[imageData];
            din.readFully(pngData);
            if (size == 256 && bytesOnly) {
                try {
                    din.close();
                }
                catch (Exception x) {
                    // empty catch block
                }
                return pngData;
            }
            ByteArrayInputStream bin = new ByteArrayInputStream(pngData);
            images.add(ImageIO.read(bin));
        }
        Set keys = map.keySet();
        for (Object key : keys) {
            images.add((BufferedImage)map.get(key));
        }
        int max = 0;
        BufferedImage maxImage = null;
        for (int i = 0; i < images.size(); ++i) {
            BufferedImage image = (BufferedImage)images.get(i);
            if (i == 0) {
                max = image.getWidth();
                maxImage = image;
                continue;
            }
            if (image.getWidth() <= max) continue;
            max = image.getWidth();
            maxImage = image;
        }
        try {
            din.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return maxImage;
    }
}

