/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.customlaf;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.text.View;
import utils.swing.customlaf.LegacySwingUtils;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.SHUI;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.switches.oem.OEMSwitches;

public class SHTabbedPaneUI
extends BasicTabbedPaneUI {
    private boolean drawBorders = false;
    private boolean drawShadow = true;
    private Color borderColor = !OEMSwitches.DARK_THEME ? SHButtonUI.getBorderColor(SHUI.BUTTON_NORMAL, false) : SHStyle.BORDER_COLOR;

    public SHTabbedPaneUI(boolean drawBorders, boolean drawShadow) {
        this.drawBorders = drawBorders;
        this.drawShadow = drawShadow;
    }

    @Override
    public void paintFocusIndicator(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
    }

    public static ComponentUI createUI(JComponent c) {
        return new SHTabbedPaneUI(false, false);
    }

    @Override
    protected Insets getContentBorderInsets(int tabPlacement) {
        if (this.drawBorders) {
            ScaledInsets contentBorderInsets = new ScaledInsets(4, 4, 4, 4);
            switch (tabPlacement) {
                case 1: {
                    contentBorderInsets.top = SimpleHelpLookAndFeel.scale(1);
                    contentBorderInsets.bottom = SimpleHelpLookAndFeel.scale(1);
                    break;
                }
                case 3: {
                    contentBorderInsets.bottom = SimpleHelpLookAndFeel.scale(6);
                    break;
                }
                case 2: {
                    contentBorderInsets.left = SimpleHelpLookAndFeel.scale(5);
                    contentBorderInsets.bottom = SimpleHelpLookAndFeel.scale(6);
                    break;
                }
                case 4: {
                    contentBorderInsets.right = SimpleHelpLookAndFeel.scale(5);
                    contentBorderInsets.bottom = SimpleHelpLookAndFeel.scale(6);
                }
            }
            return contentBorderInsets;
        }
        return new ScaledInsets(1, 0, 0, 0);
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.tabInsets = new ScaledInsets(2, 5, 2, 5);
    }

    @Override
    protected void paintContentBorderTopEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        Rectangle selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        g.setColor(this.borderColor);
        if (tabPlacement == 1 && selectedIndex >= 0 && selRect.y + selRect.height + 1 >= y && selRect.x >= x && selRect.x <= x + w) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setStroke(SHButtonUI.getBorderStroke());
            g2d.draw(new Line2D.Float(x, y, selRect.x, y));
            int xx = selRect.x + selRect.width - 1;
            g2d.draw(new Line2D.Float(xx, y, x + w, y));
        }
    }

    @Override
    protected void paintContentBorderLeftEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        Rectangle selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        g.setColor(this.borderColor);
        if (tabPlacement == 2 && selectedIndex >= 0 && selRect.x + selRect.width + 1 >= x && selRect.y >= y && selRect.y <= y + h) {
            float stroke = SHButtonUI.getBorderStrokeWidth();
            Graphics2D g2d = (Graphics2D)g;
            g2d.setStroke(SHButtonUI.getBorderStroke());
            g2d.drawLine((int)((float)x - stroke), (int)((float)y + stroke), (int)((float)x - stroke), y + h);
        }
    }

    @Override
    protected void paintContentBorderBottomEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        Rectangle selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        g.setColor(this.shadow);
        if (tabPlacement == 3 && selectedIndex >= 0 && selRect.y - 1 <= h && selRect.x >= x && selRect.x <= x + w) {
            g.drawLine(x + 1, y + h - 2, selRect.x - 1, y + h - 2);
            g.setColor(Color.YELLOW.darker());
            g.drawLine(x, y + h - 1, selRect.x - 1, y + h - 1);
            if (selRect.x + selRect.width < x + w - 2) {
                g.setColor(Color.ORANGE);
                g.drawLine(selRect.x + selRect.width, y + h - 2, x + w - 2, y + h - 2);
                g.setColor(Color.YELLOW.darker());
                g.drawLine(selRect.x + selRect.width, y + h - 1, x + w - 1, y + h - 1);
            }
        }
    }

    @Override
    protected void paintContentBorderRightEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        Rectangle selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        g.setColor(this.shadow);
        if (tabPlacement == 4 && selectedIndex >= 0 && selRect.x - 1 <= w && selRect.y >= y && selRect.y <= y + h) {
            g.drawLine(x + w - 2, y + 1, x + w - 2, selRect.y - 1);
            g.setColor(Color.MAGENTA);
            g.drawLine(x + w - 1, y, x + w - 1, selRect.y - 1);
            if (selRect.y + selRect.height < y + h - 2) {
                g.setColor(Color.MAGENTA.darker());
                g.drawLine(x + w - 2, selRect.y + selRect.height, x + w - 2, y + h - 2);
                g.setColor(Color.MAGENTA);
                g.drawLine(x + w - 1, selRect.y + selRect.height, x + w - 1, y + h - 2);
            }
        }
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        super.paint(g, c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.setStroke(SHButtonUI.getBorderStroke());
        float stroke = SHButtonUI.getBorderStrokeWidth();
        if (!OEMSwitches.DARK_THEME || !this.tabPane.isEnabled()) {
            g2d.setColor(SHButtonUI.getBorderColor(SHUI.BUTTON_NORMAL, isSelected));
        } else if (isSelected) {
            g2d.setColor(SHButtonUI.getBorderColor(SHUI.BUTTON_BLUE, true));
        } else {
            g2d.setColor(SHButtonUI.getBorderColor(SHUI.BUTTON_NORMAL, isSelected));
        }
        Rectangle2D.Float clip = tabPlacement == 2 ? new Rectangle2D.Float(x, y, (float)w - stroke, h) : new Rectangle2D.Float(x, y, w, h);
        Shape oldClip = g2d.getClip();
        try {
            g2d.clip(clip);
            switch (tabPlacement) {
                case 2: {
                    RoundRectangle2D.Float s = tabIndex == 0 || isSelected ? new RoundRectangle2D.Float(x, y, w + 2, (float)h - stroke, SHStyle.ARC, SHStyle.ARC) : new RoundRectangle2D.Float(x, (float)y - stroke, w + 2, (float)h + stroke - stroke, SHStyle.ARC, SHStyle.ARC);
                    g2d.draw(s);
                    return;
                }
                case 4: {
                    g.drawLine(x, y, x + w - 3, y);
                    g.setColor(this.shadow);
                    g.drawLine(x, y + h - 2, x + w - 3, y + h - 2);
                    g.drawLine(x + w - 2, y + 2, x + w - 2, y + h - 3);
                    g.setColor(this.darkShadow);
                    g.drawLine(x + w - 2, y + 1, x + w - 2, y + 1);
                    g.drawLine(x + w - 2, y + h - 2, x + w - 2, y + h - 2);
                    g.drawLine(x + w - 1, y + 2, x + w - 1, y + h - 3);
                    g.drawLine(x, y + h - 1, x + w - 3, y + h - 1);
                    return;
                }
                case 3: {
                    g.drawLine(x, y, x, y + h - 3);
                    g.drawLine(x + 1, y + h - 2, x + 1, y + h - 2);
                    g.setColor(this.shadow);
                    g.drawLine(x + 2, y + h - 2, x + w - 3, y + h - 2);
                    g.drawLine(x + w - 2, y, x + w - 2, y + h - 3);
                    g.setColor(this.darkShadow);
                    g.drawLine(x + 2, y + h - 1, x + w - 3, y + h - 1);
                    g.drawLine(x + w - 2, y + h - 2, x + w - 2, y + h - 2);
                    g.drawLine(x + w - 1, y, x + w - 1, y + h - 3);
                    return;
                }
                default: {
                    RoundRectangle2D.Float s = tabIndex == 0 || isSelected ? new RoundRectangle2D.Float(x, y, (float)w - stroke, h + 10, SHStyle.ARC, SHStyle.ARC) : new RoundRectangle2D.Float((float)x - stroke, y, (float)w + stroke - stroke, h + 10, SHStyle.ARC, SHStyle.ARC);
                    g2d.draw(s);
                    return;
                }
            }
        }
        finally {
            g2d.setClip(oldClip);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        Rectangle2D.Float clip;
        Graphics2D g2d = (Graphics2D)g;
        float width = SHButtonUI.getBorderStrokeWidth();
        if (tabPlacement == 2) {
            clip = new Rectangle2D.Float(x, y, (float)w - width, h);
        } else {
            if (isSelected) {
                ++h;
            }
            clip = new Rectangle2D.Float(x, y, w, h);
        }
        Shape oldClip = g2d.getClip();
        try {
            g2d.clip(clip);
            if (!OEMSwitches.DARK_THEME || !this.tabPane.isEnabled()) {
                if (isSelected) {
                    g2d.setPaint(SHButtonUI.getFill(SHUI.BUTTON_NORMAL, true, h, false));
                } else {
                    g2d.setPaint(SHButtonUI.getFill(SHUI.BUTTON_NORMAL, false, h, false));
                }
            } else if (isSelected) {
                g2d.setPaint(SHButtonUI.getFill(SHUI.BUTTON_BLUE, true, h, false));
            } else {
                g2d.setPaint(SHButtonUI.getFill(SHUI.BUTTON_NORMAL, false, h, false));
            }
            switch (tabPlacement) {
                case 2: {
                    g2d.fill(new RoundRectangle2D.Float(x, y, w + 10, (float)h - width, SHStyle.ARC, SHStyle.ARC));
                    return;
                }
                case 4: {
                    g2d.fillRect(x, y + 1, w - 2, h - 3);
                    return;
                }
                case 3: {
                    g2d.fillRect(x + 1, y, w - 3, h - 1);
                    return;
                }
                default: {
                    g2d.fill(new RoundRectangle2D.Float(x, y, (float)w - width, h + 10, SHStyle.ARC, SHStyle.ARC));
                    return;
                }
            }
        }
        finally {
            g2d.setClip(oldClip);
        }
    }

    @Override
    protected void paintText(Graphics g, int tabPlacement, Font font, FontMetrics metrics, int tabIndex, String title, Rectangle textRect, boolean isSelected) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.setFont(font);
        View v = this.getTextViewForTab(tabIndex);
        if (v != null) {
            v.paint(g, textRect);
        } else {
            int mnemIndex = this.tabPane.getDisplayedMnemonicIndexAt(tabIndex);
            if (this.tabPane.isEnabled() && this.tabPane.isEnabledAt(tabIndex)) {
                Color selectedFG;
                Color fg = this.tabPane.getForegroundAt(tabIndex);
                if (isSelected && fg instanceof UIResource && (selectedFG = UIManager.getColor("TabbedPane.selectedForeground")) != null) {
                    fg = selectedFG;
                }
                g.setColor(fg);
                LegacySwingUtils.drawStringUnderlineCharAt(this.tabPane, g, title, mnemIndex, textRect.x, textRect.y + metrics.getAscent());
            } else if (!OEMSwitches.DARK_THEME) {
                g.setColor(this.tabPane.getBackgroundAt(tabIndex).brighter());
                LegacySwingUtils.drawStringUnderlineCharAt(this.tabPane, g, title, mnemIndex, textRect.x, textRect.y + metrics.getAscent());
                g.setColor(this.tabPane.getBackgroundAt(tabIndex).darker());
                LegacySwingUtils.drawStringUnderlineCharAt(this.tabPane, g, title, mnemIndex, textRect.x - 1, textRect.y + metrics.getAscent() - 1);
            } else {
                g.setColor(UIManager.getColor("textInactiveText"));
                LegacySwingUtils.drawStringUnderlineCharAt(this.tabPane, g, title, mnemIndex, textRect.x, textRect.y + metrics.getAscent());
            }
        }
    }
}

