/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.customlaf;

import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import javax.swing.JButton;
import javax.swing.SwingConstants;
import utils.swing.customlaf.SHUI;
import utils.swing.customlaf.SimpleHelpLookAndFeel;

public class SHSpinnerButton
extends JButton
implements SwingConstants {
    private final GeneralPath arrowPath;
    protected int direction;

    public SHSpinnerButton(int direction) {
        this.setRequestFocusEnabled(false);
        this.setDirection(direction);
        float arrowWidth = SimpleHelpLookAndFeel.scale(5);
        this.arrowPath = new GeneralPath();
        this.arrowPath.moveTo(-arrowWidth / 2.0f, arrowWidth / 4.0f);
        this.arrowPath.lineTo(0.0f, -arrowWidth / 4.0f);
        this.arrowPath.lineTo(arrowWidth / 2.0f, arrowWidth / 4.0f);
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction) {
        this.direction = direction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.setColor(SHUI.SCROLL_BUTTON_ARROW);
        g2d.setStroke(new BasicStroke(SimpleHelpLookAndFeel.scale(1.0f)));
        double theta = 0.0;
        if (this.getDirection() == 5) {
            theta = Math.PI;
        } else if (this.getDirection() == 3) {
            theta = 1.5707963267948966;
        } else if (this.getDirection() == 7) {
            theta = 4.71238898038469;
        }
        AffineTransform oldTransform = g2d.getTransform();
        try {
            g2d.translate((float)this.getWidth() / 2.0f, (float)this.getHeight() / 2.0f);
            g2d.rotate(theta, 0.0, 0.0);
            g2d.draw(this.arrowPath);
        }
        finally {
            g2d.setTransform(oldTransform);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(SimpleHelpLookAndFeel.scale(14), SimpleHelpLookAndFeel.scale(14));
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(SimpleHelpLookAndFeel.scale(5), SimpleHelpLookAndFeel.scale(5));
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public boolean isFocusTraversable() {
        return false;
    }
}

