/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.cui.validators;

import java.util.regex.Pattern;
import utils.swing.cui.validators.AbstractTextFieldValidator;
import utils.xml.XML14Util;

public class TextFieldRegexContentValidator
extends AbstractTextFieldValidator {
    public static String PHONE_NUMBER_REGEX = "^[\\d+\\-\\s]+$";
    public static String NUMBER_INTEGER_REGEX = "^[\\d]+$";
    public static String NUMBER_FLOAT_REGEX = "^[\\d]*[\\d\\.]??[\\d]+$";
    public static String ALPHANUMERIC_REGEX = "^[\\d\\p{L}]+$";
    public static String LETTERS_REGEX = "^[\\p{L}]+$";
    public static String EMAIL_REGEX = "^[a-zA-Z\\d\\._%+-]+@[a-zA-Z\\d.-]+\\.[a-zA-Z]+$";
    public static String URL_REGEX = "^(https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]$";
    private Pattern pattern;
    private char[] anyOfTheCharacters;
    private String regex = null;

    public TextFieldRegexContentValidator(String regex) {
        this.regex = regex;
        this.pattern = Pattern.compile(regex);
    }

    public TextFieldRegexContentValidator(char[] anyOfTheCharacters) {
        this.anyOfTheCharacters = anyOfTheCharacters;
        StringBuffer buffer = new StringBuffer();
        buffer.append("^[");
        for (int i = 0; i < anyOfTheCharacters.length; ++i) {
            buffer.append(anyOfTheCharacters[i]);
        }
        buffer.append("]+$");
        this.pattern = Pattern.compile(buffer.toString());
    }

    @Override
    protected boolean isValid(String contents) {
        return this.pattern.matcher(contents).matches();
    }

    @Override
    public String getValidatorID() {
        return "textFieldRegex";
    }

    @Override
    public String toXML() {
        if (this.anyOfTheCharacters != null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("<Validator type=\"" + this.getValidatorID() + "\" class=\"characters\">");
            for (int i = 0; i < this.anyOfTheCharacters.length; ++i) {
                if (i > 0) {
                    buffer.append(",");
                }
                buffer.append(XML14Util.escape(Character.toString(this.anyOfTheCharacters[i])));
            }
            buffer.append("</Validator>");
            return buffer.toString();
        }
        if (this.regex != null) {
            return "<Validator type=\"" + this.getValidatorID() + "\" class=\"regex\">" + XML14Util.escape(this.regex) + "</Validator>";
        }
        return "";
    }
}

