/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.components;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JSeparator;
import javax.swing.ListCellRenderer;
import utils.swing.JComboBoxFixer;
import utils.swing.customlaf.SHBorderFactory;

public class SHComboBox
extends JComboBox {
    public static String SEPARATOR = "SEPARATOR";
    private ComboBoxRenderer renderer;

    public SHComboBox() {
        this.initUI();
    }

    public SHComboBox(Object[] elements) {
        super(elements);
        this.initUI();
    }

    public void setIconInterface(IconInterface iconInterface) {
        this.renderer.setIconInterface(iconInterface);
    }

    private void initUI() {
        JComboBoxFixer.fix(this);
        this.renderer = new ComboBoxRenderer();
        this.setRenderer(this.renderer);
    }

    class ComboBoxRenderer
    extends JLabel
    implements ListCellRenderer {
        private JSeparator separator;
        private IconInterface iconInterface = null;

        public ComboBoxRenderer() {
            this.setOpaque(true);
            this.setBorder(SHBorderFactory.createEmptyBorder(2, 4, 2, 4));
            this.separator = new JSeparator(0);
            this.separator.setPreferredSize(new Dimension(0, 10));
        }

        public void setIconInterface(IconInterface iconInterface) {
            this.iconInterface = iconInterface;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Icon iconFor;
            String str;
            String string = str = value == null ? "" : value.toString();
            if (SEPARATOR.equals(str)) {
                return this.separator;
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setFont(list.getFont());
            this.setText(str);
            this.setIcon(null);
            if (this.iconInterface != null && index >= 0 && (iconFor = this.iconInterface.getIconFor(index)) != null) {
                this.setIcon(iconFor);
            }
            return this;
        }
    }

    public static interface IconInterface {
        public Icon getIconFor(int var1);
    }
}

