/*
 * Decompiled with CFR 0.152.
 */
package utils.stream;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import utils.progtools.Cleanable;
import utils.stream.StreamCloseListener;

public class StreamCloseDetector {
    boolean closed = false;
    InputStream in;
    OutputStream out;
    WriteThread wt;
    ReadThread rt;
    CheckThread ct;
    String reason = "";
    StreamCloseListener listener;
    long timeoutMS;

    public StreamCloseDetector(InputStream in, OutputStream out, StreamCloseListener listener, long inactivityTimeoutMS) {
        this.in = in;
        this.out = out;
        this.listener = listener;
        this.timeoutMS = inactivityTimeoutMS;
        try {
            out.write(0);
            out.flush();
            in.read();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.wt = new WriteThread();
        this.rt = new ReadThread();
        this.ct = new CheckThread();
        this.wt.start();
        this.rt.start();
        this.ct.start();
    }

    private void markClosed(String reason) {
        if (!this.closed) {
            this.reason = reason;
            this.closed = true;
            try {
                this.rt.interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.wt.interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void main(String[] args) {
        new Client().start();
        new Server().start();
    }

    static class Server
    extends Thread
    implements StreamCloseListener {
        Server() {
        }

        @Override
        public void run() {
            try {
                ServerSocket ssock = new ServerSocket(9999);
                Socket sock = ssock.accept();
                StreamCloseDetector scd = new StreamCloseDetector(sock.getInputStream(), sock.getOutputStream(), this, 10000L);
                Thread.sleep(4000L);
                scd.wt.TEST_NO_WRITE = true;
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }

        @Override
        public void streamClosed(String reason) {
            System.out.println("Server closed (" + reason + ")");
        }
    }

    static class Client
    extends Thread
    implements StreamCloseListener {
        Client() {
        }

        @Override
        public void run() {
            try {
                Thread.sleep(1000L);
                Socket sock = new Socket("localhost", 9999);
                new StreamCloseDetector(sock.getInputStream(), sock.getOutputStream(), this, 10000L);
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }

        @Override
        public void streamClosed(String reason) {
            System.out.println("Client closed (" + reason + ")");
        }
    }

    class CheckThread
    extends Thread
    implements Cleanable {
        CheckThread() {
        }

        @Override
        public void run() {
            while (!StreamCloseDetector.this.closed) {
                try {
                    Thread.sleep(2500L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (System.currentTimeMillis() - StreamCloseDetector.this.rt.lastRead <= StreamCloseDetector.this.timeoutMS) continue;
                StreamCloseDetector.this.markClosed("Reads timed out (presumed remote closure)");
            }
            StreamCloseDetector.this.listener.streamClosed(StreamCloseDetector.this.reason);
        }

        @Override
        public void cleanupNow() {
            StreamCloseDetector.this.markClosed("Cleanable request");
        }
    }

    class ReadThread
    extends Thread
    implements Cleanable {
        long lastRead = System.currentTimeMillis();

        ReadThread() {
        }

        @Override
        public void run() {
            while (!StreamCloseDetector.this.closed) {
                try {
                    int n = StreamCloseDetector.this.in.read();
                    if (n == -1) {
                        StreamCloseDetector.this.markClosed("Stream was closed (read -1)");
                    }
                    this.lastRead = System.currentTimeMillis();
                }
                catch (IOException x) {
                    StreamCloseDetector.this.markClosed("Stream was closed (read exception)");
                }
            }
        }

        @Override
        public void cleanupNow() {
            StreamCloseDetector.this.markClosed("Cleanable request");
        }
    }

    class WriteThread
    extends Thread
    implements Cleanable {
        boolean TEST_NO_WRITE = false;

        WriteThread() {
        }

        @Override
        public void run() {
            while (!StreamCloseDetector.this.closed) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (this.TEST_NO_WRITE) continue;
                    StreamCloseDetector.this.out.write(0);
                    StreamCloseDetector.this.out.flush();
                }
                catch (IOException x) {
                    StreamCloseDetector.this.markClosed("Stream was closed (write exception)");
                }
            }
        }

        @Override
        public void cleanupNow() {
            StreamCloseDetector.this.markClosed("Cleanable request");
        }
    }
}

