/*
 * Decompiled with CFR 0.152.
 */
package utils.progtools;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class MapOfLists<K, V> {
    private final HashMap<K, LinkedList<V>> keyToLinkedList = new HashMap();
    private boolean permitDuplicates;

    public Collection<K> keySet() {
        return this.keyToLinkedList.keySet();
    }

    public Collection<LinkedList<V>> values() {
        return this.keyToLinkedList.values();
    }

    public MapOfLists(boolean permitDuplicates) {
        this.permitDuplicates = permitDuplicates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(K key, V value) {
        HashMap<K, LinkedList<V>> hashMap = this.keyToLinkedList;
        synchronized (hashMap) {
            LinkedList<Object> list = this.keyToLinkedList.get(key);
            if (list == null) {
                list = new LinkedList();
                this.keyToLinkedList.put(key, list);
            }
            if (!this.permitDuplicates && list.contains(value)) {
                return;
            }
            list.add(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<V> get(K key) {
        HashMap<K, LinkedList<V>> hashMap = this.keyToLinkedList;
        synchronized (hashMap) {
            return this.keyToLinkedList.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll(K key) {
        HashMap<K, LinkedList<V>> hashMap = this.keyToLinkedList;
        synchronized (hashMap) {
            this.keyToLinkedList.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(K key, V value) {
        HashMap<K, LinkedList<V>> hashMap = this.keyToLinkedList;
        synchronized (hashMap) {
            LinkedList<V> list = this.keyToLinkedList.get(key);
            if (list == null) {
                return;
            }
            list.remove(value);
            if (list.size() == 0) {
                this.keyToLinkedList.remove(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(K key, V value) {
        HashMap<K, LinkedList<V>> hashMap = this.keyToLinkedList;
        synchronized (hashMap) {
            LinkedList<V> list = this.keyToLinkedList.get(key);
            if (list == null) {
                return false;
            }
            return list.contains(value);
        }
    }
}

