/*
 * Decompiled with CFR 0.152.
 */
package utils.osstats.winutils;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import utils.osstats.winutils.WmicRows;
import utils.ostools.RunCommandGetOutput;

public class WmicUtil
extends Thread {
    private static final boolean VERBOSE = false;
    ArrayList<String> commands = new ArrayList();
    InputStream in;
    OutputStream out;
    Object LOCK = new Object();
    ByteArrayOutputStream bout = new ByteArrayOutputStream();
    private static String wmicExe = "wmic.exe";

    public static void initWindowsDirectory(String windowsDir) {
        File wbem;
        File wmic;
        File winDir = new File(windowsDir);
        File system32 = new File(winDir, "system32");
        if (!system32.exists()) {
            system32 = new File(winDir, "System32");
        }
        if (!system32.exists()) {
            system32 = new File(winDir, "SysWOW64");
        }
        if (!system32.exists()) {
            system32 = new File(winDir, "system32");
        }
        if (!(wmic = new File(wbem = new File(system32, "wbem"), "WMIC.exe")).exists()) {
            wmic = new File(wbem, "wmic.exe");
        }
        if (wmic.exists()) {
            wmicExe = wmic.getAbsolutePath();
            System.out.println("[WmicUtil] Found wmic location: " + wmicExe);
        }
    }

    public WmicUtil() {
        try {
            Process p = WmicUtil.launchWmicCommand("");
            this.in = new BufferedInputStream(p.getInputStream());
            this.out = p.getOutputStream();
            new Ignore(new BufferedInputStream(p.getErrorStream()));
            this.out.write(10);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.start();
    }

    public static Process launchWmicCommand(String suffix) throws IOException {
        File ff = new File(System.getProperty("java.io.tmpdir"));
        Process p = Runtime.getRuntime().exec("\"" + wmicExe + "\" " + suffix, null, ff);
        return p;
    }

    public static String[] launchWmicCommandGetOutput(String[] strings) {
        File ff = new File(System.getProperty("java.io.tmpdir"));
        String[] cmd = new String[strings.length + 1];
        cmd[0] = wmicExe;
        for (int i = 0; i < strings.length; ++i) {
            cmd[i + 1] = strings[i];
        }
        return RunCommandGetOutput.runCommandGetOutput(cmd, ff);
    }

    public static RunCommandGetOutput.CommandResponse launchWmicCommandGetResponse(String[] strings) {
        File ff = new File(System.getProperty("java.io.tmpdir"));
        String[] cmd = new String[strings.length + 1];
        cmd[0] = wmicExe;
        for (int i = 0; i < strings.length; ++i) {
            cmd[i + 1] = strings[i];
        }
        return RunCommandGetOutput.runCommand(cmd, ff);
    }

    public void startService(String serviceName) {
        this.sendCommand("service where Name=\"" + serviceName + "\" call StartService", false);
    }

    public void stopService(String serviceName) {
        this.sendCommand("service where Name=\"" + serviceName + "\" call StopService", false);
    }

    public void setServiceStartModeDisabled(String serviceName) {
        this.sendCommand("service where Name=\"" + serviceName + "\" call ChangeStartMode Disabled", false);
    }

    public void setServiceStartModeAutomatic(String serviceName) {
        this.sendCommand("service where Name=\"" + serviceName + "\" call ChangeStartMode Automatic", false);
    }

    public void setServiceStartModeManual(String serviceName) {
        this.sendCommand("service where Name=\"" + serviceName + "\" call ChangeStartMode Manual", false);
    }

    public void sendCommand(String s, boolean interactive) {
        try {
            if (!interactive) {
                s = "/interactive:off " + s;
            }
            this.commands.add(s);
            this.out.write(s.getBytes());
            this.out.write(10);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void finish() {
        try {
            this.out.write("quit".getBytes());
            this.out.write(10);
            this.out.flush();
            this.out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getResults() {
        this.finish();
        Object object = this.LOCK;
        synchronized (object) {
            try {
                this.join();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return new String(this.bout.toByteArray());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getResultsArray() {
        this.finish();
        Object object = this.LOCK;
        synchronized (object) {
            int lastIndex = 0;
            try {
                this.join();
            }
            catch (Exception exception) {
                // empty catch block
            }
            String output = new String(this.bout.toByteArray());
            if (output.length() == 0) {
                System.err.println("[WmicUtils] WARNING: Wmic has failed to produce any output.");
                return null;
            }
            String[] results = new String[this.commands.size()];
            for (int i = 0; i < results.length; ++i) {
                int commandBegin;
                String command = ">" + this.commands.get(i);
                String nextcommand = null;
                if (i < this.commands.size() - 1) {
                    nextcommand = ">" + this.commands.get(i + 1);
                }
                if ((commandBegin = output.indexOf(command, lastIndex)) == -1) {
                    commandBegin = output.indexOf("wmic:root\\cli>", lastIndex);
                    while (output.substring(commandBegin).startsWith("wmic:root\\cli>")) {
                        commandBegin += "wmic:root\\cli>".length();
                    }
                } else {
                    commandBegin += command.length();
                }
                int end = output.length();
                if (nextcommand != null && (end = output.indexOf(nextcommand, commandBegin)) == -1) {
                    end = output.indexOf("wmic:root\\cli>", commandBegin);
                    while (output.substring(end + "wmic:root\\cli>".length()).startsWith("wmic:root\\cli>")) {
                        end += "wmic:root\\cli>".length();
                    }
                }
                results[i] = output.substring(commandBegin, end).trim();
                lastIndex = commandBegin;
            }
            return results;
        }
    }

    @Override
    public void run() {
        try {
            int n = this.in.read();
            while (n != -1) {
                this.bout.write(n);
                n = this.in.read();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        WmicUtil util = new WmicUtil();
        util.sendCommand("service get DisplayName,Description,PathName,Started,StartMode", false);
        util.sendCommand("service get DisplayName,StartMode", false);
        util.sendCommand("service get DisplayName,Description,PathName,Started,StartMode", false);
        WmicRows rows = new WmicRows(util.getResultsArray()[0]);
        String[][] data = rows.getData();
        for (int i = 0; i < data.length; ++i) {
            System.out.println(i + ": " + Arrays.toString(data[i]));
        }
    }

    class Ignore
    extends Thread {
        InputStream in;

        public Ignore(InputStream in) {
            this.in = in;
            this.start();
        }

        @Override
        public void run() {
            try {
                byte[] buf = new byte[1024];
                int n = 0;
                while (n != -1) {
                    n = this.in.read(buf, 0, 1024);
                    if (n <= 0) continue;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

