/*
 * Decompiled with CFR 0.152.
 */
package utils.multiplex;

import java.io.BufferedOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import utils.progtools.BestCaseCompressor;
import utils.stream.OpenByteArrayOutputStream;
import utils.stream.StreamUtils;
import utils.switches.Switches;
import utils.sync.UnqueuedMutex;

public class MultiplexerOutputStream
implements utils.multiplex.MultiplexingOutput {
    OutputStream outstream;
    private Object lock = new Object();
    HashMap streams = new HashMap();
    HashMap locks = new HashMap();
    IOException ioexception;
    boolean compress = false;
    boolean sendUncompressed = false;
    private static final int MINCHUNK = 1024;
    double uncompressedB = 0.0;
    double compressedB = 0.0;

    public void resetStats() {
        this.uncompressedB = 0.0;
        this.compressedB = 0.0;
    }

    public int getCompressionPercent() {
        return (int)(100.0 / this.uncompressedB * this.compressedB);
    }

    public void compress(boolean b) {
        this.compress = b;
    }

    public void sendUncompressed(boolean b) {
        this.sendUncompressed = b;
    }

    private void checkIoException(String err) throws IOException {
        if (this.ioexception != null) {
            IOException tmp = new IOException(err);
            tmp.initCause(this.ioexception);
            throw tmp;
        }
    }

    public MultiplexerOutputStream(OutputStream out) {
        this.outstream = new BufferedOutputStream(out);
    }

    public MultiplexerOutputStream(OutputStream out, String name) {
        this.outstream = new BufferedOutputStream(out);
    }

    public MultiplexerOutputStream(OutputStream out, String name, ThreadGroup tg) {
        this.outstream = new BufferedOutputStream(out);
    }

    public void closeAll(IOException err) {
        this.ioexception = err;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UnqueuedMutex getLock(short n) {
        Integer N = new Integer(n);
        Object object = this.lock;
        synchronized (object) {
            UnqueuedMutex nlock = (UnqueuedMutex)this.locks.get(N);
            if (nlock == null) {
                nlock = new UnqueuedMutex();
                this.locks.put(N, nlock);
            }
            return nlock;
        }
    }

    public OutputStream getBufOutputStream(short n) {
        return new BufferedOutputStream(this.getOutputStream(n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutputStream getOutputStream(short n) {
        HashMap hashMap = this.streams;
        synchronized (hashMap) {
            Integer N = new Integer(n);
            OutputStream out = (OutputStream)this.streams.get(N);
            if (out == null) {
                out = new MultiplexingOutput(n);
                this.streams.put(N, out);
            }
            return out;
        }
    }

    @Override
    public void flushAll() throws IOException {
        Collection tmp = this.streams.values();
        Iterator it = tmp.iterator();
        while (it.hasNext()) {
            ((MultiplexingOutput)it.next()).flush();
        }
    }

    class MultiplexingOutput
    extends FilterOutputStream {
        short n;
        Object boutlock;
        OpenByteArrayOutputStream bout;

        public MultiplexingOutput(short n) {
            super(MultiplexerOutputStream.this.outstream);
            this.boutlock = new Object();
            this.bout = new OpenByteArrayOutputStream();
            this.n = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeChunk() throws IOException {
            Object object = MultiplexerOutputStream.this.lock;
            synchronized (object) {
                if (this.bout.size() > 0) {
                    StreamUtils.writeShort(MultiplexerOutputStream.this.outstream, this.n);
                    if (MultiplexerOutputStream.this.compress) {
                        byte[] tmp = MultiplexerOutputStream.this.sendUncompressed ? BestCaseCompressor.packageUncompressed(this.bout.getByteArray(), 0, this.bout.size()) : BestCaseCompressor.compress(this.bout.getByteArray(), 0, this.bout.size());
                        MultiplexerOutputStream.this.uncompressedB += (double)this.bout.size();
                        MultiplexerOutputStream.this.compressedB += (double)tmp.length;
                        StreamUtils.writeBytes(MultiplexerOutputStream.this.outstream, tmp);
                    } else {
                        MultiplexerOutputStream.this.uncompressedB += (double)this.bout.size();
                        MultiplexerOutputStream.this.compressedB += (double)this.bout.size();
                        StreamUtils.writeBytes(MultiplexerOutputStream.this.outstream, this.bout.getByteArray(), 0, this.bout.size());
                    }
                    this.bout.reset();
                }
            }
        }

        @Override
        public void flush() throws IOException {
            MultiplexerOutputStream.this.checkIoException("Error flushing output stream");
            this.writeChunk();
            MultiplexerOutputStream.this.outstream.flush();
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            MultiplexerOutputStream.this.checkIoException("Error writing to output stream");
            if (Switches.SH_XXXX_mxDumpOnWrite && len > 1024 && !MultiplexerOutputStream.this.compress) {
                Object object = MultiplexerOutputStream.this.lock;
                synchronized (object) {
                    if (this.bout.size() > 0) {
                        this.writeChunk();
                    }
                    StreamUtils.writeShort(MultiplexerOutputStream.this.outstream, this.n);
                    StreamUtils.writeBytes(MultiplexerOutputStream.this.outstream, b, off, len);
                }
            } else {
                this.bout.write(b, off, len);
                if (this.bout.size() > 1024) {
                    this.flush();
                }
            }
        }

        @Override
        public void write(int b) throws IOException {
            MultiplexerOutputStream.this.checkIoException("Error writing to output stream");
            this.bout.write(b);
            if (this.bout.size() > 1024) {
                this.flush();
            }
        }
    }
}

