/*
 * Decompiled with CFR 0.152.
 */
package utils.message;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import utils.message.Message;
import utils.message.MessageConstants;
import utils.message.MessageUtils;

public class MessageReader
extends Thread
implements MessageConstants {
    private boolean blocking = true;
    Object mutex = new Object();
    ArrayList messages = new ArrayList();
    byte[] buffer = new byte[4096];
    InputStream in;

    public MessageReader(InputStream in, ThreadGroup tg, String name) {
        super(tg, name);
        this.in = new BufferedInputStream(in);
    }

    public MessageReader(InputStream in) {
        this.in = new BufferedInputStream(in);
    }

    public MessageReader(InputStream in, boolean blocking, boolean autoBuffer) {
        this.in = !autoBuffer ? in : new BufferedInputStream(in);
        this.blocking = blocking;
        if (!blocking) {
            this.start();
        }
    }

    public Message read() throws IOException {
        if (this.blocking) {
            Message m = MessageUtils.readMessage(this.in);
            return m;
        }
        Object object = this.mutex;
        synchronized (object) {
            if (this.messages.size() == 0) {
                return null;
            }
            Object o = this.messages.get(0);
            try {
                Message m = (Message)this.messages.remove(0);
                return m;
            }
            catch (ClassCastException e) {
                IOException x = (IOException)o;
                throw x;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            while (true) {
                Message m = MessageUtils.readMessage(this.in);
                Object object = this.mutex;
                synchronized (object) {
                    this.messages.add(m);
                }
            }
        }
        catch (IOException e) {
            Object object = this.mutex;
            synchronized (object) {
                this.messages.add(e);
                return;
            }
        }
    }
}

