/*
 * Decompiled with CFR 0.152.
 */
package utils.encryption.aes;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import utils.encryption.aes.Rijndael;

public class RijndaelDecryptionStream
extends FilterInputStream {
    private int END_OF_STREAM = -1;
    private int MAX_BLOCK_SIZE = 4096;
    private byte[] buffer = new byte[4096];
    private int pointer = this.buffer.length;
    private Rijndael tf;
    private InputStream in;
    private boolean stream_closed = false;
    int sizpos = 0;
    byte[] sizb = new byte[4];
    int size = 0;
    int datapos = 0;
    byte[] datab = null;

    public RijndaelDecryptionStream(InputStream in, byte[] key) {
        super(in);
        this.in = in;
        this.tf = new Rijndael();
        this.tf.init(key);
    }

    public RijndaelDecryptionStream(InputStream in, String key) {
        super(in);
        this.in = in;
        this.tf = new Rijndael();
        this.tf.init(key);
    }

    @Override
    public void reset() {
    }

    @Override
    public void mark(int readlimit) {
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public long skip(long n) throws IOException {
        byte[] b = new byte[4096];
        return this.read(b);
    }

    @Override
    public int available() throws IOException {
        return this.buffer.length - this.pointer;
    }

    @Override
    public int read() throws IOException {
        while (this.available() == 0) {
            this.readBuffer();
            if (!this.stream_closed) continue;
            return this.END_OF_STREAM;
        }
        return this.buffer[this.pointer++] & 0xFF;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.available() == 0) {
            this.readBuffer();
        }
        if (this.available() == 0) {
            if (this.stream_closed) {
                return this.END_OF_STREAM;
            }
            return 0;
        }
        int max = Math.min(len, this.available());
        System.arraycopy(this.buffer, this.pointer, b, off, max);
        this.pointer += max;
        return max;
    }

    private void readBuffer() throws IOException {
        if (this.stream_closed) {
            return;
        }
        if (this.available() != 0) {
            return;
        }
        int n = 0;
        while (this.sizpos < this.sizb.length) {
            n = this.in.read(this.sizb, this.sizpos, this.sizb.length - this.sizpos);
            if (n == -1) {
                if (this.stream_closed) {
                    return;
                }
                this.stream_closed = true;
                continue;
            }
            if (n == 0) {
                return;
            }
            this.sizpos += n;
        }
        this.size = 0;
        for (int i = 0; i < 4; ++i) {
            this.size = (this.size << 8) + (this.sizb[i] & 0xFF);
        }
        this.datab = new byte[this.size];
        n = 0;
        while (this.datapos < this.datab.length) {
            n = this.in.read(this.datab, this.datapos, this.datab.length - this.datapos);
            if (n == -1) {
                if (this.stream_closed) {
                    return;
                }
                this.stream_closed = true;
                continue;
            }
            if (n == 0) {
                return;
            }
            this.datapos += n;
        }
        byte[] decoded = this.tf.decryptCTR(this.datab, 0);
        int dsiz = decoded.length;
        if (dsiz > this.buffer.length) {
            this.buffer = new byte[dsiz];
        }
        System.arraycopy(decoded, 0, this.buffer, this.buffer.length - dsiz, dsiz);
        this.pointer = this.buffer.length - dsiz;
        this.sizpos = 0;
        this.datapos = 0;
    }
}

