/*
 * Decompiled with CFR 0.152.
 */
package jwrapper.proxy;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jwrapper.jwutils.JWGenericOS;
import jwrapper.proxy.JWDetectedProxy;
import jwrapper.proxy.JWProxyAuthenticator;
import jwrapper.proxy.JWProxyCredentials;
import jwrapper.proxy.JWProxyList;
import jwrapper.proxy.NullProxySelector;
import jwrapper.ui.ProxyCredentialsDialog;
import utils.ostools.OS;
import utils.progtools.AutoFetchURL;
import utils.progtools.URIUtil;
import utils.stream.StreamUtils;

public class JWAsyncProxyDetector {
    private ArrayList<Proxy> listOfProxiesToTry = new ArrayList();
    private JWProxyCredentials proxyCredentials;
    private JWProxyAuthenticator authenticator;
    private final Object PROXY_LOCK = new Object();
    private URL targetURL;
    private int timeoutMS;
    private int threadCount = 0;

    public JWAsyncProxyDetector(URL targetURL, JWProxyList proxyList, JWProxyCredentials proxyCredentials, int timeoutMS) {
        System.setProperty("java.net.useSystemProxies", "true");
        this.targetURL = targetURL;
        this.timeoutMS = timeoutMS;
        JWDetectedProxy.DEFAULT_SELECTOR = ProxySelector.getDefault();
        this.authenticator = new JWProxyAuthenticator(proxyCredentials);
        this.listOfProxiesToTry.add(Proxy.NO_PROXY);
        Iterator<Proxy> it = proxyList.getProxyIterator();
        while (it.hasNext()) {
            this.listOfProxiesToTry.add(it.next());
        }
        try {
            URI uri;
            try {
                uri = targetURL.toURI();
            }
            catch (Throwable t) {
                uri = URIUtil.getSafeURIFrom(targetURL);
            }
            System.out.println("[JWAsyncProxyDetector] Trying system wide proxy selector...");
            List<Proxy> l = ProxySelector.getDefault().select(uri);
            if (l != null) {
                System.out.println("[JWAsyncProxyDetector] Got " + l.size() + " system proxies");
                for (Proxy proxy : l) {
                    if (proxy.address() == null) continue;
                    this.listOfProxiesToTry.add(proxy);
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean detectProxyAndBlock(String appName) {
        System.out.println("[JWAsyncProxyDetector] Trying " + this.listOfProxiesToTry.size() + " proxies...");
        ArrayList<ProxyDetectionThread> listOfDetectionThreads = new ArrayList<ProxyDetectionThread>();
        Object object = this.PROXY_LOCK;
        synchronized (object) {
            ProxyDetectionThread thread;
            ProxySelector.setDefault(JWDetectedProxy.DEFAULT_SELECTOR);
            for (Proxy proxy : this.listOfProxiesToTry) {
                thread = new ProxyDetectionThread(this.targetURL, proxy, false);
                new Thread(thread).start();
                listOfDetectionThreads.add(thread);
                ++this.threadCount;
            }
            try {
                this.PROXY_LOCK.wait(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!JWDetectedProxy.DETECTED_PROXY_OK) {
                ProxySelector.setDefault(NullProxySelector.INSTANCE);
                for (Proxy proxy : this.listOfProxiesToTry) {
                    thread = new ProxyDetectionThread(this.targetURL, proxy, true);
                    new Thread(thread).start();
                    listOfDetectionThreads.add(thread);
                    ++this.threadCount;
                }
            }
            while (this.threadCount > 0 && !JWDetectedProxy.DETECTED_PROXY_OK) {
                try {
                    this.PROXY_LOCK.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                System.out.println("[JWAsyncProxyDetector] " + this.threadCount + " remaining...");
            }
        }
        if (!JWDetectedProxy.DETECTED_PROXY_OK) {
            for (int i = listOfDetectionThreads.size() - 1; i >= 0; --i) {
                ProxyDetectionThread thread = (ProxyDetectionThread)listOfDetectionThreads.get(i);
                if (thread.requiresAuthentication) {
                    thread.printMessage("Authentication required");
                    continue;
                }
                listOfDetectionThreads.remove(i);
            }
            while (listOfDetectionThreads.size() > 0 && !JWDetectedProxy.DETECTED_PROXY_OK) {
                ProxyCredentialsDialog dialog = ProxyCredentialsDialog.showDialog(appName);
                String username = dialog.getUsername();
                String password = dialog.getPassword();
                this.authenticator.setInterceptCredentials(username, password);
                if (username == null) break;
                Object object2 = this.PROXY_LOCK;
                synchronized (object2) {
                    ProxySelector.setDefault(JWDetectedProxy.DEFAULT_SELECTOR);
                    for (int i = 0; i < listOfDetectionThreads.size(); ++i) {
                        ProxyDetectionThread thread = (ProxyDetectionThread)listOfDetectionThreads.get(i);
                        if (thread.overrideSelector && !NullProxySelector.isDefaultProxySelectorNull()) {
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            ProxySelector.setDefault(NullProxySelector.INSTANCE);
                        }
                        new Thread(thread).start();
                        ++this.threadCount;
                    }
                    while (this.threadCount > 0 && !JWDetectedProxy.DETECTED_PROXY_OK) {
                        try {
                            this.PROXY_LOCK.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        System.out.println("[JWAsyncProxyDetector] " + this.threadCount + " remaining...");
                    }
                }
            }
            this.authenticator.setInterceptCredentials(null, null);
            if (!JWDetectedProxy.DETECTED_PROXY_OK) {
                System.out.println("[JWAsyncProxyDetector] None of the detected proxies worked. Reverting authenticator.");
                this.authenticator.revertDefault();
                ProxySelector.setDefault(JWDetectedProxy.DEFAULT_SELECTOR);
                return false;
            }
        }
        for (ProxyDetectionThread thread : listOfDetectionThreads) {
            if (!thread.worked) continue;
            if (thread.overrideSelector) {
                ProxySelector.setDefault(NullProxySelector.INSTANCE);
            } else {
                ProxySelector.setDefault(JWDetectedProxy.DEFAULT_SELECTOR);
            }
            JWDetectedProxy.DETECTED_PROXY_OVERWRITE_SELECTOR = thread.overrideSelector;
            break;
        }
        return true;
    }

    public static boolean detectAndSetProxyFor(String appName, File appsSharedConfigFolder, URL url, int timeoutMS) {
        File wrapperProxy = new File(appsSharedConfigFolder, "DetectedProxy");
        File detectedProxies = new File(appsSharedConfigFolder, "DetectedProxies");
        File userProxies = new File(appsSharedConfigFolder, "AppProxies");
        File credentialsFile = new File(appsSharedConfigFolder, "ProxyCredentials");
        File lastProxy = new File(appsSharedConfigFolder, "LastProxy");
        try {
            if (!lastProxy.exists()) {
                lastProxy.createNewFile();
            }
        }
        catch (IOException ex) {
            System.out.println("[JWAsyncProxyDetector] Unable to create LastProxy file.");
            ex.printStackTrace();
        }
        JWProxyCredentials credentials = new JWProxyCredentials();
        try {
            credentials.loadFromFile(credentialsFile);
        }
        catch (IOException ex) {
            System.out.println("[JWAsyncProxyDetector] Unable to load existing credentials from file.");
            ex.printStackTrace();
        }
        JWProxyList proxyList = new JWProxyList(10);
        JWAsyncProxyDetector.processHintedProxy(wrapperProxy, proxyList, credentials);
        try {
            proxyList.loadFromFile(detectedProxies);
        }
        catch (IOException ex) {
            System.out.println("[JWAsyncProxyDetector] Unable to load proxy list from file.");
            ex.printStackTrace();
        }
        JWProxyList clonedList = (JWProxyList)proxyList.clone();
        try {
            proxyList.loadFromFile(userProxies);
        }
        catch (IOException ex) {
            System.out.println("[JWAsyncProxyDetector] Unable to load proxy list from file.");
        }
        url = URIUtil.tryGetSafeURLFrom(url);
        JWAsyncProxyDetector proxyDetector = new JWAsyncProxyDetector(url, proxyList, credentials, timeoutMS);
        boolean worked = proxyDetector.detectProxyAndBlock(appName);
        if (JWDetectedProxy.DETECTED_PROXY_OK) {
            System.out.println("[JWAsyncProxyDetector] Detected proxy succesfully");
            try {
                JWDetectedProxy.setDetectedProxyAsDefault();
            }
            catch (Throwable t) {
                System.out.println("[JWAsyncProxyDetector] Unable to set detected proxy as default");
                t.printStackTrace();
            }
            try {
                JWDetectedProxy.saveDetectedProxy();
            }
            catch (Throwable t) {
                System.out.println("[JWAsyncProxyDetector] Unable to save detected proxy to disk");
                t.printStackTrace();
            }
            try {
                if (JWDetectedProxy.DETECTED_PROXY != null) {
                    clonedList.addProxyToFront(JWDetectedProxy.DETECTED_PROXY);
                    System.out.println("[JWAsyncProxyDetector] Saving detected proxies...");
                    clonedList.saveToFile(detectedProxies);
                    System.out.println("[JWAsyncProxyDetector] Saving credentials...");
                    credentials.saveToFile(credentialsFile);
                    if (detectedProxies.exists()) {
                        JWGenericOS.setWritableForAllUsers(detectedProxies, false);
                    }
                    if (credentialsFile.exists()) {
                        JWGenericOS.setWritableForAllUsers(credentialsFile, false);
                    }
                }
            }
            catch (Throwable t) {
                System.out.println("[JWAsyncProxyDetector] Unable to save detected proxies and credentials");
                t.printStackTrace();
            }
        } else {
            System.out.println("[JWAsyncProxyDetector] No proxy detected");
        }
        return worked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processHintedProxy(File wrapperProxy, JWProxyList proxyList, JWProxyCredentials credentials) {
        block22: {
            try {
                if (!wrapperProxy.exists()) break block22;
                FileInputStream fin = new FileInputStream(wrapperProxy);
                try {
                    String hints = StreamUtils.readAllAsString(fin);
                    String[] data = hints.split("\\n");
                    String allProxyHosts = data[0].trim();
                    String protocol = "http";
                    String bypassList = null;
                    if (data.length > 1) {
                        bypassList = data[1].trim();
                    }
                    ArrayList<String> proxyHostsToParse = new ArrayList<String>();
                    if (OS.isWindows()) {
                        String[] proxies;
                        for (String individualProxy : proxies = allProxyHosts.split(";")) {
                            proxyHostsToParse.add(individualProxy.replace("=", "://"));
                        }
                    } else {
                        proxyHostsToParse.add(allProxyHosts);
                    }
                    for (String proxyHost : proxyHostsToParse) {
                        System.out.println("[JWAsyncProxyDetector] [Hinted] Parsing proxy " + proxyHost);
                        int doubleSlash = proxyHost.indexOf("://");
                        if (doubleSlash != -1) {
                            protocol = proxyHost.substring(0, doubleSlash);
                            proxyHost = proxyHost.substring(doubleSlash + 3);
                        }
                        if (proxyHost.endsWith("/")) {
                            proxyHost = proxyHost.substring(0, proxyHost.length() - 1);
                        }
                        int atIndex = proxyHost.indexOf(64);
                        String usernameBit = null;
                        String hostBit = proxyHost;
                        if (atIndex != -1) {
                            usernameBit = proxyHost.substring(0, atIndex);
                            hostBit = proxyHost.substring(atIndex + 1);
                        }
                        System.out.println("[JWAsyncProxyDetector] [Hinted] Protocol: " + protocol + " Host: " + hostBit + " User: " + usernameBit);
                        String username = null;
                        String password = null;
                        String hostname = null;
                        String port = null;
                        if (hostBit.indexOf(58) == -1) {
                            hostname = hostBit;
                            port = "80";
                        } else {
                            String[] hostBits = hostBit.split(":");
                            hostname = hostBits[0].trim();
                            port = hostBits[1].trim();
                        }
                        if (usernameBit != null && usernameBit.indexOf(58) != -1) {
                            String[] usernameBits = usernameBit.split(":");
                            username = usernameBits[0];
                            password = usernameBits[1];
                        }
                        int portInt = 80;
                        try {
                            portInt = Integer.parseInt(port);
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                        System.out.println("[JWAsyncProxyDetector] [Hinted] Hostname: " + hostname + " Port: " + portInt);
                        Proxy.Type proxyType = Proxy.Type.HTTP;
                        if (protocol != null) {
                            if (protocol.equalsIgnoreCase("socks")) {
                                proxyType = Proxy.Type.SOCKS;
                            } else {
                                if (!protocol.toLowerCase().startsWith("http")) continue;
                                proxyType = Proxy.Type.HTTP;
                            }
                        }
                        InetSocketAddress address = new InetSocketAddress(hostname, portInt);
                        Proxy proxy = new Proxy(proxyType, address);
                        proxyList.addProxyToFront(proxy);
                        if (username != null) {
                            JWProxyCredentials.Credentials c = new JWProxyCredentials.Credentials(username, password);
                            credentials.setCredentialsFor(proxy, c);
                        }
                        System.out.println("[JWAsyncProxyDetector] [Hinted] Added proxy " + proxy);
                    }
                }
                finally {
                    fin.close();
                }
            }
            catch (Throwable t) {
                System.out.println("[JWAsyncProxyDetector] [Hinted] Unable to process wrapper hinted proxy.");
                t.printStackTrace();
            }
        }
    }

    class ProxyDetectionThread
    implements Runnable,
    AutoFetchURL.URLConnectionInitialiser {
        private Proxy proxy;
        private URL targetURL;
        private boolean requiresAuthentication = false;
        private boolean overrideSelector;
        private boolean worked = false;
        private URLConnection resultingConnection = null;

        public ProxyDetectionThread(URL targetURL, Proxy proxy, boolean overrideSelector) {
            this.proxy = proxy;
            this.targetURL = targetURL;
            this.overrideSelector = overrideSelector;
        }

        public void printMessage(String message) {
            if (this.proxy != null) {
                System.out.println("[JWAsyncProxyDetector][" + this.proxy + "][" + this.overrideSelector + "] " + message);
            } else {
                System.out.println("[JWAsyncProxyDetector][Default][" + this.overrideSelector + "] " + message);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.printMessage("Attempting connection...");
            try {
                InputStream inputStream = this.proxy == null ? AutoFetchURL.getInputStreamAndHandleTLSDowngrade(this.targetURL, this) : AutoFetchURL.getInputStreamAndHandleTLSDowngrade(this.targetURL, this, this.proxy);
                if (inputStream == null) {
                    throw new Exception("Unable to get input stream");
                }
                inputStream.close();
                this.printMessage("The proxy openConnection seems to have worked.");
                Object object = JWAsyncProxyDetector.this.PROXY_LOCK;
                synchronized (object) {
                    if (!JWDetectedProxy.DETECTED_PROXY_OK) {
                        this.printMessage("Setting this as the detected proxy.");
                        if (this.proxy != null) {
                            JWAsyncProxyDetector.this.authenticator.saveInterceptCredentials(this.proxy);
                        }
                        JWDetectedProxy.DETECTED_PROXY_OK = true;
                        JWDetectedProxy.DETECTED_PROXY = this.proxy;
                        this.worked = true;
                    }
                }
            }
            catch (Throwable t) {
                if (t.getMessage().indexOf("407") != -1) {
                    this.requiresAuthentication = true;
                }
                this.printMessage("Failed: " + t.getClass().getName() + ": " + t.getMessage());
            }
            finally {
                try {
                    if (this.resultingConnection != null && this.resultingConnection instanceof HttpURLConnection) {
                        ((HttpURLConnection)this.resultingConnection).disconnect();
                    }
                }
                catch (Throwable inputStream) {}
            }
            Object object = JWAsyncProxyDetector.this.PROXY_LOCK;
            synchronized (object) {
                JWAsyncProxyDetector.this.threadCount--;
                JWAsyncProxyDetector.this.PROXY_LOCK.notify();
                this.printMessage("Attempt finishing (" + JWAsyncProxyDetector.this.threadCount + ")");
            }
        }

        @Override
        public boolean initialiseURLConnection(URLConnection urlConnection) {
            this.resultingConnection = urlConnection;
            urlConnection.setConnectTimeout(JWAsyncProxyDetector.this.timeoutMS);
            urlConnection.setReadTimeout(5000);
            return true;
        }
    }
}

