/*
 * Decompiled with CFR 0.152.
 */
package jwrapper.os.linux.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import utils.files.FileUtil;

public class DesktopShortcutUtil {
    public static final int TYPE_APPLICATION = 1;
    public static final int TYPE_LINK = 2;
    public static final int TYPE_DIRECTORY = 3;
    public final String GLOBAL_TARGET_DIRECTORY = "/usr/share/applications";
    public String LOCAL_TARGET_DIRECTORY;
    public String DESKTOP_SHORTCUT_DIRECTORY;
    private ArrayList unityShortcuts = new ArrayList();
    private ArrayList actions = new ArrayList();
    String type;
    String name;
    String exec;
    String version = "1.0";
    String encoding = "UTF-8";
    String genericName;
    String noDisplay = null;
    String comment = null;
    String hidden = null;
    String icon = null;
    String path = null;
    String terminal = null;
    String mimeType = null;
    String categories = null;
    String URL = null;

    public DesktopShortcutUtil(int type, String name, String exec) {
        this.LOCAL_TARGET_DIRECTORY = System.getProperty("user.home") + "/.local/share/applications";
        this.DESKTOP_SHORTCUT_DIRECTORY = System.getProperty("user.home") + "/Desktop";
        switch (type) {
            case 1: {
                this.type = "Application";
                break;
            }
            case 2: {
                this.type = "Link";
                break;
            }
            case 3: {
                this.type = "Directory";
                break;
            }
            default: {
                this.type = "Application";
            }
        }
        this.name = name;
        this.exec = exec;
    }

    public void addUnitySpecificRightClickOptions(String shortNameID, String displayName, String customisedExec) {
        UnityShortcut shortcut = new UnityShortcut();
        shortcut.shortNameID = shortNameID;
        shortcut.displayName = displayName;
        shortcut.customisedExec = customisedExec;
        this.unityShortcuts.add(shortcut);
    }

    public void addAction(String actionID, String actionName, String actionIcon, String actionExec) {
        Action action = new Action();
        action.actionID = actionID;
        action.name = actionName;
        action.icon = actionIcon;
        action.exec = actionExec;
        this.actions.add(action);
    }

    private File getFile(String parent, String filename) {
        String extension = ".desktop";
        if (this.type != null && this.type.equals("Directory")) {
            extension = ".directory";
        }
        if (!filename.endsWith(extension)) {
            filename = filename + extension;
        }
        return new File(parent, filename);
    }

    public void deleteForAllUsers(String desiredFileName) throws IOException {
        File targetFile = this.getFile("/usr/share/applications", desiredFileName);
        FileUtil.deleteDir(targetFile);
    }

    public void deleteForThisUser(String desiredFileName) throws IOException {
        File targetFile = this.getFile(this.LOCAL_TARGET_DIRECTORY, desiredFileName);
        FileUtil.deleteDir(targetFile);
    }

    public void writeForAllUsers(String desiredFileName) throws IOException {
        File targetFile = this.getFile("/usr/share/applications", desiredFileName);
        new File("/usr/share/applications").mkdirs();
        this.writeShortcut(targetFile);
    }

    public void writeForThisUser(String desiredFileName) throws IOException {
        File targetFile = this.getFile(this.LOCAL_TARGET_DIRECTORY, desiredFileName);
        new File(this.LOCAL_TARGET_DIRECTORY).mkdirs();
        this.writeShortcut(targetFile);
    }

    public void writeDesktopShortcutForThisUser(String desiredFileName) throws IOException {
        File targetFile = this.getFile(this.DESKTOP_SHORTCUT_DIRECTORY, desiredFileName);
        new File(this.DESKTOP_SHORTCUT_DIRECTORY).mkdirs();
        this.writeShortcut(targetFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeShortcut(File target) throws IOException {
        String groupID;
        Object action;
        int i;
        StringBuffer buffer = new StringBuffer();
        buffer.append("[Desktop Entry]").append("\n");
        this.addNameValuePair(buffer, "Version", this.version);
        this.addNameValuePair(buffer, "Type", this.type);
        this.addNameValuePair(buffer, "Name", this.name);
        this.addNameValuePair(buffer, "Exec", this.exec);
        this.addNameValuePair(buffer, "Encoding", this.encoding);
        this.addNameValuePair(buffer, "GenericName", this.genericName);
        this.addNameValuePair(buffer, "Comment", this.comment);
        this.addNameValuePair(buffer, "Hidden", this.hidden);
        this.addNameValuePair(buffer, "Icon", this.icon);
        this.addNameValuePair(buffer, "Path", this.path);
        this.addNameValuePair(buffer, "Terminal", this.terminal);
        this.addNameValuePair(buffer, "MimeType", this.mimeType);
        this.addNameValuePair(buffer, "Categories", this.categories);
        this.addNameValuePair(buffer, "NoDisplay", this.noDisplay);
        this.addNameValuePair(buffer, "URL", this.URL);
        StringBuffer actionIds = new StringBuffer();
        for (i = 0; i < this.actions.size(); ++i) {
            actionIds.append(((Action)this.actions.get((int)i)).actionID).append(";");
        }
        if (this.actions.size() > 0) {
            this.addNameValuePair(buffer, "Actions", actionIds.toString());
        }
        actionIds = new StringBuffer();
        for (i = 0; i < this.unityShortcuts.size(); ++i) {
            actionIds.append(((UnityShortcut)this.unityShortcuts.get((int)i)).shortNameID).append(";");
        }
        if (this.unityShortcuts.size() > 0) {
            this.addNameValuePair(buffer, "X-Ayatana-Desktop-Shortcuts", actionIds.toString());
        }
        for (i = 0; i < this.actions.size(); ++i) {
            action = (Action)this.actions.get(i);
            groupID = ((Action)action).getActionIdentifierGroup();
            if (groupID == null) continue;
            buffer.append("\n");
            buffer.append("[").append(groupID).append("]").append("\n");
            this.addNameValuePair(buffer, "Name", ((Action)action).name);
            this.addNameValuePair(buffer, "Icon", ((Action)action).icon);
            this.addNameValuePair(buffer, "Exec", ((Action)action).exec);
        }
        for (i = 0; i < this.unityShortcuts.size(); ++i) {
            action = (UnityShortcut)this.unityShortcuts.get(i);
            groupID = ((UnityShortcut)action).getShortcutGroup();
            if (groupID == null) continue;
            buffer.append("\n");
            buffer.append("[").append(groupID).append("]").append("\n");
            this.addNameValuePair(buffer, "Name", ((UnityShortcut)action).displayName);
            this.addNameValuePair(buffer, "Exec", ((UnityShortcut)action).customisedExec);
            this.addNameValuePair(buffer, "TargetEnvironment", "Unity");
        }
        byte[] utf8Result = null;
        try {
            utf8Result = buffer.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException action2) {
            // empty catch block
        }
        if (utf8Result == null) {
            try {
                utf8Result = buffer.toString().getBytes("UTF8");
            }
            catch (UnsupportedEncodingException action2) {
                // empty catch block
            }
        }
        FileOutputStream fout = new FileOutputStream(target);
        try {
            fout.write(utf8Result);
        }
        finally {
            fout.close();
        }
    }

    private void addNameValuePair(StringBuffer buffer, String key, String value) {
        if (key != null && value != null) {
            buffer.append(key).append("=").append(value).append("\n");
        }
    }

    public void setURL(String url) {
        this.URL = url;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setGenericName(String genericName) {
        this.genericName = genericName;
    }

    public void setNoDisplay(boolean noDisplay) {
        this.noDisplay = Boolean.toString(noDisplay);
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setHidden(boolean hidden) {
        this.hidden = Boolean.toString(hidden);
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setTerminal(boolean terminal) {
        this.terminal = Boolean.toString(terminal);
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public void setCategories(String categories) {
        this.categories = categories;
    }

    public static void main(String[] args) throws IOException {
        DesktopShortcutUtil util = new DesktopShortcutUtil(1, "Test Application", "runapp 123");
        util.addAction("action1", "action 1", null, "run action 1");
        util.addAction("action2", "action 2", null, "run action 2");
        util.addUnitySpecificRightClickOptions("uaction1", "uaction 1", "run uaction1");
        util.addUnitySpecificRightClickOptions("uaction2", "uaction 2", "run uaction2");
        util.writeDesktopShortcutForThisUser("file1");
    }

    class Action {
        String actionID;
        String name;
        String exec;
        String icon;

        Action() {
        }

        public String getActionIdentifierGroup() {
            if (this.actionID != null) {
                return "Desktop Action " + this.actionID;
            }
            return null;
        }
    }

    class UnityShortcut {
        String shortNameID;
        String displayName;
        String customisedExec;

        UnityShortcut() {
        }

        public String getShortcutGroup() {
            if (this.shortNameID != null) {
                return this.shortNameID + " Shortcut Group";
            }
            return null;
        }
    }
}

