/*
 * Decompiled with CFR 0.152.
 */
package jwrapper.jwutils.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import jwrapper.jwutils.swing.JWAutomatable;
import utils.files.FileUtil;
import utils.progtools.Cache;
import utils.swing.borders.SimpleShadowBorder;

public class JWAutomate {
    private static boolean isBlank(int[] data) {
        if (data.length == 0) {
            return true;
        }
        int initial = data[0];
        for (int z = 0; z < data.length; ++z) {
            if (data[z] == initial) continue;
            return false;
        }
        return true;
    }

    private static String hash(byte[] dat) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(dat);
            dat = md.digest();
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < dat.length; ++i) {
                sb.append(Integer.toString((dat[i] & 0xFF) + 256, 16).substring(1));
            }
            return sb.toString();
        }
        catch (Exception x) {
            return null;
        }
    }

    private static CellRendererPane getCellRendererPane(Container parent) {
        CellRendererPane shell = new CellRendererPane();
        parent.add(shell);
        return shell;
    }

    public static void dumpScreenshots(Component[] parent, File html, boolean visibleOnly, Class[] ignoreList) throws FileNotFoundException, IOException {
        int i;
        Cache<String, String> done = new Cache<String, String>("JWAutomate", 30000);
        ArrayList<JComponent> all = new ArrayList<JComponent>();
        if (visibleOnly) {
            for (i = 0; i < parent.length; ++i) {
                all.addAll(JWAutomate.findAll(parent[i], JComponent.class));
            }
        } else {
            for (i = 0; i < parent.length; ++i) {
                all.addAll(JWAutomate.findEverything(parent[i]));
            }
        }
        File imgs = new File(html.getParentFile(), html.getName() + "_images");
        PrintStream pout = new PrintStream(new FileOutputStream(html));
        pout.println("<html>");
        pout.println("<body style='font-family:sans-serif'>");
        pout.println("<h2>JWAutomate Component Screenshots " + new Date() + "</h2>");
        System.out.println("Capturing PNGs for " + all.size() + " components");
        pout.println("<table border='0' cellpadding='6' cellspacing='7' width='100%'>");
        for (int i2 = 0; i2 < all.size(); ++i2) {
            BufferedImage bimg;
            JComponent component = (JComponent)all.get(i2);
            boolean ignore = false;
            if (ignoreList != null) {
                for (Class c : ignoreList) {
                    if (c != component.getClass()) continue;
                    ignore = true;
                    break;
                }
                if (ignore) continue;
            }
            if ((bimg = JWAutomate.capture((Component)all.get(i2), false)) == null) continue;
            int W = bimg.getWidth();
            if (W > 1000) {
                W = 1000;
            }
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            try {
                ImageIO.write((RenderedImage)bimg, "PNG", bout);
            }
            catch (Exception x) {
                x.printStackTrace();
            }
            byte[] png = bout.toByteArray();
            bout = null;
            String hash = JWAutomate.hash(png);
            if (done.containsKey(hash)) continue;
            done.addToCache(hash, hash);
            File image = new File(imgs, "image" + i2 + ".png");
            FileUtil.writeFile(image.getAbsolutePath(), png);
            pout.println("<tr><td align='center' style='background:#E0E0EE'>");
            pout.println("<img width='" + W + "' border='0' src='" + imgs.getName() + File.separator + image.getName() + "'>");
            pout.println("</td></tr>");
        }
        pout.println("</table>");
        pout.println("</body>");
        pout.println("</html>");
        pout.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void layoutComponent(Component c) {
        Object object = c.getTreeLock();
        synchronized (object) {
            c.doLayout();
            if (c instanceof Container) {
                for (Component child : ((Container)c).getComponents()) {
                    JWAutomate.layoutComponent(child);
                }
            }
        }
    }

    public static BufferedImage capture(Component comp, boolean shadow) {
        try {
            if (comp.getWidth() == 0 || comp.getHeight() == 0) {
                return null;
            }
            System.out.println("Capturing " + comp + " " + comp.getWidth() + " x " + comp.getHeight());
            int extra = 4;
            if (!shadow) {
                extra = 0;
            }
            try {
                if (!comp.isVisible()) {
                    comp.setVisible(true);
                    comp.setSize(comp.getPreferredSize());
                    JWAutomate.layoutComponent(comp);
                }
                BufferedImage bimg = new BufferedImage(comp.getWidth() + extra, comp.getHeight() + extra, 2);
                Graphics g = bimg.getGraphics();
                if (shadow) {
                    Graphics create = g.create(1, 1, comp.getWidth(), comp.getHeight());
                    comp.paintAll(create);
                    create.dispose();
                    int[] data = bimg.getRGB(1, 1, comp.getWidth(), comp.getHeight(), null, 0, comp.getWidth());
                    if (JWAutomate.isBlank(data)) {
                        g.dispose();
                        return null;
                    }
                    SimpleShadowBorder ssb = new SimpleShadowBorder(false);
                    ssb.paintBorder(null, g, 0, 0, comp.getWidth() + 1, comp.getHeight() + 1);
                } else {
                    comp.paint(g);
                    int[] data = bimg.getRGB(0, 0, comp.getWidth(), comp.getHeight(), null, 0, comp.getWidth());
                    if (JWAutomate.isBlank(data)) {
                        return null;
                    }
                }
                g.dispose();
                return bimg;
            }
            catch (Exception x) {
                x.printStackTrace();
                return null;
            }
        }
        catch (OutOfMemoryError xx) {
            return null;
        }
    }

    public static JComponent findFirst(Component parent, Class type) {
        return JWAutomate.findFirst(parent, null, type);
    }

    public static ArrayList<JComponent> findAll(Component parent, Class type) {
        return JWAutomate.findAll(parent, null, type);
    }

    public static JComponent findFirst(Component parent, String text, Class type) {
        ArrayList<JComponent> comps = new ArrayList<JComponent>();
        JWAutomate.findAll(parent, text, null, type, comps);
        if (comps.size() == 0) {
            return null;
        }
        return comps.get(0);
    }

    public static JComponent findFirstTT(Component parent, String text, Class type) {
        ArrayList<JComponent> comps = new ArrayList<JComponent>();
        JWAutomate.findAll(parent, null, text, type, comps);
        return comps.get(0);
    }

    public static ArrayList<JComponent> findAll(Component parent, String text, Class type) {
        ArrayList<JComponent> comps = new ArrayList<JComponent>();
        JWAutomate.findAll(parent, text, null, type, comps);
        return comps;
    }

    public static ArrayList<JComponent> findAllTT(Component parent, String text, Class type) {
        ArrayList<JComponent> comps = new ArrayList<JComponent>();
        JWAutomate.findAll(parent, null, text, type, comps);
        return comps;
    }

    public static void deselectJTable(Component parent) {
        JTable table = (JTable)JWAutomate.findFirst(parent, null, JTable.class);
        int[] rows = table.getSelectedRows();
        Arrays.sort(rows);
        table.removeRowSelectionInterval(rows[0], rows[rows.length - 1]);
    }

    public static void hitJTable(Component parent) {
        JTable table = (JTable)JWAutomate.findFirst(parent, null, JTable.class);
        table.setRowSelectionInterval(0, 0);
    }

    public static int getJTableSize(Component parent) {
        JTable table = (JTable)JWAutomate.findFirst(parent, null, JTable.class);
        return table.getRowCount();
    }

    public static void nextJTable(Component parent) {
        JTable table = (JTable)JWAutomate.findFirst(parent, null, JTable.class);
        int N = table.getSelectedRow();
        try {
            table.setRowSelectionInterval(N + 1, N + 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean scrollDownPage(Component parent) {
        JScrollPane pane = (JScrollPane)JWAutomate.findFirst(parent, null, JScrollPane.class);
        JScrollBar bar = pane.getVerticalScrollBar();
        int v = bar.getVisibleAmount();
        int limit = bar.getMaximum() - bar.getVisibleAmount();
        if (bar.getValue() < limit) {
            bar.setValue(Math.min(limit, bar.getValue() + v));
            return true;
        }
        return false;
    }

    public static boolean scrollUpPage(Component parent) {
        JScrollPane pane = (JScrollPane)JWAutomate.findFirst(parent, null, JScrollPane.class);
        JScrollBar bar = pane.getVerticalScrollBar();
        int v = bar.getVisibleAmount();
        int limit = 0;
        if (bar.getValue() > limit) {
            bar.setValue(Math.max(limit, bar.getValue() - v));
            return true;
        }
        return false;
    }

    public static void hitButton(Component parent, String text) {
        JWAutomate.doThreadedClick((AbstractButton)JWAutomate.findFirst(parent, text, AbstractButton.class));
    }

    public static void hitButtonTT(Component parent, String text) {
        JWAutomate.doThreadedClick((AbstractButton)JWAutomate.findFirstTT(parent, text, AbstractButton.class));
    }

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void sleepMins(double mins) {
        try {
            Thread.sleep((long)(mins * 60000.0));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Component hitTab(Component parent, String text) {
        JTabbedPane pane = (JTabbedPane)JWAutomate.findFirst(parent, null, JTabbedPane.class);
        int tabs = pane.getTabCount();
        for (int i = 0; i < tabs; ++i) {
            String tabtext = pane.getTitleAt(i);
            Icon tabicon = pane.getIconAt(i);
            if (tabtext.toLowerCase().indexOf(text.toLowerCase()) == -1) continue;
            pane.setSelectedIndex(i);
            return pane.getSelectedComponent();
        }
        throw new Error("Couldn't find tab in first JTabbedPane :(");
    }

    public static void hitMenu(Component parent, String text) {
        text = text.toLowerCase();
        JMenu pane = (JMenu)JWAutomate.findFirst(parent, null, JMenu.class);
        if (pane != null) {
            Component[] menus = pane.getMenuComponents();
            for (int i = 0; i < menus.length; ++i) {
                if (!(menus[i] instanceof JMenuItem)) continue;
                JMenuItem item = (JMenuItem)menus[i];
                String s = "";
                try {
                    s = JWAutomate.getTextOf((JComponent)menus[i]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!s.toLowerCase().contains(text)) continue;
                JWAutomate.doThreadedClick(item);
                return;
            }
        } else {
            JPopupMenu popup = null;
            Window[] wins1 = Window.getWindows();
            Window[] wins2 = Window.getOwnerlessWindows();
            Window[] wins = new Window[wins1.length + wins2.length];
            System.arraycopy(wins1, 0, wins, 0, wins1.length);
            System.arraycopy(wins2, 0, wins, wins1.length, wins2.length);
            for (int i = 0; i < wins.length; ++i) {
                System.out.println("[JWAutomate] Window " + i + " of " + wins.length + ": " + wins[i]);
                Component[] comps = wins[i].getComponents();
                for (int z = 0; z < comps.length; ++z) {
                    System.out.println("[JWAutomate] Win Component " + z + " of " + comps.length + ": " + comps[z]);
                    popup = (JPopupMenu)JWAutomate.findFirst(comps[z], null, JPopupMenu.class);
                    if (popup != null) break;
                }
                if (popup != null) break;
            }
            if (popup == null && (popup = (JPopupMenu)JWAutomate.findFirst(parent, null, JPopupMenu.class)) == null) {
                popup = JWAutomate.getFirstVisiblePopupMenu(parent);
            }
            if (popup != null) {
                AbstractButton button = (AbstractButton)JWAutomate.findFirst(popup, text, AbstractButton.class);
                JWAutomate.doThreadedClick(button);
                return;
            }
        }
        throw new Error("Couldn't find JMenuItem in first JMenu :(");
    }

    public static void hitList(Component parent) {
        JList pane = (JList)JWAutomate.findFirst(parent, null, JList.class);
        ListModel model = pane.getModel();
        int size = model.getSize();
        if (size > 0) {
            pane.setSelectedIndex(0);
        }
    }

    public static int getListSize(Component parent) {
        JList pane = (JList)JWAutomate.findFirst(parent, null, JList.class);
        ListModel model = pane.getModel();
        int size = model.getSize();
        return size;
    }

    public static void nextList(Component parent) {
        JList pane = (JList)JWAutomate.findFirst(parent, null, JList.class);
        ListModel model = pane.getModel();
        int size = model.getSize();
        pane.setSelectedIndex(pane.getSelectedIndex() + 1);
    }

    public static void hitList(Component parent, String text) {
        text = text.toLowerCase();
        JList pane = (JList)JWAutomate.findFirst(parent, null, JList.class);
        ListModel model = pane.getModel();
        int size = model.getSize();
        for (int i = 0; i < size; ++i) {
            String item = model.getElementAt(i) + "";
            if (!item.toLowerCase().contains(text)) continue;
            pane.setSelectedIndex(i);
            return;
        }
        throw new Error("Couldn't find matching item in first JList :(");
    }

    private static JPopupMenu getFirstVisiblePopupMenu(Component c) {
        if (c instanceof JPopupMenu) {
            JPopupMenu menu = (JPopupMenu)c;
            if (menu.isVisible()) {
                return menu;
            }
            return null;
        }
        JPopupMenu menu = null;
        if (c instanceof JFrame) {
            JFrame jf = (JFrame)c;
            menu = JWAutomate.getFirstVisiblePopupMenu(jf.getRootPane());
            if (menu == null) {
                JWAutomate.getFirstVisiblePopupMenu(jf.getGlassPane());
            }
        } else if (c instanceof Container) {
            Container cc = (Container)c;
            Component[] comps = cc.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                if (menu != null) continue;
                menu = JWAutomate.getFirstVisiblePopupMenu(comps[i]);
            }
        }
        return menu;
    }

    private static void doThreadedClick(AbstractButton button) {
        SwingUtilities.invokeLater(new ButtonClick(button));
    }

    private static String getTextFor(JComponent jc, Class clazz) {
        Method[] methods = clazz.getDeclaredMethods();
        try {
            for (int i = 0; i < methods.length; ++i) {
                Method m = methods[i];
                if (m.getName().equals("getText") && m.getParameterTypes().length == 0) {
                    return "" + m.invoke((Object)jc, new Object[0]);
                }
                if (!m.getName().equals("getLabel") || m.getParameterTypes().length != 0) continue;
                return "" + m.invoke((Object)jc, new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    private static String getTextOf(JComponent jc) {
        for (Class<?> clazz = jc.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            String s = JWAutomate.getTextFor(jc, clazz);
            if (s.length() <= 0) continue;
            return s;
        }
        return "";
    }

    private static void clickComponent(JComponent target) throws Exception {
        System.out.println("Clicking " + target);
        Rectangle r = target.getBounds();
        Point p = new Point((int)r.getCenterX(), (int)r.getCenterY());
        MouseEvent press = new MouseEvent(target, 501, System.currentTimeMillis(), 16, p.x, p.y, 1, false);
        MouseEvent release = new MouseEvent(target, 502, System.currentTimeMillis(), 16, p.x, p.y, 1, false);
        MouseEvent clicked = new MouseEvent(target, 500, System.currentTimeMillis(), 16, p.x, p.y, 1, false);
        MouseListener[] mls = target.getMouseListeners();
        System.out.println(mls.length + " mouse listeners");
        for (int i = 0; i < mls.length; ++i) {
            target.dispatchEvent(press);
            target.dispatchEvent(release);
            target.dispatchEvent(clicked);
            Method m = Component.class.getDeclaredMethod("processMouseEvent", MouseEvent.class);
            m.setAccessible(true);
            m.invoke((Object)target, press);
            m.invoke((Object)target, release);
            m.invoke((Object)target, clicked);
            mls[i].mousePressed(press);
            mls[i].mouseReleased(release);
            mls[i].mouseClicked(clicked);
        }
    }

    private static void click(Component parent, String text) {
        JComponent jc = JWAutomate.findFirst(parent, text, null);
        if (jc instanceof AbstractButton) {
            JWAutomate.doThreadedClick((AbstractButton)jc);
        } else {
            System.out.println("[JWAutomation] Not sure how to click a " + jc.getClass().getName());
        }
    }

    private static void dumpAll(Component c, String s) {
        System.out.println(s + c);
        if (c instanceof JFrame) {
            JFrame jf = (JFrame)c;
            JWAutomate.dumpAll(jf.getRootPane(), s + "--");
            JWAutomate.dumpAll(jf.getGlassPane(), s + "--");
        } else if (c instanceof Container) {
            Container cc = (Container)c;
            Component[] comps = cc.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                JWAutomate.dumpAll(comps[i], s + "--");
            }
        }
    }

    public static ArrayList<JComponent> findEverything(Component c) {
        ArrayList<JComponent> list = new ArrayList<JComponent>();
        JWAutomate.findEverything(c, list);
        return list;
    }

    public static void findEverything(Component c, ArrayList<JComponent> list) {
        block11: {
            block10: {
                if (c == null) {
                    return;
                }
                if (c instanceof JComponent) {
                    list.add((JComponent)c);
                }
                if (c instanceof JTabbedPane) {
                    JTabbedPane tabs = (JTabbedPane)c;
                    for (int i = 0; i < tabs.getTabCount(); ++i) {
                        System.out.println("Searching " + tabs.getComponentAt(i));
                        JWAutomate.findEverything(tabs.getComponentAt(i), list);
                    }
                }
                if (!(c instanceof JFrame)) break block10;
                JFrame jf = (JFrame)c;
                JWAutomate.findEverything(jf.getRootPane(), list);
                JWAutomate.findEverything(jf.getGlassPane(), list);
                break block11;
            }
            if (!(c instanceof Container)) break block11;
            Container cc = (Container)c;
            boolean recurse = true;
            JWAutomatable automatable = null;
            if (cc instanceof JWAutomatable) {
                automatable = (JWAutomatable)((Object)cc);
                recurse = automatable.grabScreenShotsOfChildren();
            }
            if (recurse) {
                if (automatable != null) {
                    Component[] children;
                    for (Component child : children = automatable.getChildComponents()) {
                        JWAutomate.findEverything(child, list);
                    }
                } else {
                    Component[] comps = cc.getComponents();
                    for (int i = 0; i < comps.length; ++i) {
                        JWAutomate.findEverything(comps[i], list);
                    }
                }
            }
        }
    }

    private static void findAll(Component parent, String text, String tooltip, Class type, ArrayList<JComponent> comps) {
        JComponent jc;
        if (parent instanceof JFrame) {
            JWAutomate.findAll(((JFrame)parent).getRootPane(), text, tooltip, type, comps);
            JWAutomate.findAll(((JFrame)parent).getGlassPane(), text, tooltip, type, comps);
            return;
        }
        if (text != null) {
            text = text.toLowerCase();
        }
        if (tooltip != null) {
            tooltip = tooltip.toLowerCase();
        }
        Class<?> clazz = parent.getClass();
        if ((type == null || type.isAssignableFrom(clazz)) && parent instanceof JComponent && !((jc = (JComponent)parent) instanceof JLabel) && jc.isVisible()) {
            String jctext;
            if (text != null) {
                jctext = JWAutomate.getTextOf(jc);
                if (jctext.toLowerCase().indexOf(text) != -1) {
                    System.out.println("[JWAutomation] Found " + jc);
                    if (!comps.contains(jc)) {
                        comps.add(jc);
                    }
                }
            } else if (tooltip != null) {
                jctext = jc.getToolTipText();
                if (jctext != null && jctext.toLowerCase().indexOf(tooltip) != -1) {
                    System.out.println("[JWAutomation] Found " + jc);
                    if (!comps.contains(jc)) {
                        comps.add(jc);
                    }
                }
            } else {
                System.out.println("[JWAutomation] Found " + jc);
                if (!comps.contains(jc)) {
                    comps.add(jc);
                }
            }
        }
        Cache<Component, Component> seen = new Cache<Component, Component>("JWAutomation", 500);
        int width = parent.getWidth();
        int height = parent.getHeight();
        int GRAN = 10;
        boolean recurse = true;
        JWAutomatable automatable = null;
        if (parent instanceof JWAutomatable) {
            automatable = (JWAutomatable)((Object)parent);
            recurse = automatable.grabScreenShotsOfChildren();
        }
        if (recurse) {
            for (int y = 0; y < height; y += GRAN) {
                for (int x = 0; x < width; x += GRAN) {
                    Component sub = ((JComponent)parent).findComponentAt(x, y);
                    if (sub == parent || !(sub instanceof JComponent) || seen.containsKey(sub)) continue;
                    seen.addToCache(sub, sub);
                    JWAutomate.findAll(sub, text, tooltip, type, comps);
                }
            }
            if (automatable != null) {
                Component[] children;
                for (Component child : children = automatable.getChildComponents()) {
                    if (seen.containsKey(child)) continue;
                    seen.addToCache(child, child);
                    JWAutomate.findAll(child, text, tooltip, type, comps);
                }
            }
        }
    }

    private static class ButtonClick
    extends Thread {
        AbstractButton button;

        public ButtonClick(AbstractButton button) {
            this.button = button;
        }

        @Override
        public void run() {
            if (!this.button.isEnabled()) {
                new Exception("Target button is not enabled!").printStackTrace();
            } else {
                this.button.doClick();
            }
        }
    }
}

