/*
 * Decompiled with CFR 0.152.
 */
package jwrapper.jwutils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import jwrapper.jwutils.JWGenericOS;
import jwrapper.jwutils.JWMacOS;
import jwrapper.os.linux.util.DesktopShortcutUtil;
import utils.files.FileUtil;
import utils.ostools.OS;
import utils.ostools.RunCommandGetOutput;
import utils.progtools.Cache;
import utils.stream.StreamUtils;

public class JWLinuxOS
extends JWGenericOS {
    public static final String SHORTCUT_CATEGORY_AUDIOVIDEO = "AudioVideo";
    public static final String SHORTCUT_CATEGORY_DEVELOPMENT = "Development";
    public static final String SHORTCUT_CATEGORY_EDUCATION = "Education";
    public static final String SHORTCUT_CATEGORY_GAME = "Game";
    public static final String SHORTCUT_CATEGORY_GRAPHICS = "Graphics";
    public static final String SHORTCUT_CATEGORY_NETWORK = "Network";
    public static final String SHORTCUT_CATEGORY_OFFICE = "Office";
    public static final String SHORTCUT_CATEGORY_SCIENCE = "Science";
    public static final String SHORTCUT_CATEGORY_SETTINGS = "Settings";
    public static final String SHORTCUT_CATEGORY_SYSTEM = "System";
    public static final String SHORTCUT_CATEGORY_UTILITY = "Utility";
    static Cache cmdCache = new Cache("JWLinuxOS", 100);
    private String productName;

    public static JWLinuxOS getLinuxInstance() {
        return JWGenericOS.linInstance;
    }

    public static String getJvmUserAccount() {
        return RunCommandGetOutput.runCommandGetOutput("whoami")[0];
    }

    public static boolean haveSudoPermissions() {
        try {
            File sudoers = new File("/etc/sudoers");
            if (!sudoers.exists()) {
                return false;
            }
            FileInputStream fin = new FileInputStream(sudoers);
            fin.close();
            return true;
        }
        catch (Exception x) {
            return false;
        }
    }

    public static void deleteApplicationStartShortcut(String linkFilename, boolean allUsers) throws IOException {
        DesktopShortcutUtil util = new DesktopShortcutUtil(1, "ignore", null);
        if (allUsers) {
            util.deleteForAllUsers(linkFilename);
        } else {
            util.deleteForThisUser(linkFilename);
        }
    }

    public static void createApplicationStartShortcut(String linkFilename, String name, String targetCommand, boolean allUsers, File icon) throws IOException {
        DesktopShortcutUtil util = new DesktopShortcutUtil(1, name, targetCommand);
        if (icon != null) {
            util.setIcon(icon.getAbsolutePath());
        }
        if (allUsers) {
            util.writeForAllUsers(linkFilename);
        } else {
            util.writeForThisUser(linkFilename);
        }
    }

    public static void createApplicationStartShortcut(String linkFilename, String name, String targetCommand, boolean allUsers) throws IOException {
        JWLinuxOS.createApplicationStartShortcut(linkFilename, name, targetCommand, allUsers, null);
    }

    public static void createApplicationDesktopShortcut(String name, String targetCommand) throws IOException {
        JWLinuxOS.createApplicationDesktopShortcut(name, targetCommand, null);
    }

    public static void createApplicationDesktopShortcut(String name, String targetCommand, File icon) throws IOException {
        DesktopShortcutUtil util = new DesktopShortcutUtil(1, name, targetCommand);
        if (icon != null) {
            util.setIcon(icon.getAbsolutePath());
        }
        util.writeDesktopShortcutForThisUser(name);
    }

    public static void deleteWebpageStartShortcut(String linkFilename, boolean allUsers) throws IOException {
        DesktopShortcutUtil util = new DesktopShortcutUtil(2, "ignore", null);
        if (allUsers) {
            util.deleteForAllUsers(linkFilename);
        } else {
            util.deleteForThisUser(linkFilename);
        }
    }

    public static void createWebpageStartShortcut(String linkFilename, String name, String url, boolean allUsers) throws IOException {
        JWLinuxOS.createWebpageStartShortcut(linkFilename, name, url, allUsers);
    }

    public static void createWebpageStartShortcut(String linkFilename, String name, String url, boolean allUsers, File icon) throws IOException {
        DesktopShortcutUtil util = new DesktopShortcutUtil(2, name, null);
        util.setURL(url);
        if (icon != null) {
            util.setIcon(icon.getAbsolutePath());
        }
        if (allUsers) {
            util.writeForAllUsers(linkFilename);
        } else {
            util.writeForThisUser(linkFilename);
        }
    }

    public static void createWebpageDesktopShortcut(String name, String url, File icon) throws IOException {
        DesktopShortcutUtil util = new DesktopShortcutUtil(2, name, null);
        if (icon != null) {
            util.setIcon(icon.getAbsolutePath());
        }
        util.setURL(url);
        util.writeDesktopShortcutForThisUser(name);
    }

    public static void createWebpageDesktopShortcut(String name, String url) throws IOException {
        JWLinuxOS.createWebpageDesktopShortcut(name, url, null);
    }

    @Override
    public String getHostname() {
        String[] output = RunCommandGetOutput.runCommandGetOutput(new String[]{"hostname"});
        if (output == null || output[0] == null || output[0].trim().length() == 0) {
            return super.getHostname();
        }
        return output[0].trim();
    }

    public static boolean isCommandAvailable(String command) {
        try {
            Boolean available = (Boolean)cmdCache.getFromCache(command);
            if (available == null) {
                Process p = Runtime.getRuntime().exec("which " + command);
                available = new Boolean(p.waitFor() == 0);
                cmdCache.addToCache(command, available);
            }
            return available;
        }
        catch (IOException x) {
            System.out.println("[JWLinuxOS] Unable to check for command " + command + " (" + x + ") will return false");
            return false;
        }
        catch (InterruptedException x) {
            System.out.println("[JWLinuxOS] Unable to check for command " + command + " (" + x + ") will return false");
            return false;
        }
    }

    public static boolean isGkSudoAvailable() {
        return JWLinuxOS.isCommandAvailable("gksudo");
    }

    public static boolean isKdeSudoAvailable() {
        return JWLinuxOS.isCommandAvailable("kdesudo");
    }

    public static boolean isBeeSuAvailable() {
        return JWLinuxOS.isCommandAvailable("beesu");
    }

    public static boolean isGnomeSuAvailable() {
        return JWLinuxOS.isCommandAvailable("gnomesu");
    }

    public static int getGnomeSUElevationFailedReturnCode() {
        return 1;
    }

    public static int getGkSudoElevationFailedReturnCode() {
        return 1;
    }

    public static int getBeesuElevationFailedReturnCode() {
        return 1;
    }

    public static int getGkSudoElevationCancelledReturnCode() {
        return 255;
    }

    public static boolean isPkExecAvailable() {
        return JWLinuxOS.isCommandAvailable("pkexec");
    }

    public static int getPkExecElevationFailedReturnCode() {
        return 127;
    }

    public static int getPkExecElevationCancelledReturnCode() {
        return 126;
    }

    @Override
    public String[] getAllConsoleUsers() {
        ArrayList<String> result = new ArrayList<String>();
        String output = RunCommandGetOutput.runCommandGetOutput(new String[]{"who"})[0];
        if (output != null) {
            String[] lines;
            output = output.trim();
            for (String line : lines = output.split("\n")) {
                String[] values = line.split("\\s+");
                if (values.length < 2) continue;
                String username = values[0];
                String terminal = values[1];
                if (terminal.startsWith(":")) {
                    if (result.contains(username)) continue;
                    result.add(username);
                    continue;
                }
                String lastValue = values[values.length - 1];
                if (!lastValue.startsWith("(:") || result.contains(username)) continue;
                result.add(username);
            }
        }
        return result.toArray(new String[0]);
    }

    public boolean killProcess(int pid) {
        String command = "kill -9 " + pid;
        try {
            Process proc = Runtime.getRuntime().exec(command);
            new JWMacOS.IgnoreInputStream(proc.getInputStream());
            String error = StreamUtils.readAllAsString(proc.getErrorStream());
            int code = 0;
            try {
                code = proc.waitFor();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return code == 0;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    private static String stripQuotes(String s) {
        if (s == null) {
            return null;
        }
        if (s.startsWith("\"")) {
            s = s.substring(1);
        }
        if (s.endsWith("\"")) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    @Override
    public String getOSProductName() {
        String data;
        File target;
        int colon;
        String stdout;
        RunCommandGetOutput.CommandResponse commandResponse;
        if (this.productName == null && (commandResponse = RunCommandGetOutput.runCommand(new String[]{"/bin/sh", "lsb_release", "-d"})) != null && (stdout = commandResponse.stdout) != null && (colon = stdout.indexOf(58)) != -1) {
            this.productName = stdout.substring(colon + 1).trim();
        }
        if (this.productName == null && (target = new File("/etc/os-release")).exists()) {
            try {
                data = FileUtil.readFileAsStringUTF8(target);
                String[] lines = data.split("\n");
                String name = null;
                String version = null;
                for (String line : lines) {
                    if (line.startsWith("NAME=")) {
                        name = JWLinuxOS.stripQuotes(line.substring(line.indexOf(61) + 1));
                        continue;
                    }
                    if (line.startsWith("VERSION=")) {
                        version = JWLinuxOS.stripQuotes(line.substring(line.indexOf(61) + 1));
                        continue;
                    }
                    if (!line.startsWith("PRETTY_NAME=")) continue;
                    this.productName = JWLinuxOS.stripQuotes(line.substring(line.indexOf(61) + 1));
                }
                if (this.productName == null && name != null) {
                    this.productName = name;
                    if (version != null) {
                        this.productName = this.productName + " " + version;
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.productName == null && (target = new File("/etc/lsb-release")).exists()) {
            try {
                String[] lines;
                data = FileUtil.readFileAsStringUTF8(target);
                for (String line : lines = data.split("\n")) {
                    if (!line.startsWith("DISTRIB_DESCRIPTION=")) continue;
                    this.productName = JWLinuxOS.stripQuotes(line.substring(line.indexOf(61) + 1));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.productName;
    }

    @Override
    public boolean is64Bit() {
        return OS.isLinux64bit();
    }
}

