/*
 * Decompiled with CFR 0.152.
 */
package jwrapper.jwutils;

public class JWConstantClock
extends Thread {
    private static Object LOCK = new Object();
    private static JWConstantClock INSTANCE;
    private static long unchangingT;
    private static long driftingT;
    private static long drift;
    private static long FREQ;
    private static long FREQdiv2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startup() {
        if (INSTANCE == null) {
            Object object = LOCK;
            synchronized (object) {
                INSTANCE = new JWConstantClock();
                INSTANCE.start();
            }
        }
    }

    private JWConstantClock() {
        super("JWConstantClock");
        this.setDaemon(true);
    }

    public static long currentTimeMillis() {
        JWConstantClock.startup();
        return JWConstantClock.checkAndUpdateTime(FREQdiv2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long checkAndUpdateTime(long assumedWait) {
        Object object = LOCK;
        synchronized (object) {
            long T = System.currentTimeMillis();
            if (T - driftingT > 10000L || T < driftingT) {
                System.out.println("*******************************************");
                System.out.println("* System Clock Changed - " + (T - driftingT) + "ms");
                System.out.println("*");
                System.out.println("* WARNING: It appears that your server is losing time. ");
                System.out.println("* Time loss > 10000ms will cause session instability and dropped connections.");
                System.out.println("*******************************************");
                drift = T - (unchangingT += assumedWait);
                driftingT = T;
            } else {
                driftingT = T;
                unchangingT = driftingT - drift;
            }
            return T - drift;
        }
    }

    @Override
    public void run() {
        while (true) {
            try {
                Thread.sleep(FREQ);
            }
            catch (Exception exception) {
                // empty catch block
            }
            JWConstantClock.checkAndUpdateTime(FREQ);
        }
    }

    static {
        unchangingT = System.currentTimeMillis();
        driftingT = System.currentTimeMillis();
        drift = 0L;
        FREQ = 100L;
        FREQdiv2 = FREQ / 2L;
    }
}

