/*
 * Decompiled with CFR 0.152.
 */
package jwrapper.allplatformwrapper;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.Proxy;
import java.net.URL;
import java.util.Properties;
import jwrapper.JRECopy;
import jwrapper.allplatformwrapper.APWrapperListener;
import jwrapper.jwutils.JWGenericOS;
import jwrapper.jwutils.JWWindowsOS;
import jwrapper.logging.LogPoller;
import jwrapper.logging.StdLogging;
import jwrapper.proxy.JWDetectedProxy;
import jwrapper.proxy.JWProxyAuthenticator;
import jwrapper.proxy.JWProxyCredentials;
import jwrapper.proxy.JWProxyList;
import jwrapper.updater.GenericUpdater;
import jwrapper.updater.JWApp;
import jwrapper.updater.LaunchFile;
import jwrapper.updater.OSXBundleUtil;
import jwrapper.updater.Unarchiver;
import jwrapper.updater.VersionUtil;
import utils.files.AtomicFileOutputStream;
import utils.files.FileUtil;
import utils.ostools.OS;
import utils.ostools.RunCommandGetOutput;
import utils.ostools.SaveDir;
import utils.ostools.SlowWEnv;
import utils.progtools.URIUtil;
import utils.stream.CFriendlyStreamUtils;
import utils.stream.StreamUtils;

public class AllPlatformWrapper {
    public static final String INSTALLTYPE_TEMP_USER = "temp_user";
    public static final String INSTALLTYPE_CUR_USER = "perm_user";
    public static final String INSTALLTYPE_ALL_USER = "perm_all";
    public static boolean APW_REDIRECT_TO_LOG = false;
    private APWrapperListener listener;
    private File master;
    private String gu_version;
    private String updateURL;
    private Properties guargs;
    private boolean haveTailInClasspath = false;
    private String javaVersionRequired = "9999.9";
    private final boolean skipSystemJRE;
    GenericUpdater.UpdaterInfo updaterInfo;
    String dynpropJreName = null;

    public static File getStandardMasterFolder(String appName, boolean perm_all) {
        File master;
        if (perm_all) {
            File parent;
            if (OS.isWindows()) {
                if (OS.isWindowsVistaOrAbove()) {
                    try {
                        JWWindowsOS win = new JWWindowsOS();
                        parent = new File(win.getEnvironmentVariable("PROGRAMDATA"));
                    }
                    catch (Throwable x) {
                        System.out.println("[AllPlatformWrapper] had to use WEnv to get environment variables.");
                        parent = new File(SlowWEnv.getEnv("PROGRAMDATA"));
                    }
                } else {
                    String allUsers;
                    try {
                        JWWindowsOS win = new JWWindowsOS();
                        allUsers = win.getEnvironmentVariable("ALLUSERSPROFILE");
                    }
                    catch (Throwable x) {
                        System.out.println("[AllPlatformWrapper] had to use WEnv to get environment variables.");
                        allUsers = SlowWEnv.getEnv("ALLUSERSPROFILE");
                    }
                    parent = new File(new File(allUsers), "Application Data");
                }
            } else {
                parent = OS.isMacOS() ? new File("/Library/Application Support/") : new File("/opt");
            }
            master = new File(parent, "JWrapper-" + appName);
        } else {
            master = new File(SaveDir.getUserSpecificSaveDirWithSlash("JWrapper-" + appName, new SaveDir.WindowPathResolver(){

                @Override
                public String getShortNameFor(String fullPath) {
                    System.out.println("[AllPlatformWrapper] Requesting short name for " + fullPath);
                    JWWindowsOS winOS = new JWWindowsOS();
                    return winOS.getShortPathFormatFor(fullPath);
                }

                @Override
                public String getEnv(String env, boolean getShortPath) {
                    try {
                        JWWindowsOS winOS = new JWWindowsOS();
                        if (getShortPath) {
                            return winOS.getEnvShortPath(env);
                        }
                        return winOS.getEnvironmentVariable(env);
                    }
                    catch (UnsatisfiedLinkError t) {
                        System.out.println("[AllPlatformWrapper] had to use WEnv to get environment variables.");
                        return SlowWEnv.getEnv(env);
                    }
                }
            }));
        }
        return master;
    }

    public static AllPlatformWrapper createApwFromWrapperProperties(String staticUpdateURL, Properties lprops, boolean haveTailInClasspath) {
        String updateURL;
        if (staticUpdateURL.equals("D")) {
            updateURL = lprops.getProperty("update_url");
            System.out.println("[OSXWrapper] Dynamic update URL is " + updateURL);
        } else {
            updateURL = staticUpdateURL;
            System.out.println("[OSXWrapper] Dynamic update URL ignored, Static update URL is " + updateURL);
        }
        String appName = lprops.getProperty("app_name");
        String installType = lprops.getProperty("install_type");
        boolean canOverrideSplash = false;
        try {
            canOverrideSplash = lprops.getProperty("can_override_splash").equalsIgnoreCase("true");
            if (canOverrideSplash) {
                System.out.println("[AllPlatformWrapper] Can override splash");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean matchVersions = false;
        try {
            matchVersions = lprops.getProperty("match_versions").equalsIgnoreCase("true");
            if (matchVersions) {
                System.out.println("[AllPlatformWrapper] Matching client version to update server version");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        String reqJavaVersion = "9999.9";
        try {
            reqJavaVersion = lprops.getProperty("java_version");
            System.out.println("[OSXWrapper] Required Java version is " + reqJavaVersion);
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean skipSystemJRE = false;
        try {
            String prop = lprops.getProperty("skip_system_jre");
            if (prop != null && prop.length() > 0 && prop.equals("1")) {
                skipSystemJRE = true;
            }
            if (skipSystemJRE) {
                System.out.println("[OSXWrapper] Skipping System JRE");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new AllPlatformWrapper(appName, updateURL, installType, canOverrideSplash, null, matchVersions, lprops, haveTailInClasspath, reqJavaVersion, skipSystemJRE);
    }

    public AllPlatformWrapper(String appName, String updateURL, String installType, boolean canOverrideSplash, String dynamicAppletSplash, boolean matchVersions, Properties lprops, boolean haveTailInClasspath, String requiredJavaVersion, boolean skipSystemJRE) {
        String splash;
        this.haveTailInClasspath = haveTailInClasspath;
        this.javaVersionRequired = requiredJavaVersion;
        this.skipSystemJRE = skipSystemJRE;
        if (updateURL.endsWith("/")) {
            updateURL = updateURL.substring(0, updateURL.length() - 1);
        }
        this.master = AllPlatformWrapper.getStandardMasterFolder(appName, installType.equals(INSTALLTYPE_ALL_USER));
        this.updaterInfo = new GenericUpdater.UpdaterInfo();
        this.updaterInfo.master = this.master;
        this.updaterInfo.base = updateURL;
        this.updaterInfo.allUsersInstall = installType.equals(INSTALLTYPE_ALL_USER);
        this.updaterInfo.jreAppName = this.getTargetJREName(this.master);
        if (APW_REDIRECT_TO_LOG) {
            StdLogging.startLogging(this.master, "AllPlatformWrapper");
        }
        this.guargs = new Properties();
        this.guargs.setProperty("update_url", updateURL);
        this.guargs.setProperty("app_name", appName);
        if (lprops.getProperty("show_no_ui") != null) {
            this.guargs.setProperty("show_no_ui", lprops.getProperty("show_no_ui"));
        }
        this.setDynamicPropertyJreName(lprops.getProperty("jre_name"));
        this.guargs.setProperty("jre_name", this.getTargetJREName(this.master));
        if (canOverrideSplash) {
            this.guargs.setProperty("can_override_splash", "1");
        } else {
            this.guargs.setProperty("can_override_splash", "0");
        }
        if (dynamicAppletSplash != null && dynamicAppletSplash.length() > 0) {
            this.guargs.setProperty("splash_image", dynamicAppletSplash);
        }
        if ((splash = this.guargs.getProperty("min_splash_ms")) == null) {
            this.guargs.setProperty("min_splash_ms", "700");
        } else if (splash.trim().length() == 0) {
            this.guargs.setProperty("min_splash_ms", "700");
        }
        this.guargs.setProperty("match_versions", "" + matchVersions);
        this.guargs.setProperty("install_type", installType);
        this.guargs.setProperty("java_version", requiredJavaVersion);
        if (skipSystemJRE) {
            this.guargs.setProperty("skip_system_jre", "1");
        } else {
            this.guargs.setProperty("skip_system_jre", "");
        }
        if (lprops != null) {
            Object[] keys = lprops.keySet().toArray();
            for (int i = 0; i < keys.length; ++i) {
                String key = (String)keys[i];
                String value = lprops.getProperty(key);
                this.guargs.setProperty(key, value);
            }
        }
        this.updateURL = updateURL;
    }

    public LogPoller getLogPoller() {
        return new LogPoller(this.master);
    }

    public void setAPWrapperListener(APWrapperListener listener) {
        this.listener = listener;
    }

    public boolean canLaunchWithoutInstall() throws IOException {
        System.out.println("[AllPlatformWrapper] Checking if able to launch without install");
        if (this.master.exists()) {
            System.out.println("[AllPlatformWrapper] Master folder exists");
            File latest = LaunchFile.getLatestVersionOf("JWrapper", this.master);
            if (latest != null) {
                System.out.println("[AllPlatformWrapper] GU exists");
                String jreName = this.getTargetJREName(this.master);
                if (OS.isMacOS() && !jreName.equals(GenericUpdater.JRE_MAC64_APP)) {
                    System.out.println("[AllPlatformWrapper] Not checking for JRE (on MacOS-32)");
                } else {
                    File jreFile = null;
                    if (jreName.length() > 2) {
                        jreFile = LaunchFile.getLatestVersionOf(jreName, this.master);
                        if (jreFile == null) {
                            System.out.println("[AllPlatformWrapper] JRE does not exist (so no)");
                            return false;
                        }
                        System.out.println("[AllPlatformWrapper] JRE exists");
                    }
                }
                return true;
            }
            System.out.println("[AllPlatformWrapper] GU does not exist (so no)");
            return false;
        }
        System.out.println("[AllPlatformWrapper] Master does not exist (so no)");
        return false;
    }

    public boolean prepareForLaunch() throws IOException {
        try {
            File jreFile;
            String authorPubkey = null;
            try {
                InputStream in = this.getClass().getResourceAsStream(GenericUpdater.AUTHOR_PUBKEY_FILE);
                if (in == null) {
                    in = this.getClass().getResourceAsStream("/" + GenericUpdater.AUTHOR_PUBKEY_FILE);
                }
                authorPubkey = StreamUtils.readAllAsString(in);
            }
            catch (Exception in) {
                // empty catch block
            }
            byte[] cacerts = null;
            try {
                InputStream in = this.getClass().getResourceAsStream("cacerts");
                if (in == null) {
                    in = this.getClass().getResourceAsStream("/cacerts");
                }
                if (in != null) {
                    cacerts = StreamUtils.readAllAndClose(in);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            if (cacerts != null && cacerts.length > 0) {
                System.out.println("[AllPlatformWrapper] CACerts override found (" + cacerts.length + ").");
            }
            if (authorPubkey == null) {
                System.out.println("[AllPlatformWrapper] No author pubkey found, will not check archive signatures");
            } else {
                System.out.println("[AllPlatformWrapper] Author pubkey found, will check archive signatures (" + authorPubkey + ")");
            }
            String jreName = this.getTargetJREName(this.master);
            if (this.carryingNewerGU()) {
                System.out.println("[AllPlatformWrapper] We are carrying a newer GU version so will update before launching");
            } else if (this.carryingNewerApp()) {
                System.out.println("[AllPlatformWrapper] We are carrying a newer App version so will update before launching");
            } else if (this.master.exists()) {
                System.out.println("[AllPlatformWrapper] Master folder exists");
                File latest = LaunchFile.getLatestVersionOf("JWrapper", this.master);
                if (latest != null) {
                    File jreFile2;
                    if (OS.isMacOS() && !jreName.equals(GenericUpdater.JRE_MAC64_APP)) {
                        System.out.println("[AllPlatformWrapper] Not copying the jre on Mac-32");
                    } else if (jreName.length() > 2 && (jreFile2 = LaunchFile.getLatestVersionOf(jreName, this.master)) == null) {
                        System.out.println("[AllPlatformWrapper] Master folder exists but no JRE, will copy");
                        this.copyJRE(jreName, authorPubkey, cacerts);
                    }
                    if (this.listener != null) {
                        this.listener.canLaunch();
                    }
                    return true;
                }
                System.out.println("[AllPlatformWrapper] No versions of JWrapper found in " + this.master);
            } else {
                System.out.println("[AllPlatformWrapper] No master folder " + this.master + " found, must update before launching");
            }
            System.out.println("[AllPlatformWrapper] Will download or extract GU and set up");
            if (!this.haveTailInClasspath) {
                this.gu_version = this.downloadAsStringUTF8(this.updateURL, GenericUpdater.getVersionFileNameFor("JWrapper"));
                System.out.println("[AllPlatformWrapper] Got Generic Updater version " + this.gu_version);
            }
            System.out.println("[AllPlatformWrapper] Mkdirs " + this.master + " is " + this.master.mkdirs());
            if (OS.isMacOS() && !jreName.equals(GenericUpdater.JRE_MAC64_APP)) {
                System.out.println("[AllPlatformWrapper] Not copying the jre on Mac-32");
            } else if (jreName.length() > 2 && (jreFile = LaunchFile.getLatestVersionOf(jreName, this.master)) == null) {
                System.out.println("[AllPlatformWrapper] Master folder exists but no JRE, will copy");
                this.copyJRE(jreName, authorPubkey, cacerts);
            }
            this.updateGU(authorPubkey, cacerts);
            if (this.listener != null) {
                this.listener.canLaunch();
            }
            return true;
        }
        catch (InterruptedException xx) {
            throw new IOException("Interrupted I/O");
        }
    }

    public void launchNow() throws Exception {
        this.launchNow(new String[0]);
    }

    public void launchNow(String[] cmdlineArgs) throws Exception {
        System.out.println("[AllPlatformWrapper] Launching App");
        String jreName = this.getTargetJREName(this.master);
        System.out.println("[AllPlatformWrapper] JRE name is " + jreName);
        File jreFile = null;
        if (jreName.length() > 2) {
            jreFile = LaunchFile.getLatestVersionOf(jreName, this.master);
        }
        System.out.println("[AllPlatformWrapper] Using JRE " + jreFile);
        File latest = LaunchFile.getLatestVersionOf("JWrapper", this.master);
        LaunchFile.runVirtualAppFromNoExit(latest, this.guargs, jreFile, this.updateURL, cmdlineArgs, "JWrapper", false);
    }

    private void setDynamicPropertyJreName(String name) {
        if (name != null && name.length() > 0) {
            this.dynpropJreName = name;
        }
    }

    private String getTargetJREName(File master) {
        String jreName;
        File jwapps = JWApp.getJWAppsFolder(master);
        File jreoverride = new File(jwapps, GenericUpdater.getJreNameOverrideFileName());
        try {
            AtomicFileOutputStream.prepareForReading(jreoverride);
            if (jreoverride.exists()) {
                InputStream in = FileUtil.ropen(jreoverride);
                String jreName2 = CFriendlyStreamUtils.readString(in);
                in.close();
                System.out.println("[AllPlatformWrapper] JRE override name is " + jreName2);
                return jreName2;
            }
        }
        catch (IOException in) {
            // empty catch block
        }
        if (this.dynpropJreName != null) {
            jreName = this.dynpropJreName;
            System.out.println("[AllPlatformWrapper] No JRE override name, will return dynprop specified name " + jreName);
        } else {
            jreName = this.bestGuessJREName();
            System.out.println("[AllPlatformWrapper] No JRE override name and no dynprop JRE name, will return best guess " + jreName);
        }
        return jreName;
    }

    private String bestGuessJREName() {
        if (OS.isWindows()) {
            try {
                JWWindowsOS win = new JWWindowsOS();
                if (win.is64BitWindowsOS()) {
                    return GenericUpdater.JRE_WIN64_APP;
                }
                return GenericUpdater.JRE_WIN32_APP;
            }
            catch (Throwable t) {
                System.out.println("[AllPlatformWrapper] Unable to natively detect Windows OS bitness, assuming 32");
                return GenericUpdater.JRE_WIN32_APP;
            }
        }
        if (OS.isLinux()) {
            if (OS.isLinux64bit()) {
                return GenericUpdater.JRE_LIN64_APP;
            }
            return GenericUpdater.JRE_LIN32_APP;
        }
        if (OS.isMacOS()) {
            if (OS.isMacOS64bit()) {
                return GenericUpdater.JRE_MAC64_APP;
            }
            return "-";
        }
        return "-";
    }

    private void copyJRE(String jreAppName, String authorPubkey, byte[] cacerts) throws IOException, InterruptedException {
        try {
            if (this.skipSystemJRE) {
                System.out.println("[AllPlatformWrapper] Skipping copy of System JRE");
                throw new NoJREException();
            }
            System.out.println("[AllPlatformWrapper] Copying JRE");
            String myjvmver = System.getProperty("java.version");
            int index = myjvmver.indexOf(46);
            index = myjvmver.indexOf(46, index + 1);
            myjvmver = myjvmver.substring(0, index);
            try {
                int dot = this.javaVersionRequired.indexOf(".");
                if (dot != -1) {
                    String pre = this.javaVersionRequired.substring(0, dot);
                    String post = this.javaVersionRequired.substring(dot + 1);
                    if (pre.equals("1")) {
                        dot = post.indexOf(".");
                        if (dot != -1) {
                            post = post.substring(0, dot);
                        }
                        System.out.println("[AllPlatformsWrapper] Filtered req java version from " + this.javaVersionRequired + " to " + post);
                        this.javaVersionRequired = post;
                    } else {
                        System.out.println("[AllPlatformsWrapper] Filtered req java version from " + this.javaVersionRequired + " to " + pre);
                        this.javaVersionRequired = pre;
                    }
                }
            }
            catch (Exception dot) {
                // empty catch block
            }
            double myver = Double.parseDouble(myjvmver);
            double reqver = Double.parseDouble("1." + this.javaVersionRequired);
            System.out.println("[AllPlatformWrapper] My JVM version is " + myver + " vs required " + reqver);
            if (reqver <= myver) {
                File targetCACerts;
                System.out.println("[AllPlatformWrapper] AUTOTEST_JRE_COPY");
                String jhome = System.getProperty("java.home");
                File src = new File(jhome);
                System.out.println("[AllPlatformWrapper] My JRE home is " + src);
                String jreName = this.getTargetJREName(this.master);
                File temp = this.createTempJreFolder();
                if (OS.isMacOS()) {
                    File srcBundle;
                    File targetBundle = new File(this.master, GenericUpdater.getAppFolderNameFor(jreName, VersionUtil.padVersion(0)) + ".plugin");
                    File targetJRE = new File(this.master, GenericUpdater.getAppFolderNameFor(jreName, VersionUtil.padVersion(0)));
                    targetCACerts = new File(targetJRE.getPath() + "/lib/security/cacerts");
                    if (src.getAbsolutePath().contains("/Home")) {
                        System.out.println("[AllPlatformWrapper] JRE src isn't under ../Home - JRE references runtime in a Java bundle");
                        src = FileUtil.getAncestorFolderByName(src, "Home");
                        srcBundle = src.getParentFile().getParentFile();
                    } else {
                        System.out.println("[AllPlatformWrapper] JRE src is under ../Home - JRE references bundle");
                        src = new File(src.getParentFile(), src.getName() + ".plugin");
                        if (!src.exists()) {
                            throw new NoJREException();
                        }
                        srcBundle = src;
                    }
                    System.out.println("[AllPlatformWrapper] Source bundle path is " + srcBundle.getAbsolutePath());
                    RunCommandGetOutput.runCommandGetOutput(new String[]{"cp", "-LRf", srcBundle.getAbsolutePath(), temp.getAbsolutePath()});
                    RunCommandGetOutput.runCommandGetOutput(new String[]{"chmod", "-R", "755", temp.getAbsolutePath()});
                    System.out.println("[AllPlatformWrapper] Renaming JRE to " + targetBundle);
                    FileUtil.deleteDir(targetBundle);
                    FileUtil.deleteDir(targetJRE);
                    targetJRE.mkdir();
                    long giveUp = System.currentTimeMillis() + 4000L;
                    while (!temp.renameTo(targetBundle)) {
                        Thread.sleep(200L);
                        if (System.currentTimeMillis() <= giveUp) continue;
                        throw new IOException("Could not rename JRE folder to proper name");
                    }
                    OSXBundleUtil.setupOrRepairOSXJreBundle(targetBundle, targetJRE);
                } else {
                    System.out.println("[AllPlatformWrapper] Setting up JRE in " + temp);
                    JRECopy.copyJRE(src, temp);
                    File target = new File(this.master, GenericUpdater.getAppFolderNameFor(jreName, VersionUtil.padVersion(0)));
                    targetCACerts = new File(target.getPath() + File.separator + "lib" + File.separator + "security" + File.separator + "cacerts");
                    System.out.println("[AllPlatformWrapper] Renaming JRE to " + target + " (next failure to delete target is OK, we delete it just in case)");
                    FileUtil.deleteDir(target);
                    long giveUp = System.currentTimeMillis() + 4000L;
                    while (!temp.renameTo(target)) {
                        Thread.sleep(200L);
                        if (System.currentTimeMillis() <= giveUp) continue;
                        throw new IOException("Could not rename JRE folder to proper name");
                    }
                }
                if (cacerts != null && cacerts.length > 0) {
                    System.out.println("[AllPlatformWrapper] Overwriting cacerts now (" + targetCACerts + ").");
                    FileUtil.writeFile(targetCACerts, cacerts);
                    System.out.println("[AllPlatformWrapper] Result is a cacerts of size " + targetCACerts.length());
                }
                return;
            }
            throw new NoJREException();
        }
        catch (NoJREException e) {
            this.updateJREdownload(jreAppName, authorPubkey, cacerts);
            return;
        }
    }

    private File createTempJreFolder() {
        File temp = new File(this.master, "JWrapperTemp-" + System.currentTimeMillis() + "-" + this.master.list().length + "-jre");
        return temp;
    }

    private File createTempGuFolder() {
        File temp = new File(this.master, "JWrapperTemp-" + System.currentTimeMillis() + "-" + this.master.list().length + "-gu");
        return temp;
    }

    private File createTempAppFolder() {
        File temp = new File(this.master, "JWrapperTemp-" + System.currentTimeMillis() + "-" + this.master.list().length + "-app");
        return temp;
    }

    private static void extractAndUnpack(File dir, String app, String base, String authorPubkey, GenericUpdater.UpdaterInfo info, GenericUpdater.CACertsSource cacertsSource) throws IOException {
        InputStream in = AllPlatformWrapper.class.getResourceAsStream("/" + app);
        if (in == null) {
            throw new IOException("[AllPlatformWrapper] archive " + app + " not found");
        }
        File dest = new File(dir, app);
        Unarchiver unarchiver = new Unarchiver(null, null);
        unarchiver.unpackArchive(in, dest, authorPubkey, info, cacertsSource);
    }

    private boolean carryingNewerGU() {
        if (this.haveTailInClasspath) {
            System.out.println("[AllPlatformsWrapper] Checking to see if our GU version is newer");
            String jwVersion = this.guargs.getProperty("wrapper_gu_version");
            System.out.println("[AllPlatformsWrapper] Our GU version is " + jwVersion);
            if (jwVersion == null) {
                jwVersion = "";
            }
            if ((jwVersion = jwVersion.trim()).length() == 0) {
                System.out.println("[AllPlatformsWrapper] We have no GU version (looks like we are a launcher)");
            } else {
                File latest = LaunchFile.getLatestVersionOf("JWrapper", this.master);
                if (latest == null) {
                    System.out.println("[AllPlatformsWrapper] No existing GU found (so we are newer)");
                    return true;
                }
                String curVersion = LaunchFile.pickVersionFromAppFolder(latest);
                System.out.println("[AllPlatformsWrapper] Current GU version is " + curVersion);
                if (LaunchFile.versionIsLater(curVersion, jwVersion)) {
                    System.out.println("[AllPlatformsWrapper] Our version of GU is newer " + jwVersion + " > " + curVersion);
                    return true;
                }
                System.out.println("[AllPlatformsWrapper] Current GU version is same or newer");
            }
        }
        return false;
    }

    private boolean carryingNewerApp() {
        if (this.haveTailInClasspath) {
            System.out.println("[AllPlatformsWrapper] Checking to see if our App version is newer");
            String appName = this.guargs.getProperty("app_name");
            String appVersion = this.guargs.getProperty("wrapper_app_version");
            if (appVersion == null) {
                appVersion = "";
            }
            if ((appVersion = appVersion.trim()).length() == 0) {
                System.out.println("[AllPlatformsWrapper] We have no App version (we are onine wrapper or launcher)");
            } else {
                File latest = LaunchFile.getLatestVersionOf(appName, this.master);
                if (latest == null) {
                    System.out.println("[AllPlatformsWrapper] No existing App found (so we are newer)");
                    return true;
                }
                String curVersion = LaunchFile.pickVersionFromAppFolder(latest);
                if (LaunchFile.versionIsLater(curVersion, appVersion)) {
                    System.out.println("[AllPlatformsWrapper] Our version of " + appName + " is newer " + appVersion + " > " + curVersion);
                    return true;
                }
                System.out.println("[AllPlatformsWrapper] Current App version is same or newer");
            }
        }
        return false;
    }

    private void updateGU(String authorPubkey, byte[] cacerts) throws IOException, InterruptedException {
        System.out.println("[AllPlatformWrapper] Updating GU (will extract and unpack tail too if we have one)");
        if (this.haveTailInClasspath) {
            File f;
            String appName = this.guargs.getProperty("app_name");
            String jwVersion = this.guargs.getProperty("wrapper_gu_version");
            if (jwVersion == null) {
                jwVersion = "";
            }
            jwVersion = jwVersion.trim();
            String appVersion = this.guargs.getProperty("wrapper_app_version");
            if (appVersion != null && this.carryingNewerApp()) {
                f = this.createTempAppFolder();
                f.mkdir();
                System.out.println("[AllPlatformWrapper] Extracting App to " + f.getName());
                AllPlatformWrapper.extractAndUnpack(f, GenericUpdater.getArchiveNameFor(appName, appVersion), this.updateURL, authorPubkey, this.updaterInfo, new GenericUpdater.CACertsSource(cacerts));
                f.renameTo(new File(this.master, "JWrapper-" + appName + "-" + appVersion + "-complete"));
            } else {
                System.out.println("[AllPlatformWrapper] No App in tail (online wrapper)");
            }
            if (jwVersion != null && this.carryingNewerGU()) {
                f = this.createTempGuFolder();
                f.mkdir();
                System.out.println("[AllPlatformWrapper] Extracting GU to " + f.getName());
                AllPlatformWrapper.extractAndUnpack(f, GenericUpdater.getArchiveNameFor("JWrapper", jwVersion), this.updateURL, authorPubkey, this.updaterInfo, new GenericUpdater.CACertsSource(cacerts));
                File target = new File(this.master, "JWrapper-JWrapper-" + jwVersion + "-complete");
                f.renameTo(target);
                return;
            }
            System.out.println("[AllPlatformWrapper] Tail specified in classpath but no JW version in properties.  Likely we are an OSX launcher .app with no tail but installation is gone, exiting...");
            return;
        }
        File temp = this.createTempGuFolder();
        temp.mkdirs();
        String item = GenericUpdater.getArchiveNameFor("JWrapper", this.gu_version);
        URL url = new URL(this.updateURL + "/" + item);
        System.out.println("[AllPlatformWrapper] Downloading and unpacking " + url);
        Unarchiver unarchiver = new Unarchiver(null, null);
        unarchiver.downloadAndExtract(url, temp, authorPubkey, this.updaterInfo, new GenericUpdater.CACertsSource(cacerts));
        try {
            if (cacerts == null || cacerts.length == 0) {
                System.out.println("[AllPlatformWrapper] WARNING: CACerts could not be written (" + temp + "," + cacerts + ")");
            } else {
                System.out.println("[AllPlatformWrapper] Writing cacerts to " + new File(temp, "cacerts"));
                FileUtil.writeFile(new File(temp, "cacerts"), cacerts);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        File target = new File(this.master, GenericUpdater.getAppFolderNameFor("JWrapper", this.gu_version));
        long giveUp = System.currentTimeMillis() + 4000L;
        while (!temp.renameTo(target)) {
            Thread.sleep(200L);
            if (System.currentTimeMillis() <= giveUp) continue;
            throw new IOException("Could not rename App folder to proper name");
        }
    }

    private void updateJREdownload(String jreAppName, String authorPubkey, byte[] cacerts) throws IOException, InterruptedException {
        File targetCACerts;
        System.out.println("[AllPlatformWrapper] AUTOTEST_JRE_DOWNLOAD");
        System.out.println("[AllPlatformWrapper] Updating JRE (download)");
        String jre_version = this.downloadAsStringUTF8(this.updateURL, GenericUpdater.getVersionFileNameFor(jreAppName));
        File temp = this.createTempGuFolder();
        temp.mkdirs();
        String item = GenericUpdater.getArchiveNameFor(jreAppName, jre_version);
        URL url = new URL(this.updateURL + "/" + item);
        System.out.println("[AllPlatformWrapper] Downloading and unpacking " + url);
        Unarchiver unarchiver = new Unarchiver(null, null);
        unarchiver.downloadAndExtract(url, temp, authorPubkey, this.updaterInfo, new GenericUpdater.CACertsSource(cacerts));
        System.out.println("[AllPlatformWrapper] Setting " + temp.getName() + " accessible for all users");
        JWGenericOS.setReadableForAllUsers(temp, true);
        JWGenericOS.setWritableForAllUsers(temp, false);
        if (OS.isMacOS()) {
            File jreDir = new File(this.master, GenericUpdater.getAppFolderNameFor(jreAppName, jre_version));
            File jreBundle = new File(this.master, jreDir.getName() + ".plugin");
            targetCACerts = new File(jreDir.getPath() + "/lib/security/cacerts");
            if (!targetCACerts.exists()) {
                System.out.println("[WARNING] Attempting to overwrite cacerts file but cannot locate it (" + targetCACerts.getAbsolutePath() + ")");
            }
            jreDir.mkdir();
            long giveUp = System.currentTimeMillis() + 4000L;
            while (!temp.renameTo(jreBundle)) {
                Thread.sleep(200L);
                if (System.currentTimeMillis() <= giveUp) continue;
                throw new IOException("Could not rename JRE App folder to proper name");
            }
            OSXBundleUtil.setupOrRepairOSXJreBundle(jreBundle, jreDir);
        } else {
            File target = new File(this.master, GenericUpdater.getAppFolderNameFor(jreAppName, jre_version));
            targetCACerts = new File(target.getPath() + "/lib/security/cacerts");
            if (!targetCACerts.exists()) {
                System.out.println("[WARNING] Attempting to overwrite cacerts file but cannot locate it (" + targetCACerts.getAbsolutePath() + ")");
            }
            long giveUp = System.currentTimeMillis() + 4000L;
            while (!temp.renameTo(target)) {
                Thread.sleep(200L);
                if (System.currentTimeMillis() <= giveUp) continue;
                throw new IOException("Could not rename JRE App folder to proper name");
            }
        }
        if (cacerts != null && cacerts.length > 0) {
            System.out.println("[AllPlatformWrapper] Overwriting cacerts now.");
            FileUtil.writeFile(targetCACerts, cacerts);
            System.out.println("[AllPlatformWrapper] Result is a cacerts of size " + targetCACerts.length());
        }
    }

    private byte[] download(String updateURL, String item) throws IOException {
        URL url = new URL(updateURL + "/" + item);
        url = URIUtil.tryGetSafeURLFrom(url);
        BufferedInputStream in = new BufferedInputStream(url.openStream(), 10000);
        byte[] dat = StreamUtils.readAll(in);
        ((InputStream)in).close();
        return dat;
    }

    private String downloadAsStringUTF8(String updateURL, String item) throws IOException {
        return new String(this.download(updateURL, item), "UTF8");
    }

    public void setProxyToUse(Proxy proxy, JWProxyCredentials.Credentials proxyCredentials) throws IOException {
        if (proxy != null) {
            File appsSharedConfigFolder;
            if (proxyCredentials != null) {
                System.out.println("[AllPlatformWrapper] Using proxy details " + proxy + " with credentials.");
            } else {
                System.out.println("[AllPlatformWrapper] Using proxy details: " + proxy);
            }
            JWDetectedProxy.DETECTED_PROXY_OK = true;
            JWDetectedProxy.DETECTED_PROXY = proxy;
            if (proxyCredentials != null) {
                JWDetectedProxy.setDetectedProxyAsDefault();
                JWProxyCredentials proxyCreds = new JWProxyCredentials();
                proxyCreds.setCredentialsFor(proxy, proxyCredentials);
                new JWProxyAuthenticator(proxyCreds);
            }
            if (!(appsSharedConfigFolder = new File(this.master, "JWAppsSharedConfig")).exists()) {
                System.out.println("[AllPlatformWrapper] Creating JWAppsSharedConfig folder");
                appsSharedConfigFolder.mkdirs();
            }
            File detectedProxies = new File(appsSharedConfigFolder, "DetectedProxies");
            File credentialsFile = new File(appsSharedConfigFolder, "ProxyCredentials");
            JWProxyList proxyList = new JWProxyList(10);
            proxyList.addProxyToFront(proxy);
            proxyList.saveToFile(detectedProxies);
            if (proxyCredentials != null) {
                JWProxyCredentials credentials = new JWProxyCredentials();
                credentials.loadFromFile(credentialsFile);
                credentials.setCredentialsFor(proxy, proxyCredentials);
                credentials.saveToFile(credentialsFile);
            }
        }
    }

    class NoJREException
    extends Exception {
        NoJREException() {
        }
    }
}

