/*
 * Decompiled with CFR 0.152.
 */
package jwrapper;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import jwrapper.LPUninstallerListener;
import jwrapper.SelfDelete;

public class HeadlessSwipeLoadUtil {
    public static boolean DEBUG_LOAD_SLOW = false;
    public static final String SmallDownload = "SmallDownload";
    public static final String SmallNoInternet = "SmallNoInternet";
    public static final String SmallLaunching = "SmallLaunching";
    public static final String SmallUninstall = "SmallUninstall";
    Class imgclazz;
    Class clazz;
    Object panel;
    byte[] buf;
    private Method setProgressMethod = null;
    String title = "";
    boolean isShowing = false;
    static Object exampleSplash;
    static byte[] exampleSplashPNG;
    static byte[] exampleLogoPNG;

    public HeadlessSwipeLoadUtil(boolean showUI) {
        try {
            this.buf = new byte[64000];
            if (showUI) {
                this.clazz = Class.forName("jwrapper.SwipeLoadPanel");
                this.imgclazz = Class.forName("java.awt.Image");
                this.panel = this.clazz.newInstance();
                System.out.println("Loaded progress panel OK");
            }
        }
        catch (Throwable t) {
            System.out.println("***WARNING - NON-UI SYSTEM?*** Unable to load panel " + t);
            t.printStackTrace();
        }
    }

    private Object getImage(String name) {
        if (this.panel == null) {
            return null;
        }
        try {
            return this.clazz.getDeclaredField(name).get(this.panel);
        }
        catch (Exception x) {
            return null;
        }
    }

    public void setProgress(double percentage) {
        try {
            if (this.panel != null && this.setProgressMethod == null) {
                this.setProgressMethod = this.clazz.getDeclaredMethod("setProgress", Double.TYPE);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        try {
            if (this.panel != null) {
                this.setProgressMethod.invoke(this.panel, new Double(percentage));
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void makeUninstaller(String title, Object logo, LPUninstallerListener listener) {
        if (this.panel == null) {
            return;
        }
        this.title = title;
        try {
            this.clazz.getDeclaredMethod("makeUninstaller", String.class, Object.class, LPUninstallerListener.class).invoke(this.panel, title, logo, listener);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void makeFrame(String title, Object logo) {
        if (this.panel == null) {
            return;
        }
        this.title = title;
        try {
            this.clazz.getDeclaredMethod("makeFrame", String.class, Object.class).invoke(this.panel, title, logo);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void disableButtons() {
        if (this.panel == null) {
            return;
        }
        try {
            this.clazz.getDeclaredMethod("disableButtons", new Class[0]).invoke(this.panel, new Object[0]);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void hideProgress() {
        if (this.panel == null) {
            return;
        }
        try {
            this.clazz.getDeclaredMethod("hideProgress", new Class[0]).invoke(this.panel, new Object[0]);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void hideFrame() {
        if (this.panel == null) {
            return;
        }
        try {
            this.clazz.getDeclaredMethod("hideFrame", new Class[0]).invoke(this.panel, new Object[0]);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void setPosition(int[] tmp) {
        if (this.panel == null) {
            return;
        }
        try {
            this.clazz.getDeclaredMethod("setPosition", int[].class).invoke(this.panel, new Object[]{tmp});
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public int[] getPosition() {
        if (this.panel == null) {
            return new int[0];
        }
        try {
            return (int[])this.clazz.getDeclaredMethod("getPosition", new Class[0]).invoke(this.panel, new Object[0]);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return new int[0];
        }
    }

    public void showFiniteProgress() {
        System.out.println("[Progress] Set to finite");
        if (this.panel == null) {
            return;
        }
        try {
            this.clazz.getDeclaredMethod("showFiniteProgress", new Class[0]).invoke(this.panel, new Object[0]);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void showInfiniteProgress() {
        System.out.println("[Progress] Set to infinite");
        if (this.panel == null) {
            return;
        }
        try {
            this.clazz.getDeclaredMethod("showInfiniteProgress", new Class[0]).invoke(this.panel, new Object[0]);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void preventWindowClose() {
        if (this.panel == null) {
            return;
        }
        try {
            this.clazz.getDeclaredMethod("preventWindowClose", new Class[0]).invoke(this.panel, new Object[0]);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void waitForAllSwipes() {
        if (this.panel == null) {
            return;
        }
        try {
            this.clazz.getDeclaredMethod("waitForAllSwipes", new Class[0]).invoke(this.panel, new Object[0]);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void swipeAllTo(String big, String small) {
        this.ensureShowing();
        if (this.panel == null) {
            return;
        }
        try {
            this.clazz.getDeclaredMethod("swipeAllTo", this.imgclazz, this.imgclazz).invoke(this.panel, this.getImage(big), this.getImage(small));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void swipeAllTo(Object big, Object small) {
        this.ensureShowing();
        if (this.panel == null) {
            return;
        }
        try {
            this.clazz.getDeclaredMethod("swipeAllTo", this.imgclazz, this.imgclazz).invoke(this.panel, big, small);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void invokeImageMethod(String method, String image) {
        if (this.panel == null) {
            return;
        }
        try {
            this.clazz.getDeclaredMethod(method, this.imgclazz).invoke(this.panel, this.getImage(image));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void invokeImageMethod(String method, Object image) {
        if (this.panel == null) {
            return;
        }
        try {
            this.clazz.getDeclaredMethod(method, this.imgclazz).invoke(this.panel, image);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public boolean isShowingFrame() {
        return this.isShowing;
    }

    public void ensureShowing() {
        if (!this.isShowing) {
            this.isShowing = true;
            if (this.panel == null) {
                return;
            }
            try {
                this.clazz.getDeclaredMethod("showFrame", new Class[0]).invoke(this.panel, new Object[0]);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public void setBigTo(String image) {
        this.invokeImageMethod("setBigTo", image);
    }

    public void setSmallTo(String image) {
        this.invokeImageMethod("setSmallTo", image);
    }

    public void swipeBigTo(String image) {
        this.ensureShowing();
        this.invokeImageMethod("swipeBigTo", image);
    }

    public void swipeSmallTo(String image) {
        this.ensureShowing();
        this.invokeImageMethod("swipeSmallTo", image);
    }

    public void setBigTo(Object image) {
        this.invokeImageMethod("setBigTo", image);
    }

    public void setSmallTo(Object image) {
        this.invokeImageMethod("setSmallTo", image);
    }

    public void swipeBigTo(Object image) {
        this.ensureShowing();
        this.invokeImageMethod("swipeBigTo", image);
    }

    public void swipeSmallTo(Object image) {
        this.ensureShowing();
        this.invokeImageMethod("swipeSmallTo", image);
    }

    public Object loadImage(byte[] dat) {
        try {
            Object image = Class.forName("javax.imageio.ImageIO").getDeclaredMethod("read", InputStream.class).invoke(null, new ByteArrayInputStream(dat));
            return image;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Object loadImage(File file) {
        try {
            Object image = Class.forName("javax.imageio.ImageIO").getDeclaredMethod("read", File.class).invoke(null, file);
            return image;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Object loadImage(URL url) {
        try {
            Object image = Class.forName("javax.imageio.ImageIO").getDeclaredMethod("read", URL.class).invoke(null, url);
            return image;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setMessage(String string) {
        if (this.panel == null) {
            return;
        }
        try {
            this.clazz.getDeclaredMethod("setMessage", String.class).invoke(this.panel, string);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void setMessage(String string, String string2) {
        if (this.panel == null) {
            return;
        }
        try {
            this.clazz.getDeclaredMethod("setMessage", String.class, String.class).invoke(this.panel, string, string2);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    static class UninstallExample
    extends Thread
    implements LPUninstallerListener {
        HeadlessSwipeLoadUtil swu;

        UninstallExample(HeadlessSwipeLoadUtil swu) {
            this.swu = swu;
        }

        @Override
        public void doUninstall() {
            this.swu.disableButtons();
            this.swu.swipeSmallTo(HeadlessSwipeLoadUtil.SmallUninstall);
            this.start();
        }

        @Override
        public void doExit() {
            System.exit(0);
        }

        @Override
        public void run() {
            this.swu.waitForAllSwipes();
            try {
                SelfDelete.deleteSelf(new File("/tmp/doesntexist"), new File[0], this.swu, this.swu.getTitle(), exampleSplashPNG, exampleLogoPNG);
            }
            catch (IOException x) {
                x.printStackTrace();
            }
        }
    }
}

