/*
 * Decompiled with CFR 0.152.
 */
package bcutil;

import bcutil.BCUtil;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import utils.stream.OpenByteArrayOutputStream;

public class BCUtilOutputStream
extends OutputStream {
    private static final int MAX = 40960;
    private long minBytesBetweenMarker = 0L;
    private byte[] marker = null;
    private BCUtil bcu;
    private DataOutputStream out;
    private long dataWrittenSinceLastMarker = 0L;
    private OpenByteArrayOutputStream bout = new OpenByteArrayOutputStream();

    public BCUtilOutputStream(OutputStream out, BCUtil bcu) {
        this.out = new DataOutputStream(out);
        this.bcu = bcu;
    }

    public BCUtilOutputStream(OutputStream out, BCUtil bcu, byte[] marker, long minBytesBetweenMarker) {
        this(out, bcu);
        this.marker = marker;
        this.minBytesBetweenMarker = minBytesBetweenMarker;
    }

    @Override
    public final void close() throws IOException {
        this.flush();
        this.out.close();
    }

    @Override
    public final void flush() throws IOException {
        if (this.bout.size() > 0) {
            this.writeChunk();
        }
        this.out.flush();
    }

    @Override
    public final void write(byte[] b) throws IOException {
        this.bout.write(b);
        if (this.bout.size() > 40960) {
            this.writeChunk();
        }
    }

    @Override
    public final void write(byte[] b, int off, int len) throws IOException {
        this.bout.write(b, off, len);
        if (this.bout.size() > 40960) {
            this.writeChunk();
        }
    }

    @Override
    public final void write(int b) throws IOException {
        this.bout.write(b);
        if (this.bout.size() > 40960) {
            this.writeChunk();
        }
    }

    private void writeChunk() throws IOException {
        if (this.marker != null) {
            if (this.dataWrittenSinceLastMarker > this.minBytesBetweenMarker) {
                this.out.write(this.marker);
                this.dataWrittenSinceLastMarker = 0L;
            }
            this.dataWrittenSinceLastMarker += (long)this.bout.size();
        }
        this.bcu.wrap(this.bout.getByteArray(), this.bout.size(), this.out);
        this.bout.reset();
    }
}

