#!/bin/sh
SH_DIRECTORY="`dirname $0`"

SH_CLASS=""
SH_JVMARGS=""
SH_APPARGS=""
SH_CP=""

startsWith()
{
        case "$1" in
                "$2"*)
                        return "1"
                                ;;
                *)
                        return "0"
                                ;;
        esac
}


processConfig() {
        PARSE_ON=false
        while IFS="$(printf '\t\n\r')" read -r line; do
                startsWith $line "#"
                COMMENT=$?
                startsWith $line "["
                MARKER=$?

                if [ "$COMMENT" = 1 ]; then
                        # echo "skip comment line"
                        :
                elif [ "$MARKER" = 1 ]; then
                        case "$line" in
                                *SimpleHelp*)
                                        PARSE_ON=true
                                        ;;
                                *)
                                        PARSE_ON=false
                                        ;;
                        esac
                elif $PARSE_ON; then
                        # Split the key=value
                        KEY="${line%%=*}"
                        VALUE="${line#*=}"
                        if [ "$KEY" = "class" ]; then
                                SH_CLASS=${VALUE}
                        elif [ "$KEY" = "jvmArg" ]; then
                                SH_JVMARGS="$SH_JVMARGS $VALUE"
                        elif [ "$KEY" = "appArg" ]; then
                                SH_APPARGS="$SH_APPARGS $VALUE"
                        elif [ "$KEY" = "cp" ]; then
                                if [ "${SH_CP}" = "" ]; then
                                        SH_CP="$VALUE"
                                else
                                        SH_CP="${SH_CP}:${VALUE}"
                                fi
                        fi
                fi
        done < $1
}

# Check that this is the correct folder
if [ -d "$SH_DIRECTORY/DEPLOY" ]; then
        cd $SH_DIRECTORY

        # Check for a distributed runtime
        if [ -f "./jre/bin/java" ]; then
                SH_LAUNCH="./jre/bin/java"
        else
                SH_LAUNCH="java"
        fi

        processConfig "lib/config.required"
        if [ -f "./configuration/config.configurable" ]; then
                processConfig "configuration/config.configurable"
        else
                processConfig "lib/config.configurable"
        fi

        LAUNCH="$SH_LAUNCH $SH_JVMARGS -cp ${SH_CP} ${SH_CLASS} ${SH_APPARGS}"
        $LAUNCH &
else
        (>&2 echo "Unable to launch SimpleHelp server. Installation not found.")
        exit 1
fi
