/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.nolaf;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.font.TextLayout;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import utils.swing.images.ImageHelper;
import utils.swing.images.ImageLoader;

public class NoLafButton
extends JButton {
    static String PKG = "utils/swing/nolaf/";
    BufferedImage[] normal = new BufferedImage[9];
    BufferedImage[] pressed = new BufferedImage[9];
    BufferedImage[] disabled = new BufferedImage[9];
    int TL = 0;
    int NTH = 1;
    int TR = 2;
    int WST = 3;
    int CENT = 4;
    int EST = 5;
    int BL = 6;
    int STH = 7;
    int BR = 8;
    int sidew;
    int sideh;
    Icon icon;
    Icon iconDisabled;
    private String text;

    private void splitUp(Image image, BufferedImage[] images) {
        BufferedImage bimg = ImageHelper.toBufferedImageRGB(image);
        int w = bimg.getWidth();
        int h = bimg.getHeight();
        this.sidew = (w - 2) / 2;
        this.sideh = (h - 2) / 2;
        images[this.TL] = bimg.getSubimage(0, 0, this.sidew, this.sideh);
        images[this.TR] = bimg.getSubimage(w - this.sidew, 0, this.sidew, this.sideh);
        images[this.BL] = bimg.getSubimage(0, h - this.sideh, this.sidew, this.sideh);
        images[this.BR] = bimg.getSubimage(w - this.sidew, h - this.sideh, this.sidew, this.sideh);
        images[this.WST] = bimg.getSubimage(0, this.sideh, this.sidew, h - this.sideh - this.sideh);
        images[this.EST] = bimg.getSubimage(w - this.sidew, this.sideh, this.sidew, h - this.sideh - this.sideh);
        images[this.NTH] = bimg.getSubimage(this.sidew, 0, w - this.sidew - this.sidew, this.sideh);
        images[this.STH] = bimg.getSubimage(this.sidew, h - this.sideh, w - this.sidew - this.sidew, this.sideh);
        images[this.CENT] = bimg.getSubimage(this.sidew, this.sideh, w - this.sidew - this.sidew, h - this.sideh - this.sideh);
    }

    public NoLafButton(Icon icon, Icon iconDisabled) {
        this(PKG + "blue-normal.png", PKG + "blue-pressed.png", PKG + "blue-disabled.png", icon, iconDisabled);
    }

    public NoLafButton(String imgNormal, String imgPressed, String imgDisabled, Icon icon, Icon iconDisabled) {
        this.icon = icon;
        this.iconDisabled = iconDisabled;
        try {
            this.splitUp(ImageLoader.loadImageNoCache(imgNormal), this.normal);
            this.splitUp(ImageLoader.loadImageNoCache(imgPressed), this.pressed);
            this.splitUp(ImageLoader.loadImageNoCache(imgDisabled), this.disabled);
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    @Override
    public void setText(String text) {
        this.text = text;
    }

    @Override
    public void paintComponent(Graphics g) {
        int i;
        Icon cur;
        BufferedImage[] imgs;
        Graphics2D g2 = (Graphics2D)g;
        int w = this.getWidth();
        int h = this.getHeight();
        if (!this.getModel().isEnabled()) {
            imgs = this.disabled;
            cur = this.iconDisabled;
        } else if (this.getModel().isPressed()) {
            imgs = this.pressed;
            cur = this.icon;
        } else {
            imgs = this.normal;
            cur = this.icon;
        }
        for (int y = 0; y < h; y += 2) {
            for (int x = 0; x < w; x += 2) {
                g.drawImage(imgs[this.CENT], x, y, null);
            }
        }
        for (i = this.sidew; i < w; i += 2) {
            g.drawImage(imgs[this.NTH], i, 0, null);
        }
        for (i = this.sidew; i < w; i += 2) {
            g.drawImage(imgs[this.STH], i, h - this.sideh, null);
        }
        for (i = this.sideh; i < h; i += 2) {
            g.drawImage(imgs[this.WST], 0, i, null);
        }
        for (i = this.sideh; i < h; i += 2) {
            g.drawImage(imgs[this.EST], w - this.sidew, i, null);
        }
        g.drawImage(imgs[this.TL], 0, 0, null);
        g.drawImage(imgs[this.TR], w - this.sidew, 0, null);
        g.drawImage(imgs[this.BL], 0, h - this.sideh, null);
        g.drawImage(imgs[this.BR], w - this.sidew, h - this.sideh, null);
        if (cur != null) {
            int ih;
            int iw;
            if (this.text == null) {
                iw = cur.getIconWidth();
                ih = cur.getIconHeight();
                cur.paintIcon(this, g, w / 2 - iw / 2, h / 2 - ih / 2);
            } else {
                iw = cur.getIconWidth();
                ih = cur.getIconHeight();
                cur.paintIcon(this, g, 10, h / 2 - ih / 2);
                TextLayout tl = new TextLayout(this.text, g2.getFont(), g2.getFontRenderContext());
                tl.draw(g2, 20 + iw, h / 2 + 2);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        String DIR = "src/utils/swing/nolaf/";
        Icon norm = ImageLoader.getImageIcon("Querying.png");
        Icon dis = ImageLoader.getImageIconDisabled("Querying.png");
        JFrame frame = new JFrame();
        frame.setBounds(0, 0, 600, 280);
        JPanel tmp = new JPanel();
        tmp.setLayout(new GridLayout(1, 3));
        NoLafButton noLafButton = new NoLafButton(DIR + "blue-normal.png", DIR + "blue-pressed.png", DIR + "blue-disabled.png", norm, dis);
        noLafButton.setText("aAsdakjsdljkYYjhltyjkrtyy");
        tmp.add(noLafButton);
        tmp.add(new NoLafButton(DIR + "blue-normal.png", DIR + "blue-pressed.png", DIR + "blue-disabled.png", norm, dis));
        NoLafButton disabled = new NoLafButton(DIR + "blue-normal.png", DIR + "blue-pressed.png", DIR + "blue-disabled.png", norm, dis);
        disabled.setEnabled(false);
        tmp.add(disabled);
        frame.getContentPane().add(tmp);
        frame.setVisible(true);
    }
}

