/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.icons.colorproviders;

import java.awt.Color;
import utils.swing.icons.colorproviders.StaticColorProvider;

public class HueColourProvider
extends StaticColorProvider {
    private final boolean colorUp;
    private final Color base;

    public HueColourProvider(Color brightBase) {
        this(brightBase, true);
    }

    public HueColourProvider(Color brightBase, boolean colorUp) {
        this.base = brightBase;
        this.colorUp = colorUp;
    }

    @Override
    protected Color produceNextColor() {
        if (this.colorUp) {
            return this.nextUpColor();
        }
        return this.nextDownColor();
    }

    protected Color nextUpColor() {
        double rand = Math.random();
        Color c = new Color((int)((double)this.base.getRed() + (double)(255 - this.base.getRed()) * rand), (int)((double)this.base.getGreen() + (double)(255 - this.base.getGreen()) * rand), (int)((double)this.base.getBlue() + (double)(255 - this.base.getBlue()) * rand));
        return c;
    }

    @Override
    protected Color produceNextBackgroundColor() {
        if (!this.colorUp) {
            return this.nextUpColor();
        }
        return this.nextDownColor();
    }

    protected Color nextDownColor() {
        double rand = Math.random();
        Color c = new Color((int)((double)this.base.getRed() * rand), (int)((double)this.base.getGreen() * rand), (int)((double)this.base.getBlue() * rand));
        return c;
    }

    public static void main(String[] args) {
        HueColourProvider hcp = new HueColourProvider(new Color(30, 30, 30), false);
        for (int i = 0; i < 10; ++i) {
            System.out.println("Background: " + hcp.nextBackgroundColor() + " Foreground: " + hcp.nextColor());
        }
    }
}

