/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.icons;

import aurelienribon.tweenengine.TweenEquation;
import aurelienribon.tweenengine.TweenEquations;
import java.awt.Color;

public class ProgressRef {
    private static final boolean extremeSmoothing = true;
    private final double accel = 1.15;
    private boolean smoothing = false;
    private Color foreground;
    private Color background;
    private SmoothedProgress start = new SmoothedProgress();
    private SmoothedProgress finish = new SmoothedProgress();
    private boolean selfConsuming = false;
    private boolean easeResult = false;
    private final TweenEquation easingFunction = TweenEquations.easeInOutCubic;

    public ProgressRef() {
        this(0.0);
    }

    public ProgressRef(double progress) {
        this(progress, false);
    }

    public ProgressRef(double progress, boolean ease) {
        this.finish.setActualValue(progress);
        this.easeResult = ease;
    }

    public void reset() {
        this.setProgress(0.0);
        this.setStart(0.0);
    }

    public void useSmoothing(boolean b) {
        this.smoothing = b;
    }

    public boolean isComplete() {
        if (!this.selfConsuming) {
            return this.finish.actualValue >= 1.0;
        }
        return this.finish.actualValue >= 1.0 && this.start.actualValue >= 1.0;
    }

    public double getActualProgress() {
        return this.finish.getActualValue();
    }

    public double getActualStart() {
        if (this.selfConsuming) {
            return this.start.getActualValue();
        }
        return 0.0;
    }

    public void setProgress(double v) {
        this.finish.setActualValue(v);
    }

    public void setStart(double v) {
        this.start.setActualValue(v);
    }

    public double getProgress() {
        return this.finish.getValue();
    }

    public double getStart() {
        if (this.selfConsuming) {
            return this.start.getValue();
        }
        return 0.0;
    }

    public Color getForeground() {
        return this.foreground;
    }

    public void setForeground(Color foreground) {
        this.foreground = foreground;
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color background) {
        this.background = background;
    }

    public boolean isSelfConsuming() {
        return this.selfConsuming;
    }

    class SmoothedProgress {
        double actualValue;
        double smoothedValue;
        private double speedmin;
        private double speed;

        SmoothedProgress() {
            this.speed = this.speedmin = 1.0E-4;
        }

        public double getActualValue() {
            return this.actualValue;
        }

        public void setActualValue(double d) {
            this.actualValue = Math.min(1.0, Math.max(0.0, d));
            if (this.actualValue >= 1.0) {
                this.smoothedValue = 1.0;
            }
        }

        public double getValue() {
            double result;
            if (ProgressRef.this.smoothing) {
                this.advance();
                result = this.smoothedValue;
            } else {
                result = this.actualValue;
            }
            if (ProgressRef.this.easeResult && ProgressRef.this.easingFunction != null) {
                return ProgressRef.this.easingFunction.compute((float)result);
            }
            return result;
        }

        private void advance() {
            if (this.actualValue == 1.0) {
                this.smoothedValue = 1.0;
            } else {
                double diff = this.actualValue - this.smoothedValue;
                if (diff > 0.01) {
                    double maxSpeed = this.calculateMaxSpeedToActual();
                    if (maxSpeed > this.speed * 1.15) {
                        this.speed *= 1.15;
                    } else {
                        this.speed /= 1.15;
                        if (this.speed < this.speedmin) {
                            this.speed = this.speedmin;
                        }
                    }
                    this.smoothedValue += this.speed;
                    if (this.smoothedValue > this.actualValue) {
                        this.smoothedValue = this.actualValue;
                        this.speed = this.speedmin;
                    }
                } else {
                    this.smoothedValue = this.actualValue;
                }
            }
        }

        private double calculateMaxSpeedToActual() {
            double diff = this.actualValue - this.smoothedValue;
            double maxSpeed = this.speedmin;
            while ((diff -= (maxSpeed *= 1.15)) > this.speed) {
            }
            return maxSpeed;
        }
    }
}

