/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.icons;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.util.LinkedList;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import utils.progtools.WeakReferenceTimerThread;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.icons.ProgressRef;
import utils.swing.icons.colorproviders.ColorProvider;
import utils.swing.images.ImageHelper;

public class CircularProgressIcon
implements Icon,
Runnable {
    private Icon alternate;
    Component c;
    WeakReferenceTimerThread wrt;
    ColorProvider colorProvider;
    protected int thick = SimpleHelpLookAndFeel.scale(20);
    private int buffer = 0;
    private boolean forceInnerSpace = true;
    private final int w;
    private final int h;
    private final Object list_LOCK = new Object();
    private final LinkedList<ProgressRef> list = new LinkedList();
    private boolean drawBackground = true;
    private boolean removeWhenDone = true;
    private boolean baseColorOnValue = false;
    private boolean fadeToTarget = false;
    private boolean drawDebugBorder = false;
    private int outerBuffer = 0;
    private int alpha = 255;
    private boolean ignoreWRT = true;

    public CircularProgressIcon(int w, int h, ColorProvider colorProvider) {
        this.w = w;
        this.h = h;
        this.colorProvider = colorProvider;
    }

    public void setForceInnerSpace(boolean b) {
        this.forceInnerSpace = b;
    }

    public void setArcDimensions(int thickness, int buffer) {
        this.thick = thickness;
        this.buffer = buffer;
    }

    public void setOuterBuffer(int outerBuffer) {
        this.outerBuffer = outerBuffer;
    }

    public void setBaseColorOnValue(boolean baseColorOnValue) {
        this.baseColorOnValue = baseColorOnValue;
    }

    public void setRemoveWhenDone(boolean remove) {
        this.removeWhenDone = remove;
    }

    public int getThickness() {
        return this.thick;
    }

    public void setAlternate(Icon icon) {
        this.alternate = icon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearProgressRefs() {
        Object object = this.list_LOCK;
        synchronized (object) {
            this.list.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProgressRef(ProgressRef ref) {
        Object object = this.list_LOCK;
        synchronized (object) {
            this.list.add(ref);
            this.generateColorsFor(ref);
        }
    }

    protected void generateColorsFor(ProgressRef ref) {
        ref.setForeground(this.colorProvider.nextColor(0.0));
        ref.setBackground(this.colorProvider.nextBackgroundColor(0.0));
    }

    public void setColorProvider(ColorProvider colorProvider) {
        this.colorProvider = colorProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getMaxVisibleRings() {
        int size = this.w - 2 * this.outerBuffer;
        Object object = this.list_LOCK;
        synchronized (object) {
            return Math.min(size / this.thick, this.list.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (!this.ignoreWRT && this.wrt == null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHints(ImageHelper.getQualityRenderingHints());
        Object object = this.list_LOCK;
        synchronized (object) {
            if (this.list.size() == 0) {
                if (this.alternate != null) {
                    this.alternate.paintIcon(c, g, x, y);
                }
                return;
            }
            if (this.removeWhenDone) {
                for (int i = this.list.size() - 1; i >= 0; --i) {
                    if (!(this.list.get(i).getProgress() >= 1.0)) continue;
                    this.list.remove(i);
                }
            }
            int size = this.w - 2 * this.outerBuffer;
            int add = this.outerBuffer;
            size -= this.thick / 2;
            add += this.thick / 4;
            BasicStroke fgStroke = new BasicStroke(this.thick / 2 - this.buffer, 0, 1);
            g2.setStroke(fgStroke);
            Composite oldComposite = g2.getComposite();
            try {
                g2.setComposite(AlphaComposite.getInstance(3, (float)this.alpha / 255.0f));
                for (int i = 0; i < this.list.size(); ++i) {
                    if (this.forceInnerSpace && size <= this.thick) {
                        break;
                    }
                    if (size < 1) {
                        break;
                    }
                    ProgressRef ref = this.list.get(i);
                    double complete = ref.getProgress();
                    double start = ref.getStart();
                    if (this.drawBackground) {
                        Arc2D.Double shape = new Arc2D.Double(x + add, y + add, size, size, 0.0, 360.0, 0);
                        if (this.baseColorOnValue) {
                            g2.setColor(this.colorProvider.nextBackgroundColor(complete));
                        } else {
                            g2.setColor(ref.getBackground());
                        }
                        g2.draw(shape);
                    }
                    double startAngle = 90.0 - 360.0 * start;
                    double endAngle = 90.0 - 360.0 * complete;
                    double extent = endAngle - startAngle;
                    if (start < complete) {
                        GeneralPath path = new GeneralPath();
                        Arc2D.Double shape = new Arc2D.Double(x + add, y + add, size, size, startAngle, extent, 0);
                        if (this.baseColorOnValue) {
                            g2.setColor(this.colorProvider.nextColor(complete));
                        } else if (this.fadeToTarget) {
                            g2.setColor(this.getFadeColour(ref.getForeground(), ref.getBackground(), complete));
                        } else {
                            g2.setColor(ref.getForeground());
                        }
                        path.append(shape, false);
                        g2.draw(shape);
                    }
                    size -= this.thick;
                    add += this.thick / 2;
                }
            }
            finally {
                g2.setComposite(oldComposite);
            }
        }
        if (this.drawDebugBorder) {
            g2.setStroke(new BasicStroke(1.0f));
            g2.setColor(Color.darkGray);
            g2.drawRect(x, y, this.w, this.h);
        }
    }

    private Color getFadeColour(Color fg, Color bg, double complete) {
        int rDiff = fg.getRed() - bg.getRed();
        int gDiff = fg.getGreen() - bg.getGreen();
        int bDiff = fg.getBlue() - bg.getBlue();
        return new Color(bg.getRed() + (int)(complete * (double)rDiff), bg.getGreen() + (int)(complete * (double)gDiff), bg.getBlue() + (int)(complete * (double)bDiff));
    }

    public void setDrawBackground(boolean drawBackground) {
        this.drawBackground = drawBackground;
    }

    @Override
    public int getIconWidth() {
        return this.w;
    }

    @Override
    public int getIconHeight() {
        return this.h;
    }

    public void setUpdateComponent(Component c) {
        this.c = c;
        if (this.wrt == null) {
            this.wrt = new WeakReferenceTimerThread(this, 40);
            this.wrt.start();
        }
    }

    public void setIgnoreWRTForSanitySake(boolean ignoreWRT) {
        this.ignoreWRT = ignoreWRT;
    }

    public boolean isOn() {
        return this.wrt != null;
    }

    public void switchOff() {
        if (this.wrt != null) {
            this.wrt.stop();
        }
        this.wrt = null;
        this.c.repaint();
    }

    public void switchOn() {
        this.setUpdateComponent(this.c);
    }

    @Override
    public void run() {
        this.c.repaint();
    }

    private void drawDebugBorder(boolean drawDebugBorder) {
        this.drawDebugBorder = drawDebugBorder;
    }

    public void setFadeToTargetColor(boolean fadeToTarget) {
        this.fadeToTarget = fadeToTarget;
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
    }

    public static class LabeledIcon
    extends JPanel {
        public LabeledIcon(String text, CircularProgressIcon icon) {
            super(new BorderLayout());
            JLabel top = new JLabel(icon);
            JLabel bottom = new JLabel(text);
            this.add((Component)top, "Center");
            this.add((Component)bottom, "South");
            icon.setUpdateComponent(top);
            icon.drawDebugBorder(true);
            bottom.setHorizontalAlignment(0);
            this.setBackground(SHStyle.PANEL_BACKGROUND_WHITE);
        }
    }
}

