/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.dialog.contents;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import utils.swing.components.ColorPropagatingPanel;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.dialog.contents.FixedWidthComponent;
import utils.swing.dialog.panels.DialogHandler;
import utils.swing.layout.GbPanel;

public class FixedWidthGbPanel
extends GbPanel
implements FixedWidthComponent {
    private int panelWidth;
    private boolean propagateColours;

    public FixedWidthGbPanel() {
    }

    public FixedWidthGbPanel(ScaledInsets insets) {
        super(insets);
    }

    public void setPropagateColours(boolean propagateColours) {
        this.propagateColours = propagateColours;
    }

    @Override
    public void setBackground(Color c) {
        super.setBackground(c);
        if (this.propagateColours) {
            for (Component cc : this.getComponents()) {
                if (!(cc instanceof JPanel) && !(cc instanceof JCheckBox) && !(cc instanceof ColorPropagatingPanel.Colourable) && !(cc instanceof JComboBox) && !(cc instanceof JRadioButton)) continue;
                cc.setBackground(c);
            }
        }
    }

    @Override
    public void setPreferredWidth(int panelWidth) {
        this.panelWidth = panelWidth;
        for (Component child : this.getComponents()) {
            if (!(child instanceof FixedWidthComponent)) continue;
            ((FixedWidthComponent)((Object)child)).setPreferredWidth(panelWidth);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        d.width = this.panelWidth;
        return d;
    }

    @Override
    public void setDialogHandler(DialogHandler handler) {
    }
}

