/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.customlaf;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollBarUI;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.SHScrollButton;
import utils.swing.customlaf.SHUI;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.switches.oem.OEMSwitches;

public class SHScrollBarUI
extends BasicScrollBarUI {
    public static final int WIDTH = UIManager.getInt("ScrollBar.width");
    private int orientation = -1;
    private boolean isRollover = false;
    private boolean wasRollover = false;

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.scrollbar.setBorder(null);
    }

    public static ComponentUI createUI(JComponent c) {
        return new SHScrollBarUI();
    }

    @Override
    protected JButton createDecreaseButton(int orientation) {
        return new SHScrollButton(orientation, WIDTH);
    }

    @Override
    protected JButton createIncreaseButton(int orientation) {
        return new SHScrollButton(orientation, WIDTH);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (this.orientation == -1) {
            this.orientation = this.scrollbar.getOrientation();
        }
        Rectangle trackBounds = this.getTrackBounds();
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        float strokeWidth = SHButtonUI.getBorderStrokeWidth();
        g2d.setStroke(SHButtonUI.getBorderStroke());
        g2d.setColor(SHUI.TRACK_FILL);
        g2d.fill(trackBounds);
        g2d.setColor(SHUI.TRACK_LINE);
        if (this.scrollbar.getOrientation() == 1) {
            g2d.draw(new Line2D.Float(c.getWidth(), 0.0f, c.getWidth(), c.getHeight()));
            g2d.draw(new Line2D.Float(0.0f, 0.0f, 0.0f, c.getHeight()));
        } else {
            g2d.draw(new Line2D.Float(0.0f, c.getHeight(), c.getWidth(), c.getHeight()));
            g2d.draw(new Line2D.Float(0.0f, 0.0f, c.getWidth(), 0.0f));
        }
        Rectangle thumbBounds = this.getThumbBounds();
        RoundRectangle2D.Double shape = this.scrollbar.getOrientation() == 1 ? new RoundRectangle2D.Double(thumbBounds.x, (float)thumbBounds.y + strokeWidth / 2.0f, (float)thumbBounds.width - strokeWidth / 2.0f, (float)(thumbBounds.height - 1) - strokeWidth, SimpleHelpLookAndFeel.scale(2), SimpleHelpLookAndFeel.scale(2)) : new RoundRectangle2D.Double((float)thumbBounds.x + strokeWidth / 2.0f, thumbBounds.y, (float)(thumbBounds.width - 1) - strokeWidth, (float)thumbBounds.height - strokeWidth / 2.0f, SimpleHelpLookAndFeel.scale(2), SimpleHelpLookAndFeel.scale(2));
        if (!OEMSwitches.DARK_THEME) {
            g2d.setPaint(SHButtonUI.getFill(SHUI.BUTTON_NORMAL, c.isEnabled(), thumbBounds.height, this.isDragging));
        } else {
            g2d.setPaint(SHUI.BUTTON_BLUE.border);
        }
        g2d.fill(shape);
        if (!OEMSwitches.DARK_THEME) {
            g2d.setColor(SHButtonUI.getBorderColor(SHUI.BUTTON_NORMAL, c.isEnabled()));
        } else {
            g2d.setColor(SHButtonUI.getBorderColor(SHUI.BUTTON_BLUE, c.isEnabled()));
        }
        g2d.draw(shape);
    }

    @Override
    protected BasicScrollBarUI.TrackListener createTrackListener() {
        return new MyTrackListener();
    }

    protected class MyTrackListener
    extends BasicScrollBarUI.TrackListener {
        protected MyTrackListener() {
            super(SHScrollBarUI.this);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            super.mouseReleased(e);
            SHScrollBarUI.this.scrollbar.repaint();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            super.mousePressed(e);
            SHScrollBarUI.this.scrollbar.repaint();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            SHScrollBarUI.this.isRollover = false;
            SHScrollBarUI.this.wasRollover = false;
            if (SHScrollBarUI.this.getThumbBounds().contains(e.getX(), e.getY())) {
                SHScrollBarUI.this.isRollover = true;
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            SHScrollBarUI.this.isRollover = false;
            if (SHScrollBarUI.this.isRollover != SHScrollBarUI.this.wasRollover) {
                SHScrollBarUI.this.scrollbar.repaint();
                SHScrollBarUI.this.wasRollover = SHScrollBarUI.this.isRollover;
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (SHScrollBarUI.this.getThumbBounds().contains(e.getX(), e.getY())) {
                SHScrollBarUI.this.isRollover = true;
            }
            super.mouseDragged(e);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (SHScrollBarUI.this.getThumbBounds().contains(e.getX(), e.getY())) {
                SHScrollBarUI.this.isRollover = true;
                if (!SHScrollBarUI.this.wasRollover) {
                    SHScrollBarUI.this.scrollbar.repaint();
                    SHScrollBarUI.this.wasRollover = SHScrollBarUI.this.isRollover;
                }
            } else {
                SHScrollBarUI.this.isRollover = false;
                if (SHScrollBarUI.this.wasRollover) {
                    SHScrollBarUI.this.scrollbar.repaint();
                    SHScrollBarUI.this.wasRollover = SHScrollBarUI.this.isRollover;
                }
            }
        }
    }
}

