/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.customlaf;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicLabelUI;
import sun.awt.AppContext;
import sun.swing.SwingUtilities2;
import utils.switches.oem.OEMSwitches;

public class SHLabelUI
extends BasicLabelUI {
    protected static SHLabelUI labelUI = new SHLabelUI();
    private static final Object BASIC_LABEL_UI_KEY = new Object();

    public static ComponentUI createUI(JComponent c) {
        if (System.getSecurityManager() != null) {
            AppContext appContext = AppContext.getAppContext();
            BasicLabelUI safeBasicLabelUI = (BasicLabelUI)appContext.get(BASIC_LABEL_UI_KEY);
            if (safeBasicLabelUI == null) {
                safeBasicLabelUI = new BasicLabelUI();
                appContext.put(BASIC_LABEL_UI_KEY, safeBasicLabelUI);
            }
            return safeBasicLabelUI;
        }
        return labelUI;
    }

    @Override
    protected void paintDisabledText(JLabel l, Graphics g, String s, int textX, int textY) {
        if (!OEMSwitches.DARK_THEME) {
            int accChar = l.getDisplayedMnemonicIndex();
            Color background = l.getBackground();
            g.setColor(background.brighter());
            SwingUtilities2.drawStringUnderlineCharAt(l, g, s, accChar, textX + 1, textY + 1);
            g.setColor(background.darker());
            SwingUtilities2.drawStringUnderlineCharAt(l, g, s, accChar, textX, textY);
        } else {
            g.setColor(UIManager.getColor("textInactiveText"));
            int accChar = l.getDisplayedMnemonicIndex();
            SwingUtilities2.drawStringUnderlineCharAt(l, g, s, accChar, textX + 1, textY + 1);
        }
    }
}

