/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.customlaf;

import java.awt.Color;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;
import javax.swing.border.SoftBevelBorder;
import javax.swing.border.TitledBorder;
import utils.swing.customlaf.SimpleHelpLookAndFeel;

public class SHBorderFactory {
    private static final Border sharedEtchedBorder = new EtchedBorder();
    private static final Border sharedRaisedBevel = new BevelBorder(0);
    private static final Border sharedLoweredBevel = new BevelBorder(1);
    private static final Border emptyBorder = BorderFactory.createEmptyBorder(0, 0, 0, 0);
    private static Border sharedSoftRaisedBevel;
    private static Border sharedSoftLoweredBevel;
    private static Border sharedRaisedEtchedBorder;

    private SHBorderFactory() {
    }

    public static Border createLineBorder(Color color) {
        return new LineBorder(color, SimpleHelpLookAndFeel.scale(1));
    }

    public static Border createLineBorder(Color color, int thickness) {
        return new LineBorder(color, SimpleHelpLookAndFeel.scale(thickness));
    }

    public static Border createLineBorder(Color color, int thickness, boolean rounded) {
        return new LineBorder(color, SimpleHelpLookAndFeel.scale(thickness), rounded);
    }

    public static Border createRaisedBevelBorder() {
        return SHBorderFactory.createSharedBevel(0);
    }

    public static Border createLoweredBevelBorder() {
        return SHBorderFactory.createSharedBevel(1);
    }

    public static Border createBevelBorder(int type) {
        return SHBorderFactory.createSharedBevel(type);
    }

    public static Border createBevelBorder(int type, Color highlight, Color shadow) {
        return new BevelBorder(type, highlight, shadow);
    }

    public static Border createBevelBorder(int type, Color highlightOuter, Color highlightInner, Color shadowOuter, Color shadowInner) {
        return new BevelBorder(type, highlightOuter, highlightInner, shadowOuter, shadowInner);
    }

    static Border createSharedBevel(int type) {
        if (type == 0) {
            return sharedRaisedBevel;
        }
        if (type == 1) {
            return sharedLoweredBevel;
        }
        return null;
    }

    public static Border createRaisedSoftBevelBorder() {
        if (sharedSoftRaisedBevel == null) {
            sharedSoftRaisedBevel = new SoftBevelBorder(0);
        }
        return sharedSoftRaisedBevel;
    }

    public static Border createLoweredSoftBevelBorder() {
        if (sharedSoftLoweredBevel == null) {
            sharedSoftLoweredBevel = new SoftBevelBorder(1);
        }
        return sharedSoftLoweredBevel;
    }

    public static Border createSoftBevelBorder(int type) {
        if (type == 0) {
            return SHBorderFactory.createRaisedSoftBevelBorder();
        }
        if (type == 1) {
            return SHBorderFactory.createLoweredSoftBevelBorder();
        }
        return null;
    }

    public static Border createSoftBevelBorder(int type, Color highlight, Color shadow) {
        return new SoftBevelBorder(type, highlight, shadow);
    }

    public static Border createSoftBevelBorder(int type, Color highlightOuter, Color highlightInner, Color shadowOuter, Color shadowInner) {
        return new SoftBevelBorder(type, highlightOuter, highlightInner, shadowOuter, shadowInner);
    }

    public static Border createEtchedBorder() {
        return sharedEtchedBorder;
    }

    public static Border createEtchedBorder(Color highlight, Color shadow) {
        return new EtchedBorder(highlight, shadow);
    }

    public static Border createEtchedBorder(int type) {
        switch (type) {
            case 0: {
                if (sharedRaisedEtchedBorder == null) {
                    sharedRaisedEtchedBorder = new EtchedBorder(0);
                }
                return sharedRaisedEtchedBorder;
            }
            case 1: {
                return sharedEtchedBorder;
            }
        }
        throw new IllegalArgumentException("type must be one of EtchedBorder.RAISED or EtchedBorder.LOWERED");
    }

    public static Border createEtchedBorder(int type, Color highlight, Color shadow) {
        return new EtchedBorder(type, highlight, shadow);
    }

    public static TitledBorder createTitledBorder(String title) {
        return new TitledBorder(title);
    }

    public static TitledBorder createTitledBorder(Border border) {
        return new TitledBorder(border);
    }

    public static TitledBorder createTitledBorder(Border border, String title) {
        return new TitledBorder(border, title);
    }

    public static TitledBorder createTitledBorder(Border border, String title, int titleJustification, int titlePosition) {
        return new TitledBorder(border, title, titleJustification, titlePosition);
    }

    public static TitledBorder createTitledBorder(Border border, String title, int titleJustification, int titlePosition, Font titleFont) {
        return new TitledBorder(border, title, titleJustification, titlePosition, titleFont);
    }

    public static TitledBorder createTitledBorder(Border border, String title, int titleJustification, int titlePosition, Font titleFont, Color titleColor) {
        return new TitledBorder(border, title, titleJustification, titlePosition, titleFont, titleColor);
    }

    public static Border createEmptyBorder() {
        return emptyBorder;
    }

    public static Border createEmptyBorder(int top, int left, int bottom, int right) {
        if (top == 0 && left == 0 && bottom == 0 && right == 0) {
            return SHBorderFactory.createEmptyBorder();
        }
        return new EmptyBorder(SimpleHelpLookAndFeel.scale(top), SimpleHelpLookAndFeel.scale(left), SimpleHelpLookAndFeel.scale(bottom), SimpleHelpLookAndFeel.scale(right));
    }

    public static CompoundBorder createCompoundBorder() {
        return new CompoundBorder();
    }

    public static CompoundBorder createCompoundBorder(Border outsideBorder, Border insideBorder) {
        return new CompoundBorder(outsideBorder, insideBorder);
    }

    public static MatteBorder createMatteBorder(int top, int left, int bottom, int right, Color color) {
        return new MatteBorder(top, left, bottom, right, color);
    }

    public static MatteBorder createMatteBorder(int top, int left, int bottom, int right, Icon tileIcon) {
        return new MatteBorder(top, left, bottom, right, tileIcon);
    }
}

